/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;

public enum OnParentVersion implements CndElement
{
    ABORT(6),
    COMPUTE(4),
    COPY(1),
    IGNORE(5),
    INITIALIZE(3),
    VARIANT(-1),
    VERSION(2);

    public static OnParentVersion DEFAULT_VALUE;
    private final int jcrValue;

    static {
        DEFAULT_VALUE = COPY;
    }

    public static OnParentVersion find(String notation) {
        OnParentVersion[] onParentVersionArray = OnParentVersion.values();
        int n = onParentVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OnParentVersion opv = onParentVersionArray[n2];
            if (opv.toCndNotation(CndElement.NotationType.LONG).equalsIgnoreCase(notation) || opv.toCndNotation(CndElement.NotationType.COMPRESSED).equalsIgnoreCase(notation) || opv.toCndNotation(CndElement.NotationType.COMPACT).equalsIgnoreCase(notation)) {
                return opv;
            }
            ++n2;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.invalidFindRequest, (Object)notation));
    }

    public static OnParentVersion findUsingJcrValue(int jcrValue) {
        OnParentVersion[] onParentVersionArray = OnParentVersion.values();
        int n = onParentVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OnParentVersion opv = onParentVersionArray[n2];
            if (opv.asJcrValue() == jcrValue) {
                return opv;
            }
            ++n2;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.invalidFindUsingJcrValueRequest, (Object)jcrValue));
    }

    public static String[] toArray() {
        OnParentVersion[] allOpv = OnParentVersion.values();
        String[] notations = new String[allOpv.length];
        int i = 0;
        OnParentVersion[] onParentVersionArray = allOpv;
        int n = allOpv.length;
        int n2 = 0;
        while (n2 < n) {
            OnParentVersion opv = onParentVersionArray[n2];
            notations[i++] = opv.toCndNotation(CndElement.NotationType.LONG);
            ++n2;
        }
        return notations;
    }

    private OnParentVersion(int jcrValue) {
        this.jcrValue = jcrValue;
    }

    public int asJcrValue() {
        return this.jcrValue;
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        if (this == DEFAULT_VALUE && CndElement.NotationType.LONG != notationType) {
            return "";
        }
        if (this == VARIANT) {
            return "OPV?";
        }
        return super.toString();
    }
}

