/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.Activator;
import org.jboss.tools.modeshape.jcr.ItemDefinition;
import org.jboss.tools.modeshape.jcr.ItemOwnerProvider;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.attributes.DefaultType;
import org.jboss.tools.modeshape.jcr.attributes.NodeAttributes;
import org.jboss.tools.modeshape.jcr.attributes.OnParentVersion;
import org.jboss.tools.modeshape.jcr.attributes.RequiredTypes;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.cnd.CommentedCndElement;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;

public class ChildNodeDefinition
implements ItemDefinition,
NodeDefinitionTemplate {
    public static final String NOTATION_PREFIX = "+";
    private final NodeAttributes attributes;
    private String comment;
    private final DefaultType defaultType;
    private final CopyOnWriteArrayList<PropertyChangeListener> listeners;
    private final QualifiedName name;
    private final ItemOwnerProvider ownerProvider;
    private final RequiredTypes requiredTypes;

    public static ChildNodeDefinition copy(ChildNodeDefinition childNodeBeingCopied, ItemOwnerProvider ownerProvider) {
        ChildNodeDefinition copy = new ChildNodeDefinition(ownerProvider);
        copy.setName(childNodeBeingCopied.getName());
        copy.comment = childNodeBeingCopied.comment;
        copy.attributes.getAutocreated().set(childNodeBeingCopied.attributes.getAutocreated().get());
        copy.attributes.getMandatory().set(childNodeBeingCopied.attributes.getMandatory().get());
        copy.attributes.getProtected().set(childNodeBeingCopied.attributes.getProtected().get());
        copy.attributes.getSameNameSiblings().set(childNodeBeingCopied.attributes.getSameNameSiblings().get());
        copy.attributes.setOnParentVersion(childNodeBeingCopied.attributes.getOnParentVersion());
        copy.defaultType.set(childNodeBeingCopied.defaultType.get());
        copy.defaultType.setDefaultType(childNodeBeingCopied.getDefaultPrimaryTypeName());
        copy.requiredTypes.set(childNodeBeingCopied.requiredTypes.get());
        String[] stringArray = childNodeBeingCopied.getRequiredPrimaryTypeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredTypeName = stringArray[n2];
            copy.addRequiredType(requiredTypeName);
            ++n2;
        }
        return copy;
    }

    public ChildNodeDefinition(ItemOwnerProvider ownerProvider) {
        Utils.verifyIsNotNull(ownerProvider, "ownerProvider");
        this.ownerProvider = ownerProvider;
        this.attributes = new NodeAttributes();
        this.name = new QualifiedName();
        this.defaultType = new DefaultType();
        this.requiredTypes = new RequiredTypes();
        this.listeners = new CopyOnWriteArrayList();
    }

    public boolean addListener(PropertyChangeListener newListener) {
        Utils.verifyIsNotNull(newListener, "newListener");
        return this.listeners.addIfAbsent(newListener);
    }

    public boolean addRequiredType(String requiredTypeBeingAdded) {
        if (this.requiredTypes.add(QualifiedName.parse(requiredTypeBeingAdded))) {
            this.notifyChangeListeners(PropertyName.REQUIRED_TYPES, null, requiredTypeBeingAdded);
            return true;
        }
        return false;
    }

    public boolean allowsSameNameSiblings() {
        return this.attributes.getSameNameSiblings().is();
    }

    public boolean changeState(PropertyName propertyName, AttributeState.Value newState) {
        Utils.verifyIsNotNull((Object)propertyName, "propertyName");
        Utils.verifyIsNotNull((Object)newState, "newState");
        Enum oldValue = null;
        Enum newValue = newState;
        boolean changed = false;
        if (PropertyName.AUTOCREATED == propertyName) {
            oldValue = this.attributes.getAutocreated().get();
            changed = this.attributes.getAutocreated().set(newState);
        } else if (PropertyName.DEFAULT_TYPE == propertyName) {
            oldValue = this.defaultType.get();
            changed = this.defaultType.set(newState);
        } else if (PropertyName.MANDATORY == propertyName) {
            oldValue = this.attributes.getMandatory().get();
            changed = this.attributes.getMandatory().set(newState);
        } else if (PropertyName.ON_PARENT_VERSION == propertyName) {
            if (AttributeState.Value.VARIANT == newState) {
                oldValue = this.attributes.getOnParentVersion();
                newValue = OnParentVersion.VARIANT;
                changed = this.attributes.setOnParentVersion(OnParentVersion.VARIANT);
            }
        } else if (PropertyName.PROTECTED == propertyName) {
            oldValue = this.attributes.getProtected().get();
            changed = this.attributes.getProtected().set(newState);
        } else if (PropertyName.REQUIRED_TYPES == propertyName) {
            oldValue = this.requiredTypes.get();
            changed = this.requiredTypes.set(newState);
        } else if (PropertyName.SAME_NAME_SIBLINGS == propertyName) {
            oldValue = this.attributes.getSameNameSiblings().get();
            changed = this.attributes.getSameNameSiblings().set(newState);
        }
        if (changed) {
            this.notifyChangeListeners(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    public boolean clearRequiredTypes() {
        String[] oldValue = this.requiredTypes.toArray();
        if (this.requiredTypes.clear()) {
            this.notifyChangeListeners(PropertyName.REQUIRED_TYPES, oldValue, null);
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(ItemDefinition itemDefinition) {
        return this.getQualifiedName().compareTo(itemDefinition.getQualifiedName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ChildNodeDefinition that = (ChildNodeDefinition)obj;
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        if (!Utils.equals(this.getName(), that.getName())) {
            return false;
        }
        if (!Utils.equals(this.getDefaultPrimaryTypeName(), that.getDefaultPrimaryTypeName())) {
            return false;
        }
        if (!Utils.equals(this.getDeclaringNodeTypeDefinitionName(), that.getDeclaringNodeTypeDefinitionName())) {
            return false;
        }
        if (!this.requiredTypes.equals(that.requiredTypes)) {
            return false;
        }
        return Utils.equals(this.comment, that.comment);
    }

    public String getAttributesCndNotation(CndElement.NotationType notationType) {
        String cndNotation = this.attributes.toCndNotation(notationType);
        if (cndNotation == null) {
            return "";
        }
        return cndNotation;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public NodeType getDeclaringNodeType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QualifiedName getDeclaringNodeTypeDefinitionName() {
        return this.ownerProvider.getOwnerQualifiedName();
    }

    public NodeType getDefaultPrimaryType() {
        throw new UnsupportedOperationException();
    }

    public String getDefaultPrimaryTypeName() {
        String primaryType = this.defaultType.getDefaultTypeName();
        if (Utils.isEmpty(primaryType)) {
            return null;
        }
        return primaryType;
    }

    public DefaultType getDefaultType() {
        return this.defaultType;
    }

    public String getName() {
        if (Utils.isEmpty(this.name.get())) {
            return null;
        }
        return this.name.get();
    }

    public int getOnParentVersion() {
        return this.attributes.getOnParentVersion().asJcrValue();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return this.name;
    }

    public String[] getRequiredPrimaryTypeNames() {
        return this.requiredTypes.toArray();
    }

    public NodeType[] getRequiredPrimaryTypes() {
        throw new UnsupportedOperationException();
    }

    public List<QualifiedName> getRequiredTypes() {
        return this.requiredTypes.getSupportedItems();
    }

    public String getRequiredTypesCndNotation(CndElement.NotationType notationType) {
        String cndNotation = this.requiredTypes.toCndNotation(notationType);
        if (cndNotation == null) {
            return "";
        }
        return cndNotation;
    }

    public AttributeState.Value getState(PropertyName propertyName) {
        Utils.verifyIsNotNull((Object)propertyName, "propertyName");
        if (PropertyName.AUTOCREATED == propertyName) {
            return this.attributes.getAutocreated().get();
        }
        if (PropertyName.DEFAULT_TYPE == propertyName) {
            return this.defaultType.get();
        }
        if (PropertyName.MANDATORY == propertyName) {
            return this.attributes.getMandatory().get();
        }
        if (PropertyName.PROTECTED == propertyName) {
            return this.attributes.getProtected().get();
        }
        if (PropertyName.REQUIRED_TYPES == propertyName) {
            return this.requiredTypes.get();
        }
        if (PropertyName.SAME_NAME_SIBLINGS == propertyName) {
            return this.attributes.getSameNameSiblings().get();
        }
        if (PropertyName.ON_PARENT_VERSION == propertyName) {
            if (this.isVariant(PropertyName.ON_PARENT_VERSION)) {
                return AttributeState.Value.VARIANT;
            }
            return AttributeState.Value.IS;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.invalidGetStateRequest, (Object)((Object)propertyName)));
    }

    public int hashCode() {
        return Utils.hashCode(this.attributes, this.name, this.defaultType, this.requiredTypes, this.getDeclaringNodeTypeDefinitionName(), this.comment);
    }

    public boolean isAutoCreated() {
        return this.attributes.getAutocreated().is();
    }

    public boolean isMandatory() {
        return this.attributes.getMandatory().is();
    }

    public boolean isProtected() {
        return this.attributes.getProtected().is();
    }

    public boolean isVariant(PropertyName propertyName) {
        Utils.verifyIsNotNull((Object)propertyName, "propertyName");
        if (PropertyName.ON_PARENT_VERSION == propertyName) {
            return this.attributes.getOnParentVersion() == OnParentVersion.VARIANT;
        }
        return this.getState(propertyName) == AttributeState.Value.VARIANT;
    }

    private void notifyChangeListeners(PropertyName property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, property.toString(), oldValue, newValue);
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((PropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception e) {
                if (Platform.isRunning()) {
                    Activator.get().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, null, (Throwable)e));
                } else {
                    System.err.print(e.getMessage());
                }
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    public boolean removeListener(PropertyChangeListener listener) {
        Utils.verifyIsNotNull(listener, "listener");
        return this.listeners.remove(listener);
    }

    public boolean removeRequiredType(String requiredTypeBeingRemoved) {
        QualifiedName qname = QualifiedName.parse(requiredTypeBeingRemoved);
        if (this.requiredTypes.remove(qname)) {
            this.notifyChangeListeners(PropertyName.REQUIRED_TYPES, requiredTypeBeingRemoved, null);
            return true;
        }
        return false;
    }

    public void setAutoCreated(boolean newAutocreated) {
        AttributeState.Value newState = newAutocreated ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.AUTOCREATED, newState);
    }

    @Override
    public boolean setComment(String newComment) {
        boolean changed;
        if (!Utils.isEmpty(newComment)) {
            newComment = newComment.trim();
        }
        String oldValue = this.comment;
        boolean bl = changed = !Utils.equivalent(this.comment, newComment);
        if (changed) {
            this.comment = newComment;
            this.notifyChangeListeners(PropertyName.COMMENT, oldValue, newComment);
        }
        return changed;
    }

    public void setDefaultPrimaryTypeName(String newTypeName) {
        String oldValue = this.defaultType.getDefaultTypeName();
        if (this.defaultType.setDefaultType(newTypeName)) {
            this.notifyChangeListeners(PropertyName.DEFAULT_TYPE, oldValue, newTypeName);
        }
    }

    public void setMandatory(boolean newMandatory) {
        AttributeState.Value newState = newMandatory ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.MANDATORY, newState);
    }

    public void setName(String newName) {
        String oldValue = this.getName();
        if (this.name.set(newName)) {
            this.notifyChangeListeners(PropertyName.NAME, oldValue, newName);
        }
    }

    public void setOnParentVersion(int newOpv) {
        int oldValue = this.attributes.getOnParentVersion().asJcrValue();
        if (this.attributes.setOnParentVersion(OnParentVersion.findUsingJcrValue(newOpv))) {
            this.notifyChangeListeners(PropertyName.ON_PARENT_VERSION, oldValue, newOpv);
        }
    }

    public boolean setOnParentVersion(String newOpv) {
        int oldValue = this.attributes.getOnParentVersion().asJcrValue();
        if (this.attributes.setOnParentVersion(OnParentVersion.find(newOpv))) {
            this.notifyChangeListeners(PropertyName.ON_PARENT_VERSION, oldValue, newOpv);
            return true;
        }
        return false;
    }

    public void setProtected(boolean newProtected) {
        AttributeState.Value newState = newProtected ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.PROTECTED, newState);
    }

    public void setRequiredPrimaryTypeNames(String[] newTypeNames) {
        String[] items = this.requiredTypes.toArray();
        boolean changed = this.requiredTypes.clear();
        if (!Utils.isEmpty(newTypeNames)) {
            String[] stringArray = newTypeNames;
            int n = newTypeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String typeName = stringArray[n2];
                if (this.requiredTypes.add(QualifiedName.parse(typeName))) {
                    changed = true;
                }
                ++n2;
            }
        }
        if (changed) {
            this.notifyChangeListeners(PropertyName.REQUIRED_TYPES, items, this.requiredTypes.getSupportedItems());
        }
    }

    public void setSameNameSiblings(boolean newAllowSameNameSiblings) {
        AttributeState.Value newState = newAllowSameNameSiblings ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.SAME_NAME_SIBLINGS, newState);
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        JcrPreferenceStore prefStore = JcrPreferenceStore.get();
        StringBuilder builder = new StringBuilder();
        if (!Utils.isEmpty(this.comment)) {
            String commentNotation = "";
            if (CndElement.NotationType.LONG == notationType) {
                commentNotation = String.valueOf(commentNotation) + '\n';
            }
            commentNotation = String.valueOf(commentNotation) + CommentedCndElement.Helper.addCommentCharacters(this.comment);
            builder.append(commentNotation);
        }
        builder.append(NOTATION_PREFIX);
        builder.append(CndElement.NotationType.LONG == notationType ? " " : "");
        String DELIM = prefStore.get(JcrPreferenceConstants.CndPreference.CHILD_NODE_PROPERTY_DELIMITER);
        builder.append(this.name.toCndNotation(notationType));
        Utils.build(builder, true, DELIM, this.requiredTypes.toCndNotation(notationType));
        Utils.build(builder, true, DELIM, this.defaultType.toCndNotation(notationType));
        Utils.build(builder, true, DELIM, this.attributes.toCndNotation(notationType));
        return builder.toString();
    }

    public static enum PropertyName {
        AUTOCREATED,
        COMMENT,
        DEFAULT_TYPE,
        MANDATORY,
        NAME,
        ON_PARENT_VERSION,
        PROTECTED,
        REQUIRED_TYPES,
        SAME_NAME_SIBLINGS;


        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + '.' + super.toString();
        }
    }
}

