/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.util;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.teiid.query.ui.builder.util.CriteriaStrategy;
import org.teiid.query.ui.builder.util.ICriteriaStrategy;

public abstract class ElementViewerFactory {
    private static ITreeContentProvider contentProvider;
    private static ILabelProvider labelProvider;
    private static ICriteriaStrategy criteriaStrategy;
    private static Object viewerInput;

    public static TreeViewer createElementViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2820);
        if (contentProvider != null) {
            viewer.setContentProvider((IContentProvider)contentProvider);
        }
        if (labelProvider != null) {
            viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        }
        viewer.setInput(viewerInput);
        return viewer;
    }

    public static void setViewerInput(Object input) {
        viewerInput = input;
    }

    public static void setContentProvider(ITreeContentProvider provider) {
        contentProvider = provider;
    }

    public static void setLabelProvider(ILabelProvider provider) {
        labelProvider = provider;
    }

    public static void setCriteriaStrategy(ICriteriaStrategy strategy) {
        criteriaStrategy = strategy;
    }

    public static ITreeContentProvider getContentProvider() {
        return contentProvider;
    }

    public static ILabelProvider getLabelProvider() {
        return labelProvider;
    }

    public static ICriteriaStrategy getCriteriaStrategy() {
        return criteriaStrategy;
    }

    public static ICriteriaStrategy getCriteriaStrategy(TreeViewer theElementViewer) {
        if (criteriaStrategy == null) {
            criteriaStrategy = new CriteriaStrategy(theElementViewer);
        }
        return criteriaStrategy;
    }
}

