/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.query.ui.builder.model.AbstractLanguageObjectEditorModel;

public class FunctionDisplayEditorModel
extends AbstractLanguageObjectEditorModel {
    private IFunction selectedFunction;

    public FunctionDisplayEditorModel() {
        super(IFunction.class);
    }

    public IFunction getFunction() {
        IFunction function = (IFunction)this.getLanguageObject();
        return function;
    }

    @Override
    public ILanguageObject getLanguageObject() {
        return this.selectedFunction;
    }

    @Override
    public boolean isComplete() {
        return this.selectedFunction != null;
    }

    public void selectFunction(IFunction theFunction) {
        boolean changed;
        boolean bl = changed = !this.sameAsSelectedFunction(theFunction);
        if (changed) {
            this.selectedFunction = theFunction;
            this.fireModelChanged("STATE_CHANGE");
        }
    }

    private void setFunction(IFunction theFunction) {
        this.notifyListeners = false;
        if (theFunction == null) {
            this.selectedFunction = null;
        } else {
            this.selectFunction(theFunction);
        }
        this.notifyListeners = true;
        this.fireModelChanged("SAVED");
    }

    private boolean sameAsSelectedFunction(IFunction newFunction) {
        boolean same = this.selectedFunction == null ? newFunction == null : this.selectedFunction.equals(newFunction);
        return same;
    }

    @Override
    public void setLanguageObject(ILanguageObject theLangObj) {
        if (!this.sameAsSelectedFunction((IFunction)theLangObj)) {
            super.setLanguageObject(theLangObj);
            this.setFunction((IFunction)theLangObj);
        }
    }

    @Override
    public void clear() {
        this.selectedFunction = null;
        super.clear();
    }
}

