/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.modelgenerator.wsdl.ModelBuildingException;
import org.teiid.designer.modelgenerator.wsdl.RelationalModelBuilder;
import org.teiid.designer.modelgenerator.wsdl.model.Model;
import org.teiid.designer.modelgenerator.wsdl.model.ModelGenerationException;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiPlugin;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.SelectWsdlOperationsPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.SelectWsdlPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsDetailsPage;
import org.teiid.designer.schema.tools.processing.SchemaProcessingException;
import org.teiid.designer.ui.common.wizard.AbstractWizard;

public class RelationalFromWSDLImportWizard
extends AbstractWizard
implements IImportWizard,
ModelGeneratorWsdlUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RelationalFromWSDLImportWizard.class);
    private static final String TITLE = RelationalFromWSDLImportWizard.getString("title");
    private static final ImageDescriptor IMAGE = ModelGeneratorWsdlUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import_wsdl.gif");
    private WSDLImportWizardManager importManager;
    private WizardPage selectWsdlPage;
    private WizardPage selectWsdlOperationsPage;
    private WizardPage operationsDetailsPage;
    private IStructuredSelection selection;

    public RelationalFromWSDLImportWizard() {
        super((AbstractUIPlugin)ModelGeneratorWsdlUiPlugin.getDefault(), TITLE, IMAGE);
    }

    private static String getString(String id) {
        return UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.importManager = new WSDLImportWizardManager();
        this.selection = currentSelection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        this.createWizardPages((ISelection)this.selection);
        this.setNeedsProgressMonitor(true);
    }

    public void createWizardPages(ISelection theSelection) {
        this.importManager = new WSDLImportWizardManager();
        this.selectWsdlPage = new SelectWsdlPage(this.importManager);
        this.selectWsdlPage.setPageComplete(false);
        this.addPage((IWizardPage)this.selectWsdlPage);
        this.selectWsdlOperationsPage = new SelectWsdlOperationsPage(this.importManager);
        this.selectWsdlOperationsPage.setPageComplete(false);
        this.addPage((IWizardPage)this.selectWsdlOperationsPage);
        this.operationsDetailsPage = new OperationsDetailsPage(this.importManager);
        this.operationsDetailsPage.setPageComplete(false);
        this.addPage((IWizardPage)this.operationsDetailsPage);
        ((SelectWsdlPage)this.selectWsdlPage).setInitialSelection(theSelection);
    }

    public boolean finish() {
        boolean result = false;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Changing Sql Connections", (Object)new Object());
                boolean succeeded = false;
                try {
                    try {
                        RelationalFromWSDLImportWizard.this.runFinish(monitor);
                        succeeded = true;
                    }
                    catch (ModelBuildingException mbe) {
                        mbe.printStackTrace(System.err);
                        throw new InvocationTargetException(mbe);
                    }
                    catch (Throwable t) {
                        throw new InvocationTargetException(t);
                    }
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        };
        try {
            try {
                ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
                dlg.run(true, true, op);
                result = true;
            }
            catch (Throwable err) {
                if (err instanceof InvocationTargetException) {
                    Throwable t = ((InvocationTargetException)err).getTargetException();
                    Status iteStatus = new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", 4, RelationalFromWSDLImportWizard.getString("importError.msg"), t);
                    ErrorDialog.openError((Shell)this.getShell(), (String)RelationalFromWSDLImportWizard.getString("importError.title"), (String)RelationalFromWSDLImportWizard.getString("importError.msg"), (IStatus)iteStatus);
                    t.printStackTrace(System.err);
                } else {
                    Status status = new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", 4, RelationalFromWSDLImportWizard.getString("importError.msg"), err);
                    ErrorDialog.openError((Shell)this.getShell(), (String)RelationalFromWSDLImportWizard.getString("importError.title"), (String)RelationalFromWSDLImportWizard.getString("importError.msg"), (IStatus)status);
                    err.printStackTrace(System.err);
                }
                this.dispose();
            }
        }
        finally {
            this.dispose();
        }
        return result;
    }

    public void runFinish(IProgressMonitor theMonitor) throws ModelBuildingException, SchemaProcessingException, ModelGenerationException {
        IContainer container = this.importManager.getViewModelLocation();
        Model model = this.importManager.getWSDLModel();
        RelationalModelBuilder modelBuilder = new RelationalModelBuilder(model, this.importManager.getConnectionProfile());
        try {
            modelBuilder.modelOperations(this.importManager.getSelectedOperations(), container);
        }
        catch (ModelWorkspaceException e) {
            e.printStackTrace();
        }
        catch (ModelerCoreException e) {
            e.printStackTrace();
        }
    }
}

