/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.InternalOpenable;
import org.teiid.designer.core.workspace.ModelBuffer;
import org.teiid.designer.core.workspace.ModelBufferImpl;
import org.teiid.designer.core.workspace.ModelBufferManager;
import org.teiid.designer.core.workspace.ModelStatusImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceImpl;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceItemImpl;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.Openable;
import org.teiid.designer.core.workspace.OpenableModelWorkspaceItemInfo;

public abstract class OpenableImpl
extends ModelWorkspaceItemImpl
implements Openable,
InternalOpenable {
    protected OpenableImpl(int type, ModelWorkspaceItem parent, String name) {
        super(type, parent, name);
    }

    @Override
    public IResource getCorrespondingResource() throws ModelWorkspaceException {
        return this.getUnderlyingResource();
    }

    @Override
    public Openable getOpenable() {
        return this;
    }

    @Override
    public IResource getUnderlyingResource() throws ModelWorkspaceException {
        IResource parentResource = this.fParent.getUnderlyingResource();
        if (parentResource == null) {
            return null;
        }
        int type = parentResource.getType();
        if (type == 2 || type == 4) {
            IContainer folder = (IContainer)parentResource;
            IResource resource = folder.findMember(this.fName);
            if (resource == null) {
                throw this.newNotPresentException();
            }
            return resource;
        }
        return parentResource;
    }

    protected void buildStructure(OpenableModelWorkspaceItemInfo info, IProgressMonitor monitor) throws ModelWorkspaceException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap newElements = new HashMap(11);
        info.setIsStructureKnown(this.generateInfos(info, monitor, newElements, this.getResource()));
        for (ModelWorkspaceItem key : newElements.keySet()) {
            Object value = newElements.get(key);
            ModelWorkspaceManager.getModelWorkspaceManager().putInfo(key, value);
        }
        ModelWorkspaceManager.getModelWorkspaceManager().putInfo(this, info);
    }

    protected abstract OpenableModelWorkspaceItemInfo createItemInfo();

    @Override
    protected void closing(Object info) {
        OpenableModelWorkspaceItemInfo openableInfo = (OpenableModelWorkspaceItemInfo)info;
        this.closeBuffer(openableInfo);
        super.closing(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openWhenClosed(IProgressMonitor pm) throws ModelWorkspaceException {
        ModelWorkspaceManager modelWorkspaceManager = ModelWorkspaceManager.getModelWorkspaceManager();
        synchronized (modelWorkspaceManager) {
            if (this.isOpen()) {
                return;
            }
            try {
                if (ModelWorkspaceManager.VERBOSE) {
                    System.out.println("OPENING Item (" + Thread.currentThread() + "): " + this.toStringWithAncestors());
                }
                this.openParent(pm);
                OpenableModelWorkspaceItemInfo info = this.createItemInfo();
                this.buildStructure(info, pm);
                this.opening(info);
                if (ModelWorkspaceManager.VERBOSE) {
                    System.out.println("-> Package cache size = " + ModelWorkspaceManager.getModelWorkspaceManager().cache.pkgSize());
                }
            }
            catch (ModelWorkspaceException e) {
                ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
                throw e;
            }
        }
    }

    protected abstract boolean generateInfos(OpenableModelWorkspaceItemInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws ModelWorkspaceException;

    @Override
    public boolean exists() {
        return this.parentExists() && this.resourceExists();
    }

    @Override
    public boolean hasChildren() throws ModelWorkspaceException {
        return this.getChildren().length > 0;
    }

    @Override
    public boolean hasUnsavedChanges() {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        if (this.hasBuffer()) {
            ModelBuffer buffer = this.getBufferManager().getOpenBuffer(this);
            if (buffer == null) {
                return false;
            }
            if (buffer.hasUnsavedChanges()) {
                return true;
            }
        }
        if (this.fType == 4 || this.fType == 2 || this.fType == 1) {
            Iterator openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasNext()) {
                ModelWorkspaceItem owner;
                ModelBuffer buffer = (ModelBuffer)openBuffers.next();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf(owner = (ModelWorkspaceItem)((Object)buffer.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        ModelWorkspaceManager modelWorkspaceManager = ModelWorkspaceManager.getModelWorkspaceManager();
        synchronized (modelWorkspaceManager) {
            return ModelWorkspaceManager.getModelWorkspaceManager().getInfo(this) != null;
        }
    }

    protected boolean isSourceElement() {
        return false;
    }

    public void makeConsistent(IProgressMonitor pm) throws ModelWorkspaceException {
        if (!this.isConsistent()) {
            this.buildStructure((OpenableModelWorkspaceItemInfo)this.getItemInfo(), pm);
        }
    }

    @Override
    public void open(IProgressMonitor pm) throws ModelWorkspaceException {
        if (!this.isOpen()) {
            this.openWhenClosed(pm);
        }
    }

    protected void openParent(IProgressMonitor pm) throws ModelWorkspaceException {
        OpenableImpl openableParent = (OpenableImpl)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.openWhenClosed(pm);
        }
    }

    protected boolean parentExists() {
        ModelWorkspaceItem parent = this.getParent();
        if (parent == null) {
            return true;
        }
        return parent.exists();
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ModelerCore.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return ModelWorkspaceImpl.getTarget((IContainer)workspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    @Override
    public void save(IProgressMonitor pm, boolean force) throws ModelWorkspaceException {
        if (this.isReadOnly() || ModelUtil.isIResourceReadOnly(this.getResource())) {
            throw new ModelWorkspaceException(new ModelStatusImpl(976, this));
        }
        ModelBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
            ((ModelBufferImpl)buf).refresh(pm);
        }
    }

    public void forceSave(IProgressMonitor pm) throws ModelWorkspaceException {
        ModelBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, true);
            this.makeConsistent(pm);
            ((ModelBufferImpl)buf).refresh(pm);
        }
    }

    protected ModelBufferManager getBufferManager() {
        return ModelBufferManager.getDefaultBufferManager();
    }

    public ModelBuffer getBufferHack() throws ModelWorkspaceException {
        ModelBuffer buf = this.getBuffer();
        if (!this.getResource().exists() && this.getResource().getLocation().toFile().exists()) {
            try {
                this.getResource().refreshLocal(2, null);
            }
            catch (CoreException err) {
                throw new ModelWorkspaceException(err);
            }
        }
        return buf;
    }

    public synchronized ModelBuffer getBuffer() throws ModelWorkspaceException {
        if (this.hasBuffer()) {
            ModelBuffer buffer;
            if (!this.isOpen()) {
                this.getItemInfo();
            }
            if ((buffer = this.getBufferManager().getOpenBuffer(this)) == null) {
                buffer = this.openBuffer(null);
            }
            return buffer;
        }
        return null;
    }

    protected ModelBuffer openBuffer(IProgressMonitor pm) throws ModelWorkspaceException {
        return null;
    }

    protected void closeBuffer(OpenableModelWorkspaceItemInfo info) {
        if (!this.hasBuffer()) {
            return;
        }
        ModelBuffer buffer = this.getBufferManager().getOpenBuffer(this);
        if (buffer != null) {
            buffer.close();
            this.getBufferManager().removeBuffer(buffer);
        }
    }

    protected boolean hasBuffer() {
        return false;
    }
}

