/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Checksum;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.util.ChecksumUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StreamPipe;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.XsdObjectExtension;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.container.DuplicateResourceException;
import org.teiid.designer.core.container.ResourceAction;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.transaction.MtkTransaction;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.workspace.ModelBuffer;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.Openable;
import org.teiid.designer.core.workspace.OpenableImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.extension.XPackage;

public class ModelBufferImpl
implements ModelBuffer {
    private final IFile file;
    private final Openable owner;
    private final ResourceSet emfResourceSet;
    private Resource emfResource;
    private ModelContents contents;
    private boolean readonly;
    private Map options;
    private long lastModificationStamp;
    private long lastChecksum;
    private long lastFileSize;
    private String errorMessage;
    private boolean inProcessOfSavingContents;

    public ModelBufferImpl(IFile file, Openable owner, ResourceSet emfResourceSet, boolean readonly) {
        this.file = file;
        this.owner = owner;
        if (file == null) {
            this.setReadOnly(readonly);
        }
        this.updateCachedFileInformation();
        this.emfResourceSet = emfResourceSet;
        this.emfResource = null;
        this.options = new HashMap();
        this.contents = null;
        this.inProcessOfSavingContents = false;
        this.errorMessage = null;
    }

    @Override
    public Resource getEmfResource() {
        return this.emfResource;
    }

    protected ResourceSet getEmfResourceSet() {
        return this.emfResourceSet;
    }

    public ModelContents getModelContents() {
        if (this.contents == null && this.emfResource != null) {
            this.contents = new ModelContents(this.emfResource);
        }
        return this.contents;
    }

    @Override
    public Openable getOwner() {
        return this.owner;
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.file;
    }

    @Override
    public boolean hasUnsavedChanges() {
        if (this.emfResource != null) {
            return this.emfResource.isModified();
        }
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.emfResource == null || !this.emfResource.isLoaded();
    }

    @Override
    public boolean isReadOnly() {
        if (this.file == null) {
            return this.readonly;
        }
        return ModelUtil.isIResourceReadOnly((IResource)this.file);
    }

    protected void setReadOnly(boolean readOnly) {
        this.readonly = readOnly;
    }

    @Override
    public void unload() {
        if (!this.isClosed()) {
            this.emfResource.unload();
            this.contents = null;
            this.updateCachedFileInformation();
            this.errorMessage = null;
        }
    }

    protected void refresh(IProgressMonitor progress) {
        if (this.file != null) {
            try {
                this.file.refreshLocal(2, progress);
                this.updateCachedFileInformation();
                this.errorMessage = null;
            }
            catch (CoreException err) {
                Object[] params = new Object[]{this.file.getFullPath().toString()};
                String msg = ModelerCore.Util.getString("ModelBufferImpl.Error_while_refreshing", params);
                throw new ModelerCoreRuntimeException((Throwable)err, msg);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void open(IProgressMonitor progress) {
        if (this.emfResourceSet == null || this.file == null) throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ModelBufferImpl.Can_not_open_Model_Buffer_with_both_a_null_ResourceSet_and_null_IFile_1", new Object[0]));
        IPath path = this.file.getLocation();
        URI uri = URI.createFileURI((String)path.toString());
        if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
            String pathInProj = String.valueOf(this.file.getProject().getName()) + '/' + this.file.getProjectRelativePath();
            Object[] params = new Object[]{pathInProj};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelBufferImpl.DEBUG.Opening_model", params));
        }
        boolean startedTxn = false;
        MtkTransaction txn = null;
        try {
            Container cntr;
            if (this.emfResourceSet instanceof Container && !(txn = (cntr = (Container)this.emfResourceSet).getEmfTransactionProvider().getCurrent()).isStarted()) {
                try {
                    txn.begin();
                    txn.setSignificant(false);
                    txn.setUndoable(false);
                    txn.setSource(cntr);
                    txn.setDescription("ModelBufferImpl.open(" + this.getUnderlyingResource().getName() + ")");
                }
                catch (ModelerCoreException e) {
                    ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                }
                startedTxn = true;
            }
            ResourceAction action = null;
            Resource duplicateOfResource = null;
            this.errorMessage = null;
            boolean justLoaded = false;
            try {
                action = ContainerImpl.getOrCreateResource(this.emfResourceSet, uri);
                this.emfResource = action.getResource();
                File file = this.file.getLocation().toFile();
                if (file.canRead() && file.exists() && file.length() != 0L && !this.emfResource.isLoaded()) {
                    this.emfResource.load(this.emfResourceSet.getLoadOptions());
                    justLoaded = true;
                }
            }
            catch (DuplicateResourceException e) {
                duplicateOfResource = e.getDuplicateOfModel();
                this.errorMessage = e.getMessage();
            }
            catch (Throwable t) {
                Object[] params = new Object[]{uri};
                String msg = ModelerCore.Util.getString("ModelBufferImpl.Error_creating_resource_for_URI", params);
                throw new ModelerCoreRuntimeException(t, msg);
            }
            if (this.emfResource != null) {
                if (this.emfResource instanceof EmfResource) {
                    this.contents = ((EmfResource)this.emfResource).getModelContents();
                    CoreArgCheck.isNotNull((Object)this.contents);
                }
                if (this.contents == null) {
                    this.contents = new ModelContents(this.emfResource);
                }
                OpenableImpl modelResource = (OpenableImpl)this.getOwner();
                modelResource.getBufferManager().registerEmfResource(this.emfResource, modelResource);
                if (justLoaded) {
                    this.getModelContents().getModelAnnotation();
                    try {
                        this.updateCachedFileInformation();
                    }
                    catch (Exception e) {
                        Object[] params = new Object[]{uri};
                        String msg = ModelerCore.Util.getString("ModelBufferImpl.Unable_to_initialize_new_model_URI", params);
                        throw new ModelerCoreRuntimeException((Throwable)e, msg);
                    }
                }
                if (!this.file.exists()) return;
                try {
                    this.file.setSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY, null);
                    return;
                }
                catch (CoreException e) {
                    ModelerCore.Util.log((Throwable)e);
                }
                return;
            }
            if (duplicateOfResource == null) throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ModelBufferImpl.Could_not_resolve_local_resource_for_{0}_1", (Object)uri));
            ModelResource duplicateOfModelResource = ModelerCore.getModelWorkspace().findModelResource(duplicateOfResource);
            if (duplicateOfModelResource == null) {
                throw new DuplicateResourceException(duplicateOfResource, null, this.errorMessage);
            }
            IPath duplicateOfModelPath = duplicateOfModelResource.getPath();
            try {
                this.file.setSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY, (Object)duplicateOfModelPath.toString());
                throw new DuplicateResourceException(duplicateOfResource, duplicateOfModelPath, this.errorMessage);
            }
            catch (CoreException err) {
                Object[] params = new Object[]{uri, duplicateOfModelPath};
                String msg = ModelerCore.Util.getString("ModelBufferImpl.Unable_to_mark_resource_as_duplicate", params);
                throw new ModelerCoreRuntimeException((Throwable)err, msg);
            }
        }
        finally {
            if (startedTxn && txn != null) {
                try {
                    txn.commit();
                }
                catch (ModelerCoreException e) {
                    ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
            if (this.emfResource != null) {
                this.emfResource.setModified(false);
            }
        }
    }

    protected void updateCachedFileInformation() {
        block19: {
            if (this.file == null) {
                this.lastModificationStamp = -1L;
                this.lastFileSize = 0L;
                this.lastChecksum = 0L;
            } else {
                this.lastModificationStamp = this.file.getModificationStamp();
                if (!this.file.exists()) {
                    this.lastFileSize = 0L;
                    this.lastChecksum = 0L;
                } else {
                    InputStream stream = null;
                    try {
                        try {
                            File rawFile;
                            IPath rawLocation = ModelUtil.getLocation((IResource)this.file);
                            if (rawLocation != null && (rawFile = new File(rawLocation.toString())).exists()) {
                                this.lastFileSize = rawFile.length();
                                stream = new FileInputStream(rawFile);
                                BufferedInputStream buffer = new BufferedInputStream(stream);
                                Checksum checksum = ChecksumUtil.computeChecksum((InputStream)buffer);
                                this.lastChecksum = checksum.getValue();
                            }
                        }
                        catch (Exception err) {
                            ModelerCore.Util.log((Throwable)err);
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    @Override
    public IStatus getErrors() {
        if (this.hasErrors()) {
            String msg = this.errorMessage != null ? this.errorMessage : "";
            return new Status(4, "org.teiid.designer.core", 0, msg, null);
        }
        return new Status(0, "org.teiid.designer.core", 0, "", null);
    }

    @Override
    public boolean hasErrors() {
        if (this.file == null) {
            return false;
        }
        Object duplicateOfModel = null;
        try {
            duplicateOfModel = this.file.getSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY);
        }
        catch (CoreException coreException) {}
        return duplicateOfModel != null;
    }

    @Override
    public void close() {
        block19: {
            if (this.emfResource != null) {
                if (this.file != null && ModelerCore.DEBUG_MODEL_WORKSPACE) {
                    String pathInProj = String.valueOf(this.file.getProject().getName()) + '/' + this.file.getProjectRelativePath();
                    Object[] params = new Object[]{pathInProj};
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelBufferImpl.DEBUG.Closing_model", params));
                }
                boolean startedTxn = false;
                UnitOfWork txn = null;
                try {
                    try {
                        Container cntr = ModelerCore.getModelContainer();
                        txn = cntr.getEmfTransactionProvider().getCurrent();
                        if (!txn.isStarted()) {
                            try {
                                txn.begin();
                                txn.setSignificant(false);
                                txn.setUndoable(false);
                                txn.setDescription("ModelBufferImpl.close(" + this.getUnderlyingResource().getName() + ")");
                            }
                            catch (ModelerCoreException e) {
                                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                            }
                            startedTxn = true;
                        }
                        OpenableImpl modelResource = (OpenableImpl)this.getOwner();
                        modelResource.getBufferManager().unregisterEmfResource(this.emfResource);
                        this.emfResource.unload();
                        this.contents = null;
                    }
                    catch (CoreException theException) {
                        ModelerCore.Util.log(4, (Throwable)theException, theException.getMessage());
                        if (startedTxn && txn != null) {
                            try {
                                txn.commit();
                            }
                            catch (ModelerCoreException e) {
                                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                            }
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (startedTxn && txn != null) {
                        try {
                            txn.commit();
                        }
                        catch (ModelerCoreException e) {
                            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                        }
                    }
                    throw throwable;
                }
                if (startedTxn && txn != null) {
                    try {
                        txn.commit();
                    }
                    catch (ModelerCoreException e) {
                        ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                    }
                }
            }
        }
        this.updateCachedFileInformation();
    }

    @Override
    public void save(IProgressMonitor progress, boolean force) throws ModelWorkspaceException {
        if (this.file == null) {
            return;
        }
        if (!ModelUtil.isLockedSourceObject(this.file) && ModelUtil.isIResourceReadOnly((IResource)this.file)) {
            String pathInProj = String.valueOf(this.file.getProject().getName()) + '/' + this.file.getProjectRelativePath();
            Object[] params = new Object[]{pathInProj};
            throw new ModelWorkspaceException(ModelerCore.Util.getString("ModelBufferImpl.Model_is_readonly", params));
        }
        try {
            StreamPipe pipe = new StreamPipe();
            InputStream istream = pipe.getInputStream();
            final OutputStream ostream = pipe.getOutputStream();
            if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
                String pathInProj = String.valueOf(this.file.getProject().getName()) + '/' + this.file.getProjectRelativePath();
                Object[] params = new Object[]{pathInProj};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelBufferImpl.DEBUG.Saving_model", params));
            }
            final Map theOptions = this.options;
            new Thread("ModelBuffer.Save"){

                @Override
                public void run() {
                    ModelBufferImpl.this.saveInTransaction(ostream, theOptions);
                }
            }.start();
            if (this.file.exists()) {
                this.file.refreshLocal(0, null);
                this.inProcessOfSavingContents = true;
                this.file.setContents(istream, force ? 3 : 2, progress);
            } else {
                this.inProcessOfSavingContents = true;
                this.file.create(istream, force ? 3 : 2, progress);
            }
            this.updateCachedFileInformation();
            this.inProcessOfSavingContents = false;
        }
        catch (CoreException e) {
            throw new ModelWorkspaceException(e);
        }
    }

    void saveInTransaction(OutputStream ostream, Map theOptions) {
        block31: {
            boolean startedTxn = false;
            UnitOfWork txn = null;
            try {
                try {
                    Container cntr = ModelerCore.getModelContainer();
                    txn = cntr.getEmfTransactionProvider().getCurrent();
                    if (!txn.isStarted()) {
                        try {
                            txn.begin();
                            txn.setSignificant(false);
                            txn.setUndoable(false);
                            txn.setDescription("ModelBufferImpl.saveInTransaction(" + this.getUnderlyingResource().getName() + ")");
                        }
                        catch (ModelerCoreException e) {
                            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                        }
                        startedTxn = true;
                    }
                    try {
                        try {
                            Resource resource = this.emfResource;
                            if (resource instanceof XSDResourceImpl) {
                                ModelAnnotation annotation = this.contents.getModelAnnotation();
                                XPackage extPackage = annotation.getExtensionPackage();
                                try {
                                    if (extPackage != null) {
                                        XsdObjectExtension.setExtensionPackage((XSDResourceImpl)resource, extPackage);
                                    } else {
                                        XsdObjectExtension.removeExtensionPackage((XSDResourceImpl)resource);
                                    }
                                }
                                catch (ModelerCoreException err) {
                                    ModelerCore.Util.log(4, err.getMessage());
                                }
                            }
                            this.emfResource.save(ostream, theOptions);
                        }
                        catch (IOException iOException) {
                            try {
                                ostream.close();
                            }
                            catch (IOException e1) {
                                String pathInProj = String.valueOf(this.file.getProject().getName()) + '/' + this.file.getProjectRelativePath();
                                Object[] params = new Object[]{pathInProj, e1.getMessage()};
                                ModelerCore.Util.log(1, (Throwable)e1, ModelerCore.Util.getString("ModelBufferImpl.Error_closing_stream", params));
                            }
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ostream.close();
                        }
                        catch (IOException e1) {
                            String pathInProj = String.valueOf(this.file.getProject().getName()) + '/' + this.file.getProjectRelativePath();
                            Object[] params = new Object[]{pathInProj, e1.getMessage()};
                            ModelerCore.Util.log(1, (Throwable)e1, ModelerCore.Util.getString("ModelBufferImpl.Error_closing_stream", params));
                        }
                        throw throwable;
                    }
                    try {
                        ostream.close();
                    }
                    catch (IOException e1) {
                        String pathInProj = String.valueOf(this.file.getProject().getName()) + '/' + this.file.getProjectRelativePath();
                        Object[] params = new Object[]{pathInProj, e1.getMessage()};
                        ModelerCore.Util.log(1, (Throwable)e1, ModelerCore.Util.getString("ModelBufferImpl.Error_closing_stream", params));
                    }
                }
                catch (CoreException theException) {
                    ModelerCore.Util.log(4, (Throwable)theException, theException.getMessage());
                    if (!startedTxn || txn == null) break block31;
                    try {
                        txn.commit();
                    }
                    catch (ModelerCoreException e) {
                        ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                    }
                }
            }
            finally {
                if (startedTxn && txn != null) {
                    try {
                        txn.commit();
                    }
                    catch (ModelerCoreException e) {
                        ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                    }
                }
            }
        }
    }

    public Map getOptions() {
        return this.options;
    }

    public void setOptions(Map map) {
        this.options = map;
    }

    @Override
    public long getLastModificationStamp() {
        return this.lastModificationStamp;
    }

    @Override
    public long getLastFileSize() {
        return this.lastFileSize;
    }

    @Override
    public long getLastChecksum() {
        return this.lastChecksum;
    }

    @Override
    public boolean isInProcessOfSaving() {
        return this.inProcessOfSavingContents;
    }
}

