/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationResult;

public class ValidationResultImpl
implements ValidationResult {
    private static final ValidationProblem[] EMPTY_ARRAY = new ValidationProblem[0];
    private boolean hasInitialized = false;
    private boolean isFatalObj = false;
    private boolean isFatalResource = false;
    private ArrayList problems;
    private String locationPath;
    private String locationUri;
    private String targetUri;
    private Object target;
    private Object location;

    public ValidationResultImpl(Object target) {
        this(target, null);
    }

    public ValidationResultImpl(Object target, Object location) {
        this.target = target;
        this.location = location;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public boolean isFatalObject(Object eObject) {
        if (eObject != null && eObject.equals(this.target)) {
            return this.isFatalObj;
        }
        return false;
    }

    @Override
    public boolean isFatalResource() {
        return this.isFatalResource;
    }

    @Override
    public ValidationProblem[] getProblems() {
        if (this.problems != null && this.problems.size() != 0) {
            ValidationProblem[] result = new ValidationProblem[this.problems.size()];
            this.problems.toArray(result);
            return result;
        }
        return EMPTY_ARRAY;
    }

    @Override
    public boolean hasProblems() {
        return this.problems != null && this.problems.size() > 0;
    }

    @Override
    public void addProblem(ValidationProblem problem) {
        if (problem != null) {
            boolean bl = this.isFatalObj = problem.getSeverity() == 4;
            if (this.problems == null) {
                this.problems = new ArrayList(1);
            }
            this.problems.add(problem);
            this.init(this.target, this.location);
        }
    }

    @Override
    public String getLocationPath() {
        return this.locationPath;
    }

    @Override
    public void setLocationPath(String locationPath) {
        CoreArgCheck.isNotNull((Object)locationPath);
        this.locationPath = locationPath;
    }

    @Override
    public String getLocationUri() {
        return this.locationUri;
    }

    @Override
    public String getTargetUri() {
        return this.targetUri;
    }

    @Override
    public void setFatalResource(boolean fatal) {
        this.isFatalResource = fatal;
    }

    private void init(Object target, Object location) {
        if (!this.hasInitialized) {
            this.initTarget(target);
            if (target != location) {
                this.initLocation(location);
            }
            this.hasInitialized = true;
        }
    }

    private void initTarget(Object target) {
        CoreArgCheck.isNotNull((Object)target);
        this.target = target;
        if (target instanceof EObject) {
            EObject eObj = (EObject)target;
            this.targetUri = ModelerCore.getModelEditor().getUri(eObj).toString();
            if (this.locationPath == null) {
                this.locationPath = ModelerCore.getModelEditor().getModelRelativePath(eObj).toString();
            }
            if (this.locationUri == null) {
                this.locationUri = this.targetUri;
            }
        } else if (target instanceof Resource) {
            this.targetUri = null;
            this.locationPath = ModelerCore.getModelEditor().getModelName((Resource)target);
            this.locationUri = null;
        } else if (target instanceof IResource) {
            this.targetUri = null;
            this.locationPath = ((IResource)target).getFullPath().toString();
            this.locationUri = null;
        }
    }

    private void initLocation(Object location) {
        if (location instanceof EObject) {
            EObject eObj = (EObject)location;
            this.locationPath = ModelerCore.getModelEditor().getModelRelativePath(eObj).toString();
            this.locationUri = ModelerCore.getModelEditor().getUri(eObj).toString();
            if (this.targetUri == null) {
                this.targetUri = this.locationUri;
            }
        } else if (location instanceof Resource) {
            this.locationPath = ModelerCore.getModelEditor().getModelName((Resource)location);
            this.locationUri = null;
        } else if (this.target instanceof IResource) {
            this.targetUri = null;
            this.locationPath = ((IResource)this.target).getFullPath().toString();
            this.locationUri = null;
        }
    }

    public String toString() {
        if (this.hasProblems()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getLocationPath());
            sb.append('\n');
            ValidationProblem[] problems = this.getProblems();
            int i = 0;
            while (i != problems.length) {
                ValidationProblem problem = problems[i];
                sb.append(problem.toString());
                sb.append('\n');
                ++i;
            }
            return sb.toString();
        }
        return "";
    }
}

