/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.teiid.core.designer.util.CoreArgCheck;

public class UriHelper {
    private UriHelper() {
    }

    public static URI makeAbsoluteUri(URI baseUri, URI theImportUri) {
        CoreArgCheck.isNotNull((Object)baseUri);
        CoreArgCheck.isNotNull((Object)theImportUri);
        String importUriString = URI.decode((String)theImportUri.toString());
        if (importUriString.startsWith("http:")) {
            return theImportUri;
        }
        if (importUriString.startsWith("mmuuid")) {
            return theImportUri;
        }
        URI importUri = theImportUri;
        if (baseUri.isHierarchical() && !baseUri.isRelative() && importUri.isRelative()) {
            importUri = importUri.resolve(baseUri);
        }
        return importUri;
    }

    public static URI makeAbsoluteUri(URI baseUri, String theImportUriString) {
        CoreArgCheck.isNotNull((Object)baseUri);
        CoreArgCheck.isNotNull((Object)theImportUriString);
        String importUriString = URI.decode((String)theImportUriString);
        if (importUriString.startsWith("http:")) {
            return URI.createURI((String)importUriString);
        }
        if (importUriString.startsWith("mmuuid")) {
            return URI.createURI((String)importUriString);
        }
        if (importUriString.startsWith("file:")) {
            return URI.createURI((String)importUriString);
        }
        return UriHelper.makeAbsoluteUri(baseUri, URI.createFileURI((String)importUriString));
    }

    public static String makeAbsolutePath(URI baseUri, URI theImportUri) {
        CoreArgCheck.isNotNull((Object)baseUri);
        CoreArgCheck.isNotNull((Object)theImportUri);
        String importUriString = URI.decode((String)theImportUri.toString());
        if (importUriString.startsWith("http:")) {
            return importUriString;
        }
        if (importUriString.startsWith("mmuuid")) {
            return importUriString;
        }
        URI importUri = UriHelper.makeAbsoluteUri(baseUri, theImportUri);
        File f = new File(importUri.toFileString());
        return f.getAbsolutePath();
    }

    public static String makeAbsolutePath(URI baseUri, String theImportUriString) {
        CoreArgCheck.isNotNull((Object)baseUri);
        CoreArgCheck.isNotNull((Object)theImportUriString);
        return UriHelper.makeAbsolutePath(baseUri.toFileString(), theImportUriString);
    }

    public static String makeAbsolutePath(String theBaseUriString, String theImportUriString) {
        CoreArgCheck.isNotNull((Object)theBaseUriString);
        CoreArgCheck.isNotNull((Object)theImportUriString);
        String baseUriString = URI.decode((String)theBaseUriString);
        String importUriString = URI.decode((String)theImportUriString);
        URI baseUri = URI.createFileURI((String)baseUriString);
        if (importUriString.startsWith("http:")) {
            return importUriString;
        }
        if (importUriString.startsWith("mmuuid")) {
            return importUriString;
        }
        if (importUriString.startsWith("file:")) {
            return URI.createURI((String)importUriString).toFileString();
        }
        URI importUri = URI.createFileURI((String)importUriString);
        if (baseUri.isHierarchical() && !baseUri.isRelative() && importUri.isRelative()) {
            importUri = importUri.resolve(baseUri);
        }
        File f = new File(importUri.toFileString());
        return f.getAbsolutePath();
    }

    public static URI makeRelativeUri(URI baseUri, URI theImportUri) {
        CoreArgCheck.isNotNull((Object)baseUri);
        CoreArgCheck.isNotNull((Object)theImportUri);
        String importUriString = URI.decode((String)theImportUri.toString());
        if (importUriString.startsWith("http:")) {
            return theImportUri;
        }
        if (importUriString.startsWith("mmuuid")) {
            return theImportUri;
        }
        URI importUri = theImportUri;
        if (importUri.isFile() && !importUri.isRelative()) {
            URI deresolvedURI;
            if (baseUri != null && !baseUri.isRelative() && baseUri.isHierarchical() && (deresolvedURI = importUri.deresolve(baseUri, true, true, false)).hasRelativePath()) {
                importUri = deresolvedURI;
            }
        } else {
            importUri = URI.createURI((String)importUriString);
        }
        return importUri;
    }

    public static URI makeRelativeUri(URI baseUri, String theImportUriString) {
        CoreArgCheck.isNotNull((Object)baseUri);
        CoreArgCheck.isNotNull((Object)theImportUriString);
        String importUriString = URI.decode((String)theImportUriString);
        if (importUriString.startsWith("http:")) {
            return URI.createURI((String)importUriString);
        }
        if (importUriString.startsWith("mmuuid")) {
            return URI.createURI((String)importUriString);
        }
        URI importUri = null;
        importUri = importUriString.startsWith("file:") ? URI.createURI((String)importUriString) : URI.createFileURI((String)importUriString);
        return UriHelper.makeRelativeUri(baseUri, importUri);
    }

    public static String makeRelativePath(URI baseUri, URI theImportUri) {
        CoreArgCheck.isNotNull((Object)baseUri);
        CoreArgCheck.isNotNull((Object)theImportUri);
        String importUriString = URI.decode((String)theImportUri.toString());
        if (importUriString.startsWith("http:")) {
            return importUriString;
        }
        if (importUriString.startsWith("mmuuid")) {
            return importUriString;
        }
        URI importUri = UriHelper.makeRelativeUri(baseUri, theImportUri);
        return URI.decode((String)importUri.toString());
    }

    public static String makeRelativePath(URI baseUri, String theImportUriString) {
        CoreArgCheck.isNotNull((Object)baseUri);
        CoreArgCheck.isNotNull((Object)theImportUriString);
        return UriHelper.makeRelativePath(baseUri.toFileString(), theImportUriString);
    }

    public static String makeRelativePath(String theBaseUriString, String theImportUriString) {
        URI deresolvedURI;
        CoreArgCheck.isNotNull((Object)theBaseUriString);
        CoreArgCheck.isNotNull((Object)theImportUriString);
        String baseUriString = URI.decode((String)theBaseUriString);
        String importUriString = URI.decode((String)theImportUriString);
        URI baseUri = URI.createFileURI((String)baseUriString);
        if (importUriString.startsWith("http:")) {
            return importUriString;
        }
        if (importUriString.startsWith("mmuuid")) {
            return importUriString;
        }
        URI importUri = null;
        importUri = importUriString.startsWith("file:") ? URI.createURI((String)importUriString) : URI.createFileURI((String)importUriString);
        if (importUri.isFile() && !importUri.isRelative() && baseUri != null && !baseUri.isRelative() && baseUri.isHierarchical() && (deresolvedURI = importUri.deresolve(baseUri, true, true, false)).hasRelativePath()) {
            importUri = deresolvedURI;
        }
        return URI.decode((String)importUri.toString());
    }
}

