/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorWithFinish;
import org.teiid.designer.core.workspace.ModelFolder;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;

public class ModelVisitorProcessor {
    public static final int DEPTH_ZERO = 0;
    public static final int DEPTH_ONE = 1;
    public static final int DEPTH_INFINITE = 2;
    public static final int MODE_ALL_CONTAINMENTS = 0;
    public static final int MODE_VISIBLE_CONTAINMENTS = 1;
    public static final int MODE_DEFAULT = 0;
    protected ModelVisitor visitor;
    protected Navigator navigator;

    public ModelVisitorProcessor(ModelVisitor visitor) {
        this(visitor, 0);
    }

    public ModelVisitorProcessor(ModelVisitor visitor, int mode) {
        CoreArgCheck.isNotNull((Object)visitor);
        this.assertValidMode(mode);
        this.visitor = visitor;
        switch (mode) {
            case 1: {
                this.navigator = new ItemProviderNavigator();
                break;
            }
            case 0: {
                this.navigator = new ContainmentNavigator();
            }
        }
    }

    public ModelVisitor getModelVisitor() {
        return this.visitor;
    }

    protected void assertValidMode(int mode) {
        if (mode == 0 || mode == 1) {
            return;
        }
        String msg = ModelerCore.Util.getString("ModelVisitorProcessor.Invalid_mode", new Object[0]);
        throw new IllegalArgumentException(msg);
    }

    protected void assertValidDepth(int depth) {
        if (depth == 2 || depth == 1 || depth == 0) {
            return;
        }
        String msg = ModelerCore.Util.getString("ModelVisitorProcessor.Invalid_depth", new Object[0]);
        throw new IllegalArgumentException(msg);
    }

    public void walk(ModelWorkspace workspace, int depth) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)workspace);
        this.assertValidDepth(depth);
        if (depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        ModelWorkspaceItem[] children = workspace.getChildren();
        int i = 0;
        while (i < children.length) {
            ModelWorkspaceItem child = children[i];
            if (child instanceof ModelProject) {
                this.walk((ModelProject)child, nextDepth);
            } else if (child instanceof ModelFolder) {
                this.walk((ModelFolder)child, nextDepth);
            } else if (child instanceof ModelResource) {
                this.walk((ModelResource)child, nextDepth);
            }
            ++i;
        }
    }

    public void walk(ModelProject project, int depth) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)project);
        this.assertValidDepth(depth);
        if (depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        ModelWorkspaceItem[] children = project.getChildren();
        int i = 0;
        while (i < children.length) {
            ModelWorkspaceItem child = children[i];
            if (child instanceof ModelFolder) {
                this.walk((ModelFolder)child, nextDepth);
            } else if (child instanceof ModelResource) {
                this.walk((ModelResource)child, nextDepth);
            }
            ++i;
        }
    }

    public void walk(ModelFolder folder, int depth) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)folder);
        this.assertValidDepth(depth);
        if (depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        ModelWorkspaceItem[] children = folder.getChildren();
        int i = 0;
        while (i < children.length) {
            ModelWorkspaceItem child = children[i];
            if (child instanceof ModelFolder) {
                this.walk((ModelFolder)child, nextDepth);
            } else if (child instanceof ModelResource) {
                this.walk((ModelResource)child, nextDepth);
            }
            ++i;
        }
    }

    public void walk(ModelResource startingResource, int depth) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)startingResource);
        this.assertValidDepth(depth);
        Resource resource = startingResource.getEmfResource();
        this.walk(resource, depth);
    }

    public void walk(Resource startingResource, int depth) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)startingResource);
        this.assertValidDepth(depth);
        if (!this.getModelVisitor().visit(startingResource) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        EList children = startingResource.getContents();
        for (EObject object : children) {
            this.walk(object, nextDepth);
        }
    }

    public void walk(EObject startingObject, int depth) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)startingObject);
        this.assertValidDepth(depth);
        if (!this.visitor.visit(startingObject) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        Object children = this.navigator.getChildren(startingObject);
        if (children instanceof List) {
            for (Object obj : (List)children) {
                if (!(obj instanceof EObject)) continue;
                this.walk((EObject)obj, nextDepth);
            }
        } else if (children instanceof EObject) {
            this.walk((EObject)children, nextDepth);
        }
        if (this.visitor instanceof ModelVisitorWithFinish) {
            ((ModelVisitorWithFinish)this.visitor).postVisit(startingObject);
        }
    }

    public void walk(Collection startingObjects, int depth) throws ModelerCoreException {
        this.walk(startingObjects, depth, true);
    }

    public void walk(Collection startingObjects, int depth, boolean skipDuplicateBranches) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)startingObjects);
        this.assertValidDepth(depth);
        Collection roots = skipDuplicateBranches ? this.removeDuplicates(startingObjects) : startingObjects;
        for (Object object : roots) {
            if (object == null) continue;
            if (object instanceof Resource) {
                this.walk((Resource)object, depth);
                continue;
            }
            if (object instanceof EObject) {
                this.walk((EObject)object, depth);
                continue;
            }
            if (object instanceof ModelResource) {
                this.walk((ModelResource)object, depth);
                continue;
            }
            if (object instanceof ModelProject) {
                this.walk((ModelProject)object, depth);
                continue;
            }
            if (object instanceof ModelFolder) {
                this.walk((ModelFolder)object, depth);
                continue;
            }
            if (!(object instanceof ModelWorkspace)) continue;
            this.walk((ModelWorkspace)object, depth);
        }
    }

    protected Collection removeDuplicates(Collection startingObjects) {
        if (startingObjects.size() < 2) {
            return startingObjects;
        }
        if (startingObjects instanceof Set) {
            return startingObjects;
        }
        LinkedList copy = new LinkedList(startingObjects);
        HashSet setOfUnique = new HashSet();
        boolean includesModelWorkspaceItems = false;
        Iterator iter = copy.iterator();
        while (iter.hasNext() && !includesModelWorkspaceItems) {
            Object obj = iter.next();
            if (obj instanceof ModelWorkspaceItem) {
                includesModelWorkspaceItems = true;
            }
            if (setOfUnique.contains(obj)) {
                iter.remove();
            }
            setOfUnique.add(obj);
        }
        Iterator iter2 = copy.iterator();
        while (iter2.hasNext()) {
            Object obj = iter2.next();
            boolean foundDuplicateBranch = this.isAncestorInList(obj, copy, includesModelWorkspaceItems);
            if (!foundDuplicateBranch) continue;
            iter2.remove();
        }
        return copy;
    }

    protected boolean isAncestorInList(Object child, Collection inputs, boolean useModelWorkspace) {
        Object parent = null;
        ModelResource modelResource = null;
        if (child instanceof EObject) {
            EObject childObject = (EObject)child;
            parent = childObject.eContainer();
            if (parent == null) {
                parent = childObject.eResource();
                if (useModelWorkspace && parent instanceof Resource) {
                    modelResource = ModelWorkspaceManager.getModelWorkspaceManager().findModelResource((Resource)parent);
                }
            }
        } else if (useModelWorkspace) {
            if (child instanceof Resource) {
                ModelResource mr = ModelWorkspaceManager.getModelWorkspaceManager().findModelResource((Resource)child);
                if (mr != null) {
                    parent = mr.getParent();
                }
            } else {
                if (child instanceof ModelWorkspace) {
                    return false;
                }
                if (child instanceof ModelWorkspaceItem) {
                    parent = ((ModelWorkspaceItem)child).getParent();
                }
            }
        }
        if (parent == null) {
            return false;
        }
        if (inputs.contains(parent)) {
            return true;
        }
        if (modelResource != null && inputs.contains(modelResource)) {
            return true;
        }
        return this.isAncestorInList(parent, inputs, useModelWorkspace);
    }

    protected class ContainmentNavigator
    extends Navigator {
        protected ContainmentNavigator() {
        }

        @Override
        public Object getChildren(EObject parent) {
            return parent.eContents();
        }
    }

    protected class ItemProviderNavigator
    extends Navigator {
        private AdapterFactory adapterFactory;

        public ItemProviderNavigator() {
            this.adapterFactory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
        }

        @Override
        public Object getChildren(EObject parent) {
            ITreeItemContentProvider provider = (ITreeItemContentProvider)this.adapterFactory.adapt((Notifier)parent, ITreeItemContentProvider.class);
            if (provider != null) {
                return provider.getChildren((Object)parent);
            }
            return null;
        }
    }

    protected abstract class Navigator {
        protected Navigator() {
        }

        public abstract Object getChildren(EObject var1);
    }
}

