/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.translators;

import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;

public class TranslatorPropertyDefinition
implements PropertyDefinition {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(TranslatorPropertyDefinition.class);
    private String defaultValue;
    private PropertyDefinition delegate;
    private String id;

    public static String validateName(String proposedName) {
        if (StringUtilities.isEmpty((String)proposedName)) {
            return ModelerCore.Util.getString(String.valueOf(PREFIX) + "emptyPropertyName", new Object[0]);
        }
        int i = 0;
        char[] cArray = proposedName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c)) {
                return ModelerCore.Util.getString(String.valueOf(PREFIX) + "invalidPropertyName", (Object)proposedName);
            }
            ++i;
            ++n2;
        }
        return null;
    }

    public static String validateValue(String proposedValue) {
        if (StringUtilities.isEmpty((String)proposedValue)) {
            return ModelerCore.Util.getString(String.valueOf(PREFIX) + "emptyPropertyValue", new Object[0]);
        }
        return null;
    }

    public TranslatorPropertyDefinition(PropertyDefinition delegate) {
        CoreArgCheck.isNotNull((Object)delegate);
        this.delegate = delegate;
    }

    public TranslatorPropertyDefinition(String id, String defaultValue) {
        CoreArgCheck.isNotEmpty((String)id);
        CoreArgCheck.isNotEmpty((String)defaultValue);
        this.id = id;
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getId().equals(((TranslatorPropertyDefinition)obj).getId());
    }

    public String[] getAllowedValues() {
        if (this.delegate != null) {
            return this.delegate.getAllowedValues();
        }
        return null;
    }

    public String getDefaultValue() {
        if (this.delegate != null) {
            return this.delegate.getDefaultValue();
        }
        return this.defaultValue;
    }

    public String getDescription() {
        if (this.delegate != null) {
            return this.delegate.getDescription();
        }
        return ModelerCore.Util.getString(String.valueOf(PREFIX) + "customPropertyDescription", new Object[0]);
    }

    public String getDisplayName() {
        if (this.delegate != null) {
            return this.delegate.getDisplayName();
        }
        return this.getId();
    }

    public String getId() {
        if (this.delegate != null) {
            return this.delegate.getId();
        }
        return this.id;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean isAdvanced() {
        if (this.delegate != null) {
            return this.delegate.isAdvanced();
        }
        return false;
    }

    public boolean isMasked() {
        if (this.delegate != null) {
            return this.delegate.isMasked();
        }
        return false;
    }

    public boolean isModifiable() {
        if (this.delegate != null) {
            return this.delegate.isModifiable();
        }
        return true;
    }

    public boolean isRequired() {
        if (this.delegate != null) {
            return this.delegate.isRequired();
        }
        return true;
    }

    public boolean isUserDefined() {
        return this.delegate == null;
    }

    public String isValidValue(String newValue) {
        if (this.delegate != null) {
            return this.delegate.isValidValue(newValue);
        }
        return TranslatorPropertyDefinition.validateValue(newValue);
    }

    public void markAsUserDefined(String defaultValue) {
        CoreArgCheck.isNotEmpty((String)defaultValue);
        if (this.delegate != null) {
            this.id = this.delegate.getId();
            this.delegate = null;
            this.defaultValue = defaultValue;
        }
    }
}

