/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EObjectCache;

public class EObjectCacheImpl
implements EObjectCache {
    private static final int MAX_MAP_SIZE = 1500;
    private static final int MAP_CONSOLIDATION_SIZE = 300;
    private final Collection mapOfMaps;
    private Map currentMap = this.createMap();

    public EObjectCacheImpl() {
        this.mapOfMaps = new ArrayList();
        this.mapOfMaps.add(this.currentMap);
    }

    @Override
    public void add(EObject[] values, boolean recurse) {
        int i = 0;
        while (i != values.length) {
            this.add(values[i], recurse);
            ++i;
        }
    }

    @Override
    public void add(EObject value, boolean recurse) {
        CoreArgCheck.isNotNull((Object)value);
        Object key = this.getCacheKey(value);
        Map eObjMap = this.findMapForKey(key);
        if (eObjMap != null) {
            eObjMap.remove(key);
        }
        if (this.currentMap.size() < 1500) {
            this.currentMap.put(key, value);
        } else {
            boolean newMap = true;
            for (Map next : this.mapOfMaps) {
                if (next == this.currentMap || next.size() >= 1500) continue;
                this.currentMap = next;
                this.currentMap.put(key, value);
                newMap = false;
                break;
            }
            if (newMap) {
                this.currentMap = this.createMap();
                this.mapOfMaps.add(this.currentMap);
                this.currentMap.put(key, value);
            }
        }
        if (recurse) {
            for (Object obj : value.eContents()) {
                if (!(obj instanceof EObject)) continue;
                this.add((EObject)obj, recurse);
            }
        }
    }

    @Override
    public void clear() {
        try {
            Iterator iter = this.mapOfMaps.iterator();
            while (iter.hasNext()) {
                Map next = (Map)iter.next();
                next.clear();
                iter.remove();
            }
            this.currentMap = this.createMap();
            this.mapOfMaps.add(this.currentMap);
        }
        finally {
            this.runGC();
        }
    }

    @Override
    public boolean containsKey(ObjectID key) {
        if (this.currentMap.containsKey(key)) {
            return true;
        }
        for (Map next : this.mapOfMaps) {
            if (next == this.currentMap || !next.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(EObject value) {
        if (this.currentMap.containsValue(value)) {
            return true;
        }
        for (Map next : this.mapOfMaps) {
            if (next == this.currentMap || !next.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EObject get(ObjectID key) {
        if (key == null) {
            return null;
        }
        Map map = this.findMapForKey(key);
        if (map != null) {
            return (EObject)map.get(key);
        }
        return null;
    }

    @Override
    public void remove(EObject value, boolean recurse) {
        CoreArgCheck.isNotNull((Object)value);
        Object key = this.getCacheKey(value);
        Map map = this.findMapForValue(value);
        if (map != null) {
            map.remove(key);
            if (map != this.currentMap && map.size() < 300) {
                this.consolidateMap(map);
            }
        }
        if (recurse) {
            for (Object obj : value.eContents()) {
                if (!(obj instanceof EObject)) continue;
                this.remove((EObject)obj, recurse);
            }
        }
    }

    @Override
    public void remove(EObject[] values, boolean recurse) {
        int i = 0;
        while (i != values.length) {
            this.remove(values[i], recurse);
            ++i;
        }
    }

    @Override
    public void remove(ObjectID key, boolean recurse) {
        CoreArgCheck.isNotNull((Object)key);
        EObject value = null;
        Map map = this.findMapForKey(key);
        if (map != null) {
            value = (EObject)map.remove(key);
            if (map != this.currentMap && map.size() < 300) {
                this.consolidateMap(map);
            }
        }
        if (recurse && value != null) {
            for (Object obj : value.eContents()) {
                if (!(obj instanceof EObject)) continue;
                this.remove((EObject)obj, recurse);
            }
        }
    }

    @Override
    public void remove(ObjectID[] keys, boolean recurse) {
        int i = 0;
        while (i != keys.length) {
            this.remove(keys[i], recurse);
            ++i;
        }
    }

    @Override
    public int size() {
        int size = 0;
        for (Map next : this.mapOfMaps) {
            size += next.size();
        }
        return size;
    }

    @Override
    public EObject[] values() {
        ArrayList values = new ArrayList(this.size());
        for (Map next : this.mapOfMaps) {
            values.addAll(next.values());
        }
        return values.toArray(new EObject[values.size()]);
    }

    protected Object getCacheKey(EObject value) {
        CoreArgCheck.isNotNull((Object)value);
        return ModelerCore.getObjectId(value);
    }

    protected void consolidateMap(Map map) {
        if (map == this.currentMap) {
            return;
        }
        try {
            int size = map.size();
            if (this.currentMap.size() + size < 1500) {
                this.currentMap.putAll(map);
                this.mapOfMaps.remove(map);
                return;
            }
            for (Map next : this.mapOfMaps) {
                if (next == this.currentMap || next.size() + size >= 1500) continue;
                next.putAll(map);
                this.mapOfMaps.remove(map);
                return;
            }
        }
        finally {
            this.runGC();
        }
    }

    protected Map findMapForValue(EObject eObject) {
        ObjectID id = ModelerCore.getObjectId(eObject);
        return this.findMapForKey(id);
    }

    protected Map findMapForKey(Object id) {
        if (id == null) {
            return null;
        }
        if (this.currentMap.containsKey(id)) {
            return this.currentMap;
        }
        for (Map next : this.mapOfMaps) {
            if (next == this.currentMap || !next.containsKey(id)) continue;
            return next;
        }
        return null;
    }

    protected Collection getMapOfMaps() {
        return this.mapOfMaps;
    }

    protected Map createMap() {
        return new HashMap();
    }

    protected void runGC() {
    }
}

