/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.refactor.IRefactorModelHandler;

public class RefactorModelExtensionManager {
    public static final String ID = "refactorModelHandler";
    public static final String REFACTOR_HANDLER_TAG = "refactorHandler";
    public static final String CLASSNAME = "name";
    private static Collection<IRefactorModelHandler> handlers;
    private static boolean handlersLoaded;

    static {
        handlersLoaded = false;
    }

    private static void loadExtensions() {
        HashMap<String, Object> extList = new HashMap<String, Object>();
        handlersLoaded = true;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.core", ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals(REFACTOR_HANDLER_TAG)) {
                        Object helper = elements[j].createExecutableExtension(CLASSNAME);
                        extList.put(elements[j].getAttribute(CLASSNAME), helper);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = ModelerCore.Util.getString("RefactorModelExtensionManager.loadingExtensionsErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                ModelerCore.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
        handlers = extList.values();
    }

    public static boolean preProcess(IRefactorModelHandler.RefactorType refactorType, IResource refactoredResource, IProgressMonitor monitor) {
        if (!handlersLoaded) {
            RefactorModelExtensionManager.loadExtensions();
        }
        for (IRefactorModelHandler handler : handlers) {
            if (handler.preProcess(refactorType, refactoredResource, monitor)) continue;
            return false;
        }
        return true;
    }

    public static void postProcess(IRefactorModelHandler.RefactorType refactorType, IResource refactoredResource) throws Exception {
        if (!handlersLoaded) {
            RefactorModelExtensionManager.loadExtensions();
        }
        for (IRefactorModelHandler handler : handlers) {
            handler.postProcess(refactorType, refactoredResource);
        }
    }
}

