/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.extension.XAttribute;
import org.teiid.designer.metamodels.core.extension.XClass;

public class XAttributeUniqueNameInXClassRule
implements ObjectValidationRule {
    @Override
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(XClass.class, (Object)eObject);
        XClass xclass = (XClass)eObject;
        HashMap<String, ArrayList<XAttribute>> xattributesByName = new HashMap<String, ArrayList<XAttribute>>();
        EList xattributes = xclass.getEAllAttributes();
        if (xattributes.isEmpty()) {
            ValidationResultImpl result = new ValidationResultImpl(xclass);
            String msg = ModelerCore.Util.getString("XAttributeUniqueNameInXClassRule.NoAttributeDefined", new Object[0]);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
        for (EAttribute attribute : xattributes) {
            XAttribute xattribute;
            String name;
            if (!(attribute instanceof XClass) || (name = (xattribute = (XAttribute)attribute).getName()) == null) continue;
            ArrayList<XAttribute> xattributesForName = (ArrayList<XAttribute>)xattributesByName.get(name);
            if (xattributesForName == null) {
                xattributesForName = new ArrayList<XAttribute>(5);
                xattributesByName.put(name, xattributesForName);
            }
            xattributesForName.add(xattribute);
        }
        for (Map.Entry entry : xattributesByName.entrySet()) {
            List xattributesWithSameName = (List)entry.getValue();
            int numDuplicates = xattributesWithSameName.size();
            if (numDuplicates <= 1) continue;
            Integer numOthers = new Integer(numDuplicates - 1);
            for (XAttribute xattribute : xattributesWithSameName) {
                ValidationResultImpl result = new ValidationResultImpl(xattribute);
                Object[] params = new Object[]{numOthers};
                String msg = ModelerCore.Util.getString("XAttributeUniqueNameInXClassRule.AttributeHasSameNameAs_n_Others", params);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem(problem);
                context.addResult(result);
            }
        }
    }
}

