/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.extension.XAttribute;

public class XAttributeDefaultValueDatatypeRule
implements StructuralFeatureValidationRule {
    @Override
    public void validate(EStructuralFeature theStructuralFeature, EObject theObject, Object theValue, ValidationContext theContext) {
        XAttribute xattribute;
        EDataType type;
        CoreArgCheck.isInstanceOf(XAttribute.class, (Object)theObject);
        if (theValue != null && (type = (EDataType)(xattribute = (XAttribute)theObject).getEType()) != null && theStructuralFeature.getFeatureID() == 13) {
            EPackage ePackage = type.getEPackage();
            EFactory factory = ePackage.getEFactoryInstance();
            try {
                factory.createFromString(type, (String)theValue);
            }
            catch (RuntimeException runtimeException) {
                ValidationResultImpl result = new ValidationResultImpl(xattribute);
                Object[] params = new Object[]{theValue, type.getName(), theStructuralFeature.getName()};
                String msg = ModelerCore.Util.getString("XAttributeValueDatatypeRule.DefaultValueCannotBeConvertedToCorrectDatatype", (Object)params);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem(problem);
                theContext.addResult(result);
            }
        }
    }
}

