/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import java.util.Properties;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.workspace.ModelObjectAnnotationHelper;
import org.teiid.designer.metamodels.core.Annotation;

public final class RestPropertiesRule
implements ObjectValidationRule {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RestPropertiesRule.class);

    @Override
    public void validate(EObject theObject, ValidationContext theContext) {
        CoreArgCheck.isInstanceOf(Annotation.class, (Object)theObject);
        ModelObjectAnnotationHelper moah = new ModelObjectAnnotationHelper();
        Properties props = null;
        try {
            props = moah.getProperties(theObject, "rest:");
            boolean methodSet = false;
            boolean uriSet = false;
            if (props != null && props.size() > 0) {
                String method = props.getProperty("rest:restMethod");
                String uri = props.getProperty("rest:uri");
                methodSet = method != null && !method.trim().equals("");
                uriSet = uri != null && !uri.trim().equals("");
                String message = "";
                if (methodSet & !uriSet) {
                    message = ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "uriRequired", new Object[0]);
                }
                if (uriSet & !methodSet) {
                    message = ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "methodRequired", new Object[0]);
                }
                if (!message.equals("")) {
                    ValidationResultImpl result = new ValidationResultImpl(theObject, theObject);
                    ValidationProblemImpl problem = new ValidationProblemImpl(4, 4, message);
                    result.addProblem(problem);
                    theContext.addResult(result);
                }
            }
        }
        catch (RuntimeException theException) {
            ValidationResultImpl result = new ValidationResultImpl(theObject, theObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, theException.getLocalizedMessage());
            result.addProblem(problem);
            theContext.addResult(result);
        }
        catch (ModelerCoreException e) {
            ValidationResultImpl result = new ValidationResultImpl(theObject, theObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, e.getLocalizedMessage());
            result.addProblem(problem);
            theContext.addResult(result);
        }
    }
}

