/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel;

import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.Multiplicity;

final class IntervalMultiplicity
extends Multiplicity {
    private static final long serialVersionUID = 1L;
    private int minimum = 0;
    private int maximum = Integer.MAX_VALUE;

    IntervalMultiplicity(int number) {
        if (number < 0) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("Multiplicity.The_multiplicity_must_be_a_positive_number_", new Object[0]));
        }
        if (number < 1) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("Multiplicity.The_multiplicity_may_not_be_0", new Object[0]));
        }
        this.maximum = number;
        this.minimum = number;
    }

    IntervalMultiplicity(int minimum, int maximum, boolean isOrdered, boolean isUnique) {
        super(isOrdered, isUnique);
        if (maximum < 0) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("Multiplicity.The_maximum_multiplicity_must_be_between_0_and_UNBOUNDED_VALUE", (Object)maximum));
        }
        if (minimum > maximum) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("Multiplicity.The_maximum_multiplicity_must_be_equal_to_or_greater_than_the_minimum_multiplicity", new Object[]{new Integer(maximum), new Integer(minimum)}));
        }
        this.maximum = maximum;
        this.minimum = minimum;
    }

    IntervalMultiplicity() {
        this(1);
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public boolean isUnlimited() {
        return this.maximum == Integer.MAX_VALUE;
    }

    @Override
    public boolean isIncluded(int cardinality) {
        return cardinality >= this.minimum && cardinality <= this.maximum;
    }

    @Override
    public String toString() {
        String result = null;
        result = this.minimum != this.maximum ? (this.maximum != Integer.MAX_VALUE ? String.valueOf(Integer.toString(this.minimum)) + ".." + Integer.toString(this.maximum) : String.valueOf(Integer.toString(this.minimum)) + ".." + '*') : Integer.toString(this.minimum);
        return result;
    }

    @Override
    public int compareTo(Object obj) {
        CoreArgCheck.isNotNull((Object)obj);
        Multiplicity that = (Multiplicity)obj;
        return Multiplicity.compare(this, that);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntervalMultiplicity) {
            IntervalMultiplicity that = (IntervalMultiplicity)obj;
            if (that.minimum == this.minimum && that.maximum == this.maximum) {
                return super.compareFlags(that) == 0;
            }
            return false;
        }
        return false;
    }
}

