/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionHeader;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.Translation;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;

public class ModelExtensionUtils {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ModelExtensionUtils.class);
    private static final String DEFN_PREFIX = "modelExtensionDefinition";
    private static final char DELIM = ':';
    private static final String EXTENDED_METACLASS_PREFIX = "extendedMetaclass";
    private static final String PROP_DEFN_PREFIX = "propertyDefinition";

    private static String constructKey(String prefix, String id) {
        return String.valueOf(prefix) + ':' + id;
    }

    private static String getKeyId(String prefix, String key) {
        String prefixStr = String.valueOf(prefix) + ':';
        if (key.startsWith(prefixStr)) {
            return key.substring(key.indexOf(prefixStr) + prefixStr.length());
        }
        return "";
    }

    public static boolean containsModelExtensionDefinition(ModelResource modelResource, String namespacePrefix) throws Exception {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource is null");
        return ModelExtensionUtils.getDefinitionAnnotation(modelResource, false, namespacePrefix) != null;
    }

    public static ModelExtensionDefinitionHeader getModelExtensionDefinitionHeader(ModelResource modelResource, String namespacePrefix) throws Exception {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource is null");
        CoreArgCheck.isNotEmpty((String)namespacePrefix, (String)"namespacePrefix is empty");
        ModelExtensionDefinitionHeader header = null;
        Annotation defnAnnotation = ModelExtensionUtils.getDefinitionAnnotation(modelResource, false, namespacePrefix);
        if (defnAnnotation != null) {
            EMap definitionTags = defnAnnotation.getTags();
            String metamodelUri = (String)definitionTags.get((Object)"metamodel");
            String namespacePrfx = (String)definitionTags.get((Object)"namespacePrefix");
            String namespaceUri = (String)definitionTags.get((Object)"namespaceUri");
            String description = (String)definitionTags.get((Object)"description");
            String versionStr = (String)definitionTags.get((Object)"version");
            int version = Integer.parseInt(versionStr);
            header = new ModelExtensionDefinitionHeader(namespacePrfx, namespaceUri, metamodelUri, ModelExtensionUtils.getSupportedModelTypes(modelResource, defnAnnotation), description, version);
        }
        return header;
    }

    public static ModelExtensionDefinition getModelExtensionDefinition(ModelExtensionAssistant assistant, ModelResource modelResource) throws Exception {
        CoreArgCheck.isNotNull((Object)assistant, (String)"assistant is null");
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource is null");
        ModelExtensionDefinition med = null;
        String namespacePrefix = assistant.getNamespacePrefix();
        ModelExtensionDefinitionHeader medHeader = ModelExtensionUtils.getModelExtensionDefinitionHeader(modelResource, namespacePrefix);
        if (medHeader != null) {
            med = assistant.createModelExtensionDefinition(medHeader);
            Annotation defnAnnotation = ModelExtensionUtils.getDefinitionAnnotation(modelResource, false, namespacePrefix);
            if (defnAnnotation != null) {
                EMap definitionTags = defnAnnotation.getTags();
                for (Object object : definitionTags.entrySet()) {
                    if (!(object instanceof EStringToStringMapEntryImpl)) {
                        throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "modelExtensionDefinitionTagUnexpectedClass", object.getClass()));
                    }
                    EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)object;
                    if (!entry.getKey().startsWith(EXTENDED_METACLASS_PREFIX)) continue;
                    Annotation metaclassAnnotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)entry, false);
                    if (metaclassAnnotation == null) {
                        throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "metaclassAnnotationNotFound", (Object)entry.getKey()));
                    }
                    String metaclassName = ModelExtensionUtils.getKeyId(EXTENDED_METACLASS_PREFIX, entry.getKey());
                    EMap metaclassTags = metaclassAnnotation.getTags();
                    for (Object metaclassTagObj : metaclassTags.entrySet()) {
                        if (!(metaclassTagObj instanceof EStringToStringMapEntryImpl)) {
                            throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "metaclassEntryUnexpectedClass", metaclassTagObj.getClass()));
                        }
                        if (!((EStringToStringMapEntryImpl)metaclassTagObj).getKey().startsWith(PROP_DEFN_PREFIX)) continue;
                        Annotation propertyDefinitionAnnotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)((EStringToStringMapEntryImpl)metaclassTagObj), false);
                        if (propertyDefinitionAnnotation == null) {
                            throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "propertyDefinitionAnnotationNotFound", (Object)((EStringToStringMapEntryImpl)metaclassTagObj).getKey()));
                        }
                        String simpleId = null;
                        HashSet<Translation> displayNames = null;
                        String runtimeType = null;
                        String required = Boolean.toString(false);
                        String defaultValue = null;
                        String fixedValue = null;
                        String advanced = Boolean.toString(false);
                        String masked = Boolean.toString(false);
                        String index = Boolean.toString(true);
                        HashSet<String> allowedValues = null;
                        HashSet<Translation> descriptions = null;
                        EMap propDefnTags = propertyDefinitionAnnotation.getTags();
                        for (Object propDefnTagObj : propDefnTags.entrySet()) {
                            String localeTxt;
                            if (!(propDefnTagObj instanceof EStringToStringMapEntryImpl)) {
                                ModelerCore.Util.log(4, ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "propertyDefinitionEntryUnexpectedClass", propDefnTagObj.getClass()));
                            }
                            String key = ((EStringToStringMapEntryImpl)propDefnTagObj).getKey();
                            String value = ((EStringToStringMapEntryImpl)propDefnTagObj).getValue();
                            if ("id".equals(key)) {
                                simpleId = value;
                                continue;
                            }
                            if ("displayName".equals(key)) {
                                displayNames = new HashSet<Translation>();
                                Annotation displayNamesAnnotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)((EStringToStringMapEntryImpl)propDefnTagObj), false);
                                EMap displayNamesTags = displayNamesAnnotation.getTags();
                                for (Object temp : displayNamesTags.entrySet()) {
                                    if (!(temp instanceof EStringToStringMapEntryImpl)) {
                                        throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "modelExtensionDefinitionTagUnexpectedClass", temp.getClass()));
                                    }
                                    EStringToStringMapEntryImpl displayNameEntry = (EStringToStringMapEntryImpl)temp;
                                    localeTxt = displayNameEntry.getKey();
                                    displayNames.add(new Translation(I18nUtil.parseLocaleString((String)localeTxt), displayNameEntry.getValue()));
                                }
                                continue;
                            }
                            if ("description".equals(key)) {
                                descriptions = new HashSet<Translation>();
                                Annotation desciptionsAnnotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)((EStringToStringMapEntryImpl)propDefnTagObj), false);
                                EMap descriptionsTags = desciptionsAnnotation.getTags();
                                for (Object temp : descriptionsTags.entrySet()) {
                                    if (!(temp instanceof EStringToStringMapEntryImpl)) {
                                        throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "modelExtensionDefinitionTagUnexpectedClass", temp.getClass()));
                                    }
                                    EStringToStringMapEntryImpl descriptionEntry = (EStringToStringMapEntryImpl)temp;
                                    localeTxt = descriptionEntry.getKey();
                                    descriptions.add(new Translation(I18nUtil.parseLocaleString((String)localeTxt), descriptionEntry.getValue()));
                                }
                                continue;
                            }
                            if ("runtimeType".equals(key)) {
                                runtimeType = value;
                                continue;
                            }
                            if ("required".equals(key)) {
                                required = value;
                                continue;
                            }
                            if ("defaultValue".equals(key)) {
                                defaultValue = value;
                                continue;
                            }
                            if ("fixedValue".equals(key)) {
                                fixedValue = value;
                                continue;
                            }
                            if ("advanced".equals(key)) {
                                advanced = value;
                                continue;
                            }
                            if ("masked".equals(key)) {
                                masked = value;
                                continue;
                            }
                            if ("index".equals(key)) {
                                index = value;
                                continue;
                            }
                            if (!"allowedValues".equals(key)) continue;
                            allowedValues = new HashSet<String>();
                            Annotation allowedValuesAnnotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)((EStringToStringMapEntryImpl)propDefnTagObj), false);
                            if (allowedValuesAnnotation == null) {
                                throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "allowedValuesAnnotationNotFound", (Object)((EStringToStringMapEntryImpl)propDefnTagObj).getKey()));
                            }
                            EMap allowedValuesTags = allowedValuesAnnotation.getTags();
                            for (String allowedValue : allowedValuesTags.keySet()) {
                                allowedValues.add(allowedValue);
                            }
                        }
                        ModelExtensionPropertyDefinition propertyDefn = assistant.createPropertyDefinition(simpleId, runtimeType, required, defaultValue, fixedValue, advanced, masked, index, allowedValues, descriptions, displayNames);
                        assistant.addPropertyDefinition(metaclassName, propertyDefn);
                    }
                }
            }
        }
        return med;
    }

    private static Annotation getAnnotation(ModelResource modelResource, Annotation parentAnnotation, String tagId, String value, boolean forceCreate) throws Exception {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource is null");
        CoreArgCheck.isNotNull((Object)parentAnnotation, (String)"parentAnnotation is null");
        CoreArgCheck.isNotNull((Object)tagId, (String)"tagId is null");
        CoreArgCheck.isNotNull((Object)value, (String)"value is null");
        Annotation annotation = null;
        EMap tags = parentAnnotation.getTags();
        if (!tags.containsKey((Object)tagId)) {
            if (forceCreate) {
                tags.put((Object)tagId, (Object)value);
            } else {
                return null;
            }
        }
        for (Object obj : tags.entrySet()) {
            EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)obj;
            if (!entry.getKey().equals(tagId)) continue;
            annotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)entry, false);
            if (annotation != null || !forceCreate) break;
            annotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)entry, true);
            break;
        }
        return annotation;
    }

    private static Annotation getDefinitionAnnotation(ModelResource modelResource, boolean forceCreate, String namespacePrefix) throws Exception {
        Annotation annotation = ModelExtensionUtils.getResourceAnnotation(modelResource, forceCreate);
        if (annotation != null) {
            String key = ModelExtensionUtils.constructKey(DEFN_PREFIX, namespacePrefix);
            return ModelExtensionUtils.getAnnotation(modelResource, annotation, key, namespacePrefix, forceCreate);
        }
        return null;
    }

    private static Annotation getModelObjectAnnotationImpl(EObject modelObject, boolean forceCreate) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject is null");
        return ModelerCore.getModelEditor().getAnnotation(modelObject, forceCreate);
    }

    public static Annotation getModelObjectAnnotation(EObject modelObject, boolean forceCreate) throws ModelerCoreException {
        if (forceCreate) {
            boolean requiredStart = ModelerCore.startTxn(true, true, ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "getModelObjectAnnotation", new Object[0]), modelObject);
            boolean succeeded = false;
            try {
                Annotation annotation = ModelExtensionUtils.getModelObjectAnnotationImpl(modelObject, true);
                succeeded = true;
                Annotation annotation2 = annotation;
                return annotation2;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return ModelExtensionUtils.getModelObjectAnnotationImpl(modelObject, false);
    }

    private static Annotation getModelTypesAnnotation(ModelResource modelResource, Annotation definitionAnnotation, boolean forceCreate) throws Exception {
        return ModelExtensionUtils.getAnnotation(modelResource, definitionAnnotation, "modelTypes", "", forceCreate);
    }

    private static Annotation getResourceAnnotationImpl(ModelResource modelResource, boolean forceCreate) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        Annotation annotation = null;
        if (modelResource.getAnnotations() != null && modelResource.getModelAnnotation() != null && (annotation = modelResource.getAnnotations().getAnnotation((EObject)modelResource.getModelAnnotation())) == null && forceCreate) {
            annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)modelResource.getModelAnnotation(), modelResource.getEmfResource());
            ModelContents contents = ModelerCore.getModelEditor().getModelContents(modelResource);
            AnnotationContainer ac = contents.getAnnotationContainer(true);
            if (ac != null) {
                annotation.setAnnotationContainer(ac);
            }
        }
        return annotation;
    }

    public static Annotation getResourceAnnotation(ModelResource modelResource, boolean forceCreate) throws ModelWorkspaceException {
        if (forceCreate) {
            boolean requiredStart = ModelerCore.startTxn(true, true, ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "getResourceAnnotation", new Object[0]), modelResource);
            boolean succeeded = false;
            try {
                Annotation annotation = ModelExtensionUtils.getResourceAnnotationImpl(modelResource, true);
                succeeded = true;
                Annotation annotation2 = annotation;
                return annotation2;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return ModelExtensionUtils.getResourceAnnotationImpl(modelResource, false);
    }

    private static Set<String> getSupportedModelTypes(ModelResource modelResource, Annotation definitionAnnotation) throws Exception {
        Annotation modelTypesAnnotation = ModelExtensionUtils.getModelTypesAnnotation(modelResource, definitionAnnotation, false);
        if (modelTypesAnnotation != null) {
            EMap modelTypesTags = modelTypesAnnotation.getTags();
            HashSet<String> modelTypes = new HashSet<String>(modelTypesTags.size());
            for (String modelType : modelTypesTags.keySet()) {
                modelTypes.add(modelType);
            }
            return modelTypes;
        }
        return Collections.emptySet();
    }

    public static Collection<String> getSupportedNamespaces(ModelResource modelResource) throws Exception {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource is null");
        Annotation annotation = ModelExtensionUtils.getResourceAnnotation(modelResource, false);
        if (annotation != null) {
            EMap tags = annotation.getTags();
            ArrayList<String> namespaces = new ArrayList<String>();
            for (String key : tags.keySet()) {
                if (!key.startsWith(DEFN_PREFIX)) continue;
                namespaces.add((String)tags.get((Object)key));
            }
            return namespaces;
        }
        return Collections.emptyList();
    }

    public static boolean isSupportedNamespace(ModelResource modelResource, String namespace) throws Exception {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource is null");
        CoreArgCheck.isNotNull((Object)namespace, (String)"namespace is null");
        Collection<String> namespaces = ModelExtensionUtils.getSupportedNamespaces(modelResource);
        for (String ns : namespaces) {
            if (!namespace.equals(ns)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModelExtensionDefinitionRelated(EObject modelObject) {
        if (modelObject instanceof EStringToStringMapEntryImpl) {
            String key = ((EStringToStringMapEntryImpl)modelObject).getKey();
            if (key.startsWith("modelExtensionDefinition:")) {
                return true;
            }
        } else if (modelObject instanceof Annotation) {
            return ModelExtensionUtils.isModelExtensionDefinitionRelated(((Annotation)modelObject).getAnnotatedObject());
        }
        return false;
    }

    private static void removeMetaclassAnnotation(ModelResource modelResource, EStringToStringMapEntryImpl metaclassTag) throws Exception {
        Annotation metaclassAnnotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)metaclassTag, false);
        if (metaclassAnnotation == null) {
            throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "metaclassAnnotationNotFound", (Object)metaclassTag.getKey()));
        }
        EMap tags = metaclassAnnotation.getTags();
        for (Object object : tags.entrySet()) {
            if (!(object instanceof EStringToStringMapEntryImpl)) {
                throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "metaclassEntryUnexpectedClass", object.getClass()));
            }
            if (!((EStringToStringMapEntryImpl)object).getKey().startsWith(PROP_DEFN_PREFIX)) continue;
            ModelExtensionUtils.removePropertyDefinition(modelResource, (EStringToStringMapEntryImpl)object);
        }
        ModelResourceContainerFactory.deleteAnnotation(metaclassAnnotation);
    }

    public static void removeProperty(EObject modelObject, String propId, boolean deleteModelObjectAnnotation) throws Exception {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject is null");
        CoreArgCheck.isNotEmpty((String)propId, (String)"id is empty");
        Annotation annotation = ModelExtensionUtils.getModelObjectAnnotation(modelObject, false);
        if (annotation != null) {
            annotation.getTags().remove((Object)propId);
            if (deleteModelObjectAnnotation && annotation.getTags().isEmpty() && annotation.getDescription() == null) {
                ModelResourceContainerFactory.deleteAnnotation(annotation);
            }
        }
    }

    private static void removePropertyDefinition(ModelResource modelResource, EStringToStringMapEntryImpl propertyDefinitionTag) throws Exception {
        Annotation propertyDefinitionAnnotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)propertyDefinitionTag, false);
        if (propertyDefinitionAnnotation == null) {
            throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "propertyDefinitionAnnotationNotFound", (Object)propertyDefinitionTag.getKey()));
        }
        EMap tags = propertyDefinitionAnnotation.getTags();
        for (Object object : tags.entrySet()) {
            Annotation descriptionsAnnotation;
            Annotation displayNamesAnnotation;
            Annotation allowedValuesAnnotation;
            String key;
            if (!(object instanceof EStringToStringMapEntryImpl)) {
                ModelerCore.Util.log(4, ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "propertyDefinitionEntryUnexpectedClass", object.getClass()));
            }
            if ("allowedValues".equals(key = ((EStringToStringMapEntryImpl)object).getKey()) && (allowedValuesAnnotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)((EStringToStringMapEntryImpl)object), false)) != null) {
                ModelResourceContainerFactory.deleteAnnotation(allowedValuesAnnotation);
            }
            if ("displayName".equals(key) && (displayNamesAnnotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)((EStringToStringMapEntryImpl)object), false)) != null) {
                ModelResourceContainerFactory.deleteAnnotation(displayNamesAnnotation);
            }
            if (!"description".equals(key) || (descriptionsAnnotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)((EStringToStringMapEntryImpl)object), false)) == null) continue;
            ModelResourceContainerFactory.deleteAnnotation(descriptionsAnnotation);
        }
        ModelResourceContainerFactory.deleteAnnotation(propertyDefinitionAnnotation);
    }

    public static void removeModelExtensionDefinition(ModelResource modelResource, String namespacePrefix) throws Exception {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource is null");
        Annotation annotation = ModelExtensionUtils.getResourceAnnotation(modelResource, false);
        if (annotation != null) {
            Annotation defnAnnotation = ModelExtensionUtils.getDefinitionAnnotation(modelResource, false, namespacePrefix);
            if (defnAnnotation == null) {
                throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "defnAnnotationNotFound", (Object)namespacePrefix));
            }
            boolean requiredStart = ModelerCore.startTxn(true, true, ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "removeModelExtensionDefinition", new Object[0]), modelResource);
            boolean succeeded = false;
            try {
                Annotation modelTypesAnnotation = ModelExtensionUtils.getModelTypesAnnotation(modelResource, defnAnnotation, false);
                if (modelTypesAnnotation != null) {
                    ModelResourceContainerFactory.deleteAnnotation(modelTypesAnnotation);
                }
                EMap tags = defnAnnotation.getTags();
                for (Object object : tags.entrySet()) {
                    if (!(object instanceof EStringToStringMapEntryImpl)) {
                        throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "modelExtensionDefinitionTagUnexpectedClass", object.getClass()));
                    }
                    EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)object;
                    if (!entry.getKey().startsWith(EXTENDED_METACLASS_PREFIX)) continue;
                    ModelExtensionUtils.removeMetaclassAnnotation(modelResource, entry);
                }
                ModelResourceContainerFactory.deleteAnnotation(defnAnnotation);
                annotation.getTags().removeKey((Object)ModelExtensionUtils.constructKey(DEFN_PREFIX, namespacePrefix));
                if (annotation.getTags().isEmpty()) {
                    ModelResourceContainerFactory.deleteAnnotation(annotation);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void updateModelExtensionDefinition(ModelResource modelResource, ModelExtensionDefinition definition) throws Exception {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource is null");
        CoreArgCheck.isNotNull((Object)definition, (String)"definition is null");
        String namespacePrefix = definition.getNamespacePrefix();
        boolean requiredStart = ModelerCore.startTxn(true, true, ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "updateModelExtensionDefinition", new Object[0]), modelResource);
        boolean succeeded = false;
        try {
            String description;
            Annotation definitionAnnotation = ModelExtensionUtils.getDefinitionAnnotation(modelResource, true, namespacePrefix);
            EMap definitionTags = definitionAnnotation.getTags();
            String metamodelUri = definition.getMetamodelUri();
            if (!CoreStringUtil.equals((String)((String)definitionTags.get((Object)"metamodel")), (String)metamodelUri)) {
                definitionTags.put((Object)"metamodel", (Object)metamodelUri);
            }
            if (!CoreStringUtil.equals((String)((String)definitionTags.get((Object)"namespacePrefix")), (String)namespacePrefix)) {
                definitionTags.put((Object)"namespacePrefix", (Object)namespacePrefix);
            }
            String namespaceUri = definition.getNamespaceUri();
            if (!CoreStringUtil.equals((String)((String)definitionTags.get((Object)"namespaceUri")), (String)namespaceUri)) {
                definitionTags.put((Object)"namespaceUri", (Object)namespaceUri);
            }
            int version = definition.getVersion();
            if (!CoreStringUtil.equals((String)((String)definitionTags.get((Object)"version")), (String)Integer.toString(version))) {
                definitionTags.put((Object)"version", (Object)Integer.toString(version));
            }
            if (CoreStringUtil.isEmpty((String)(description = definition.getDescription()))) {
                definitionTags.remove((Object)"description");
            } else if (!CoreStringUtil.equals((String)((String)definitionTags.get((Object)"description")), (String)description)) {
                definitionTags.put((Object)"description", (Object)description);
            }
            Set supportedModelTypes = definition.getSupportedModelTypes();
            if (supportedModelTypes.isEmpty()) {
                definitionTags.remove((Object)"modelTypes");
            } else {
                Annotation modelTypesAnnotation = ModelExtensionUtils.getModelTypesAnnotation(modelResource, definitionAnnotation, true);
                EMap modelTypesTags = modelTypesAnnotation.getTags();
                modelTypesTags.clear();
                for (String modelType : supportedModelTypes) {
                    modelTypesTags.put((Object)modelType, (Object)"");
                }
            }
            String[] medExtendedMetaclasses = definition.getExtendedMetaclasses();
            ModelExtensionUtils.removeUnsupportedMetaclassAnnotations(modelResource, (EMap<String, String>)definitionTags, medExtendedMetaclasses);
            String[] stringArray = medExtendedMetaclasses;
            int n = medExtendedMetaclasses.length;
            int n2 = 0;
            while (n2 < n) {
                String extendedMetaclassName = stringArray[n2];
                String metaclassKey = ModelExtensionUtils.constructKey(EXTENDED_METACLASS_PREFIX, extendedMetaclassName);
                Annotation metaclassAnnotation = ModelExtensionUtils.getAnnotation(modelResource, definitionAnnotation, metaclassKey, extendedMetaclassName, true);
                for (ModelExtensionPropertyDefinition propDefn : definition.getPropertyDefinitions(extendedMetaclassName)) {
                    Set descriptions;
                    String[] allowedValues;
                    String propKey = ModelExtensionUtils.constructKey(PROP_DEFN_PREFIX, propDefn.getSimpleId());
                    Annotation propDefAnnotation = ModelExtensionUtils.getAnnotation(modelResource, metaclassAnnotation, propKey, propDefn.getSimpleId(), true);
                    EMap propDefTags = propDefAnnotation.getTags();
                    String value = null;
                    value = Boolean.toString(propDefn.isAdvanced());
                    if (!CoreStringUtil.equals((String)((String)propDefTags.get((Object)"advanced")), (String)value)) {
                        propDefTags.put((Object)"advanced", (Object)value);
                    }
                    if ((allowedValues = propDefn.getAllowedValues()) == null || allowedValues.length == 0 || ModelExtensionPropertyDefinition.Type.BOOLEAN.getRuntimeType().equals(propDefn.getRuntimeType())) {
                        propDefTags.removeKey((Object)"allowedValues");
                    } else {
                        Annotation allowedValuesAnnotation = ModelExtensionUtils.getAnnotation(modelResource, propDefAnnotation, "allowedValues", "", true);
                        EMap allowedValuesTags = allowedValuesAnnotation.getTags();
                        String[] stringArray2 = allowedValues;
                        int n3 = allowedValues.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String allowedValue = stringArray2[n4];
                            allowedValuesTags.put((Object)allowedValue, (Object)"");
                            ++n4;
                        }
                    }
                    Set displayNames = propDefn.getDisplayNames();
                    if (!displayNames.isEmpty()) {
                        Annotation displayNamesAnnotation = ModelExtensionUtils.getAnnotation(modelResource, propDefAnnotation, "displayName", "", true);
                        EMap displayNamesTags = displayNamesAnnotation.getTags();
                        displayNamesTags.clear();
                        for (Translation translation : displayNames) {
                            displayNamesTags.put((Object)translation.getLocale().toString(), (Object)translation.getTranslation());
                        }
                    }
                    value = propDefn.getDefaultValue();
                    if (!CoreStringUtil.equals((String)((String)propDefTags.get((Object)"defaultValue")), (String)value)) {
                        if (CoreStringUtil.isEmpty((String)value)) {
                            propDefTags.removeKey((Object)"defaultValue");
                        } else {
                            propDefTags.put((Object)"defaultValue", (Object)value);
                        }
                    }
                    if (!(descriptions = propDefn.getDescriptions()).isEmpty()) {
                        Annotation descriptionsAnnotation = ModelExtensionUtils.getAnnotation(modelResource, propDefAnnotation, "description", "", true);
                        EMap descriptionsTags = descriptionsAnnotation.getTags();
                        descriptionsTags.clear();
                        for (Translation translation : descriptions) {
                            descriptionsTags.put((Object)translation.getLocale().toString(), (Object)translation.getTranslation());
                        }
                    }
                    if (!CoreStringUtil.equals((String)((String)propDefTags.get((Object)"id")), (String)propDefn.getSimpleId())) {
                        propDefTags.put((Object)"id", (Object)propDefn.getSimpleId());
                    }
                    value = Boolean.toString(propDefn.shouldBeIndexed());
                    if (!CoreStringUtil.equals((String)((String)propDefTags.get((Object)"index")), (String)value)) {
                        propDefTags.put((Object)"index", (Object)value);
                    }
                    value = Boolean.toString(propDefn.isModifiable());
                    if (!CoreStringUtil.equals((String)((String)propDefTags.get((Object)"modifiable")), (String)value)) {
                        propDefTags.put((Object)"modifiable", (Object)value);
                    }
                    value = Boolean.toString(propDefn.isMasked());
                    if (!CoreStringUtil.equals((String)((String)propDefTags.get((Object)"masked")), (String)value)) {
                        propDefTags.put((Object)"masked", (Object)value);
                    }
                    value = Boolean.toString(propDefn.isRequired());
                    if (!CoreStringUtil.equals((String)((String)propDefTags.get((Object)"required")), (String)value)) {
                        propDefTags.put((Object)"required", (Object)value);
                    }
                    value = propDefn.getRuntimeType();
                    if (CoreStringUtil.equals((String)((String)propDefTags.get((Object)"runtimeType")), (String)value)) continue;
                    propDefTags.put((Object)"runtimeType", (Object)value);
                }
                ++n2;
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private static void removeUnsupportedMetaclassAnnotations(ModelResource modelResc, EMap<String, String> defnTags, String[] medMetaclasses) throws Exception {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        List<String> medMetaclassList = Arrays.asList(medMetaclasses);
        for (Object object : defnTags.entrySet()) {
            String metaclassName;
            if (!(object instanceof EStringToStringMapEntryImpl)) {
                throw new Exception(ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + "modelExtensionDefinitionTagUnexpectedClass", object.getClass()));
            }
            EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)object;
            if (!entry.getKey().startsWith(EXTENDED_METACLASS_PREFIX) || medMetaclassList.contains(metaclassName = ModelExtensionUtils.getKeyId(EXTENDED_METACLASS_PREFIX, entry.getKey()))) continue;
            ModelExtensionUtils.removeMetaclassAnnotation(modelResc, entry);
            keysToRemove.add(entry.getKey());
        }
        for (String remKey : keysToRemove) {
            defnTags.remove((Object)remKey);
        }
    }

    private ModelExtensionUtils() {
    }

    private static interface DefinitionTagKeys {
        public static final String DESCRIPTION = "description";
        public static final String METAMODEL = "metamodel";
        public static final String MODEL_TYPES = "modelTypes";
        public static final String NAMESPACE_PREFIX = "namespacePrefix";
        public static final String NAMESPACE_URI = "namespaceUri";
        public static final String VERSION = "version";
    }

    private static interface PropertyTagKeys {
        public static final String ADVANCED = "advanced";
        public static final String ALLOWED_VALUES = "allowedValues";
        public static final String DEFAULT_VALUE = "defaultValue";
        public static final String DESCRIPTIONS = "description";
        public static final String DISPLAY_NAMES = "displayName";
        public static final String ID = "id";
        public static final String MASKED = "masked";
        public static final String MODIFIABLE = "modifiable";
        public static final String REQUIRED = "required";
        public static final String RUNTIME_TYPE = "runtimeType";
        public static final String FIXED_VALUE = "fixedValue";
        public static final String INDEX = "index";
    }
}

