/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EReference;
import org.teiid.designer.core.compare.EObjectMatcherFactory;

public class EObjectMatcherCache {
    private final List matcherFactories = new ArrayList();
    private final Map matchersByFeature = new HashMap();
    private List rootMatchers;

    public List getEObjectMatcherFactories() {
        return this.matcherFactories;
    }

    public synchronized void addEObjectMatcherFactories(List factories) {
        for (Object factory : factories) {
            if (this.matcherFactories.contains(factory)) continue;
            this.matcherFactories.add(factory);
        }
    }

    public List getEObjectMatchersForRoots() {
        if (this.rootMatchers == null) {
            this.rootMatchers = new ArrayList();
            for (EObjectMatcherFactory factory : this.matcherFactories) {
                List newRootMatchers = factory.createEObjectMatchersForRoots();
                this.addAllWithNoDuplicates(newRootMatchers, this.rootMatchers);
            }
        }
        return this.rootMatchers;
    }

    public List getEObjectMatchers(EReference reference) {
        LinkedList results = (LinkedList)this.matchersByFeature.get(reference);
        if (results == null) {
            results = new LinkedList();
            for (EObjectMatcherFactory factory : this.matcherFactories) {
                List newRootMatchers = factory.createEObjectMatchers(reference);
                this.addAllWithNoDuplicates(newRootMatchers, results);
            }
            this.matchersByFeature.put(reference, results);
        }
        return results;
    }

    protected void addAllWithNoDuplicates(List thingsToAdd, List listToAddTo) {
        for (Object thingToAdd : thingsToAdd) {
            if (listToAddTo.contains(thingToAdd)) continue;
            listToAddTo.add(thingToAdd);
        }
    }
}

