/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.ModelVisitor;

public class FindReferencesToDeletedObjects
implements ModelVisitor {
    private final Collection allDeletedObjects;
    private final Collection referencesToDeleted;

    public FindReferencesToDeletedObjects(Collection allDeletedObjects) {
        CoreArgCheck.isNotNull((Object)allDeletedObjects);
        this.allDeletedObjects = new HashSet(allDeletedObjects);
        this.referencesToDeleted = new HashSet();
    }

    @Override
    public boolean visit(EObject object) {
        EClass eclass = object.eClass();
        EList allRefs = eclass.getEAllReferences();
        for (EReference reference : allRefs) {
            EReference opposite = reference.getEOpposite();
            if (reference.isContainment() || opposite == null || opposite.isContainment()) continue;
            if (reference.isMany()) {
                Collection values = (Collection)object.eGet((EStructuralFeature)reference);
                for (Object value : values) {
                    if (!this.allDeletedObjects.contains(value) || this.referencesToDeleted.contains(value)) continue;
                    this.referencesToDeleted.add(value);
                }
                continue;
            }
            Object value = object.eGet((EStructuralFeature)reference);
            if (!this.allDeletedObjects.contains(value) || this.referencesToDeleted.contains(value)) continue;
            this.referencesToDeleted.add(value);
        }
        return true;
    }

    @Override
    public boolean visit(Resource resource) {
        return resource != null;
    }

    public Collection getReferencesToDeletedObjects() {
        return this.referencesToDeleted;
    }
}

