/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.teiid.core.designer.plugin.PluginUtilities;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.Configuration;
import org.teiid.designer.core.ExtensionDescriptor;
import org.teiid.designer.core.ExtensionDescriptorImpl;
import org.teiid.designer.core.ExternalResourceDescriptor;
import org.teiid.designer.core.ExternalResourceDescriptorImpl;
import org.teiid.designer.core.ExternalResourceSetDescriptorImpl;
import org.teiid.designer.core.MappingAdapterDescriptor;
import org.teiid.designer.core.MappingAdapterDescriptorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.ValidationDescriptorImpl;
import org.teiid.designer.core.container.ResourceDescriptorImpl;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.MetamodelDescriptorImpl;
import org.teiid.designer.core.metamodel.MetamodelRootClassDescriptorImpl;

public class EclipseConfigurationBuilder {
    public static void build(Configuration config) {
        List descriptors = EclipseConfigurationBuilder.readMetamodelDescriptors(true);
        config.getMetamodelDescriptors().addAll(descriptors);
        List resourceDescriptors = EclipseConfigurationBuilder.readResourceDescriptors();
        config.getResourceDescriptors().addAll(resourceDescriptors);
        List validationDescriptors = EclipseConfigurationBuilder.readValidationDescriptors();
        config.getValidationDescriptors().addAll(validationDescriptors);
        List associationProviderDescriptors = EclipseConfigurationBuilder.readAssociationProviderDescriptors();
        config.getAssociationProviderDescriptors().addAll(associationProviderDescriptors);
        List modelObjectResolverDescriptors = EclipseConfigurationBuilder.readModelObjectResolverDescriptors();
        config.getMappingAdapterDescriptors().addAll(modelObjectResolverDescriptors);
        List datatypeManagerDescriptors = EclipseConfigurationBuilder.readDatatypeManagerDescriptors();
        config.getDatatypeManagerDescriptors().addAll(datatypeManagerDescriptors);
        List externalResourceDescriptors = EclipseConfigurationBuilder.readExternalResourceDescriptors();
        config.getExternalResourceDescriptors().addAll(externalResourceDescriptors);
        List externalResourceSetDescriptors = EclipseConfigurationBuilder.readExternalResourceSetDescriptors();
        config.getExternalResourceSetDescriptors().addAll(externalResourceSetDescriptors);
        List invocationFactoryHelperDescriptors = EclipseConfigurationBuilder.readInvocationFactoryHelperDescriptors();
        config.getInvocationFactoryHelpers().addAll(invocationFactoryHelperDescriptors);
        List resourceLoadOptionDescriptors = EclipseConfigurationBuilder.readResourceLoadOptionDescriptors();
        config.getResourceLoadOptions().addAll(resourceLoadOptionDescriptors);
    }

    public static List readModelObjectResolverDescriptors() {
        ArrayList<MappingAdapterDescriptor> result = new ArrayList<MappingAdapterDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.eobjectMatcherFactory");
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            MappingAdapterDescriptor descriptor = EclipseConfigurationBuilder.createModelObjectResolverDescriptor(extension);
            result.add(descriptor);
            ++i;
        }
        return result;
    }

    public static List readDatatypeManagerDescriptors() {
        ArrayList<ExtensionDescriptor> result = new ArrayList<ExtensionDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.datatypeManager");
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            ExtensionDescriptor descriptor = EclipseConfigurationBuilder.createDatatypeManagerDescriptor(extension);
            result.add(descriptor);
            ++i;
        }
        return result;
    }

    public static List readExternalResourceSetDescriptors() {
        ArrayList<ExtensionDescriptor> result = new ArrayList<ExtensionDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.externalResourceSet");
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            ExtensionDescriptor descriptor = EclipseConfigurationBuilder.createExternalResourceSetDescriptor(extension);
            result.add(descriptor);
            ++i;
        }
        return result;
    }

    public static List readExternalResourceDescriptors() {
        ArrayList<ExternalResourceDescriptor> result = new ArrayList<ExternalResourceDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.externalResource");
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            ExternalResourceDescriptor descriptor = EclipseConfigurationBuilder.createExternalResourceDescriptor(extension);
            result.add(descriptor);
            ++i;
        }
        Collections.sort(result, new ExternalResourceDescriptorComparator());
        return result;
    }

    public static List readAssociationProviderDescriptors() {
        ArrayList<ExtensionDescriptor> result = new ArrayList<ExtensionDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.associationProvider");
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            ExtensionDescriptor descriptor = EclipseConfigurationBuilder.createAssociationProviderDescriptor(extension);
            result.add(descriptor);
            ++i;
        }
        return result;
    }

    public static List readValidationDescriptors() {
        ArrayList result = new ArrayList();
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.modelValidation");
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            result.addAll(EclipseConfigurationBuilder.createValidationDescriptor(extension));
            ++i;
        }
        return result;
    }

    public static List readInvocationFactoryHelperDescriptors() {
        ArrayList<ExtensionDescriptor> result = new ArrayList<ExtensionDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.invocationFactoryHelper");
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            ExtensionDescriptor descriptor = EclipseConfigurationBuilder.createInvocationFactoryHelperDescriptor(extension);
            result.add(descriptor);
            ++i;
        }
        return result;
    }

    public static List readResourceLoadOptionDescriptors() {
        ArrayList<ExtensionDescriptor> result = new ArrayList<ExtensionDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.resourceLoadOptions");
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            ExtensionDescriptor descriptor = EclipseConfigurationBuilder.createResourceLoadOptionDescriptor(extension);
            result.add(descriptor);
            ++i;
        }
        return result;
    }

    public static List readResourceDescriptors() {
        ArrayList<ResourceDescriptorImpl> result = new ArrayList<ResourceDescriptorImpl>();
        IExtensionPoint resourceFactoryExtension = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.core", "resourceFactory");
        if (resourceFactoryExtension == null) {
            CoreArgCheck.isNotNull((Object)resourceFactoryExtension, (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.Extension_point_not_defined", (Object)"org.teiid.designer.core.resourceFactory"));
        }
        IExtension[] factoryExtensions = resourceFactoryExtension.getExtensions();
        int i = 0;
        while (i < factoryExtensions.length) {
            IExtension factoryExtension = factoryExtensions[i];
            String factoryExtensionID = factoryExtension.getUniqueIdentifier();
            boolean error = false;
            ResourceDescriptorImpl descriptor = new ResourceDescriptorImpl(factoryExtensionID);
            List fileExtensions = descriptor.getExtensions();
            List protocols = descriptor.getProtocols();
            IConfigurationElement[] elements = factoryExtension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String value;
                IConfigurationElement iConfigurationElement = elements[j];
                if (iConfigurationElement.getName().equals("fileExtension")) {
                    value = iConfigurationElement.getValue();
                    if (value != null && value.trim().length() != 0) {
                        fileExtensions.add(value);
                    } else if (ModelerCore.DEBUG) {
                        ModelerCore.Util.log(2, ModelerCore.Util.getString("EclipseConfigurationBuilder.Ignoring_null_or_zero-length_file_extension_value_on_extension", (Object)factoryExtensionID));
                    }
                }
                if (iConfigurationElement.getName().equals("protocol")) {
                    value = iConfigurationElement.getValue();
                    if (value != null && value.trim().length() != 0) {
                        protocols.add(value);
                    } else if (ModelerCore.DEBUG) {
                        ModelerCore.Util.log(2, ModelerCore.Util.getString("EclipseConfigurationBuilder.Ignoring_null_or_zero-length_protocol_value_on_extension", (Object)factoryExtensionID));
                    }
                }
                if (iConfigurationElement.getName().equals("class")) {
                    String className = iConfigurationElement.getAttribute("name");
                    if (className != null && className.trim().length() != 0) {
                        Bundle bundle = Platform.getBundle((String)factoryExtension.getNamespaceIdentifier());
                        descriptor.setResourceFactoryClass(className, bundle);
                    } else if (ModelerCore.DEBUG) {
                        ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.A_class_name_must_be_specified_on_extension", (Object)factoryExtensionID));
                        error = true;
                    }
                }
                ++j;
            }
            if (!error) {
                result.add(descriptor);
            }
            ++i;
        }
        return result;
    }

    public static List readMetamodelDescriptors(boolean addAspects) {
        ArrayList<MetamodelDescriptor> result = new ArrayList<MetamodelDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.metamodel");
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            MetamodelDescriptor descriptor = EclipseConfigurationBuilder.createMetamodelDescriptor(extension);
            result.add(descriptor);
            ++i;
        }
        if (addAspects) {
            List aspectExtensions = EclipseConfigurationBuilder.getMetamodelAspectExtensions();
            for (IExtension extension : aspectExtensions) {
                for (MetamodelDescriptor descriptor : result) {
                    EclipseConfigurationBuilder.addMetamodelAspect(descriptor, extension);
                }
            }
        }
        return result;
    }

    public static ExtensionDescriptor createAssociationProviderDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            CoreArgCheck.isNotNull((Object)extension, (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1", new Object[0]));
        }
        if (!"org.teiid.designer.core.associationProvider".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            CoreArgCheck.isTrue((boolean)"org.teiid.designer.core.associationProvider".equals(uniqueId), (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", new Object[]{"org.teiid.designer.core.associationProvider", uniqueId}));
        }
        Bundle bundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        int j = 0;
        while (j < elems.length) {
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            if (elemName != null && elemName.equals("providerClass")) {
                className = elem.getAttribute("name");
            }
            ++j;
        }
        ExtensionDescriptorImpl descriptor = new ExtensionDescriptorImpl(extensionId, className, bundle);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, bundle};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExtensionDescriptorImpl_instance_id,_classname,_bundle}_1", params));
        }
        return descriptor;
    }

    public static MappingAdapterDescriptor createModelObjectResolverDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            CoreArgCheck.isNotNull((Object)extension, (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1", new Object[0]));
        }
        if (!"org.teiid.designer.core.eobjectMatcherFactory".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            CoreArgCheck.isTrue((boolean)"org.teiid.designer.core.eobjectMatcherFactory".equals(uniqueId), (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", new Object[]{"org.teiid.designer.core.eobjectMatcherFactory", uniqueId}));
        }
        Bundle bundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        int j = 0;
        while (j < elems.length) {
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            if (elemName != null && elemName.equals("class")) {
                className = elem.getAttribute("name");
            }
            ++j;
        }
        MappingAdapterDescriptorImpl descriptor = new MappingAdapterDescriptorImpl(extensionId, className, bundle);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, bundle};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ModelObjectResolverDescriptorImpl_instance", params));
        }
        return descriptor;
    }

    public static ExtensionDescriptor createDatatypeManagerDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            CoreArgCheck.isNotNull((Object)extension, (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1", new Object[0]));
        }
        if (!"org.teiid.designer.core.datatypeManager".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            CoreArgCheck.isTrue((boolean)"org.teiid.designer.core.datatypeManager".equals(uniqueId), (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", new Object[]{"org.teiid.designer.core.datatypeManager", uniqueId}));
        }
        Bundle bundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        int j = 0;
        while (j < elems.length) {
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            if (elemName != null && elemName.equals("class")) {
                className = elem.getAttribute("name");
            }
            ++j;
        }
        ExtensionDescriptorImpl descriptor = new ExtensionDescriptorImpl(extensionId, className, bundle);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, bundle};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExtensionDescriptorImpl_instance_1", params));
        }
        return descriptor;
    }

    public static ExtensionDescriptor createInvocationFactoryHelperDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            CoreArgCheck.isNotNull((Object)extension, (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1", new Object[0]));
        }
        if (!"org.teiid.designer.core.invocationFactoryHelper".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            CoreArgCheck.isTrue((boolean)"org.teiid.designer.core.invocationFactoryHelper".equals(uniqueId), (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", new Object[]{"org.teiid.designer.core.invocationFactoryHelper", uniqueId}));
        }
        Bundle bundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        int j = 0;
        while (j < elems.length) {
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            if (elemName != null && elemName.equals("class")) {
                className = elem.getAttribute("name");
            }
            ++j;
        }
        ExtensionDescriptorImpl descriptor = new ExtensionDescriptorImpl(extensionId, className, bundle);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, bundle};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExtensionDescriptorImpl_instance_1", params));
        }
        return descriptor;
    }

    public static ExtensionDescriptor createResourceLoadOptionDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            CoreArgCheck.isNotNull((Object)extension, (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1", new Object[0]));
        }
        if (!"org.teiid.designer.core.resourceLoadOptions".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            CoreArgCheck.isTrue((boolean)"org.teiid.designer.core.resourceLoadOptions".equals(uniqueId), (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", new Object[]{"org.teiid.designer.core.resourceLoadOptions", uniqueId}));
        }
        Bundle bundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        int j = 0;
        while (j < elems.length) {
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            if (elemName != null && elemName.equals("class")) {
                className = elem.getAttribute("name");
            }
            ++j;
        }
        ExtensionDescriptorImpl descriptor = new ExtensionDescriptorImpl(extensionId, className, bundle);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, bundle};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExtensionDescriptorImpl_instance_1", params));
        }
        return descriptor;
    }

    public static ExtensionDescriptor createExternalResourceSetDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            CoreArgCheck.isNotNull((Object)extension, (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1", new Object[0]));
        }
        if (!"org.teiid.designer.core.externalResourceSet".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            CoreArgCheck.isTrue((boolean)"org.teiid.designer.core.externalResourceSet".equals(uniqueId), (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", new Object[]{"org.teiid.designer.core.externalResourceSet", uniqueId}));
        }
        Bundle bundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
        Properties properties = new Properties();
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        int j = 0;
        while (j < elems.length) {
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            if (elemName != null) {
                if (elemName.equals("class")) {
                    className = elem.getAttribute("name");
                } else if (elemName.equals("properties")) {
                    String[] propNames = elem.getAttributeNames();
                    int i = 0;
                    while (i < propNames.length) {
                        String name = propNames[i];
                        String value = elem.getAttribute(name);
                        properties.setProperty(name, value);
                        ++i;
                    }
                }
            }
            ++j;
        }
        ExternalResourceSetDescriptorImpl descriptor = new ExternalResourceSetDescriptorImpl(extensionId, className, bundle);
        descriptor.setProperties(properties);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, bundle};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExternalResourceSetDescriptorImpl_instance__id,_classname,_bundle_1", params));
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Set_ExternalResourceSetDescriptorImpl_properties_to_2", (Object)properties));
        }
        return descriptor;
    }

    public static ExternalResourceDescriptor createExternalResourceDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            CoreArgCheck.isNotNull((Object)extension, (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1", new Object[0]));
        }
        if (!"org.teiid.designer.core.externalResource".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            CoreArgCheck.isTrue((boolean)"org.teiid.designer.core.externalResource".equals(uniqueId), (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", new Object[]{"org.teiid.designer.core.externalResource", uniqueId}));
        }
        ExternalResourceDescriptorImpl descriptor = new ExternalResourceDescriptorImpl();
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExternalResourceDescriptorImpl_instance_1", new Object[0]));
        }
        String pluginId = extension.getNamespaceIdentifier();
        descriptor.setPluginID(pluginId);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_plugin_ID_to_2", (Object)pluginId));
        }
        descriptor.setExtensionID(extension.getSimpleIdentifier());
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_extension_ID_to_3", (Object)extension.getSimpleIdentifier()));
        }
        Properties properties = new Properties();
        IConfigurationElement[] elems = extension.getConfigurationElements();
        int j = 0;
        while (j < elems.length) {
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            String elemValue = elem.getValue();
            if (elemName != null) {
                if (elemName.equals("resourceName") && elemValue != null) {
                    descriptor.setResourceName(elemValue);
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_external_resource_name_to_4", (Object)elemValue));
                    }
                } else if (elemName.equals("resourceUrl") && elemValue != null) {
                    descriptor.setResourceUrl(elemValue);
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_external_resource_URL_to_5", (Object)elemValue));
                    }
                } else if (elemName.equals("internalUri") && elemValue != null) {
                    descriptor.setInternalUri(elemValue);
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_external_resource_URI_to_6", (Object)elemValue));
                    }
                } else if (elemName.equals("priority") && elemValue != null) {
                    descriptor.setPriority(Integer.parseInt(elemValue));
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_external_resource_priority_to_7", (Object)elemValue));
                    }
                } else if (elemName.equals("properties")) {
                    String[] propNames = elem.getAttributeNames();
                    int i = 0;
                    while (i < propNames.length) {
                        String name = propNames[i];
                        String value = elem.getAttribute(name);
                        properties.setProperty(name, value);
                        ++i;
                    }
                    descriptor.setProperties(properties);
                }
            }
            ++j;
        }
        if (descriptor.getResourceUrl() == null || descriptor.getResourceUrl().length() == 0) {
            ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.Error_the_external_resource_URL_was_not_defined_in_the_extension_1", (Object)extension.getSimpleIdentifier()));
        }
        if (descriptor.getResourceName() == null || descriptor.getResourceName().length() == 0) {
            ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.Error_the_external_resource_name_was_not_defined_in_the_extension_2", (Object)extension.getSimpleIdentifier()));
        }
        URL resourceURL = null;
        String resource = null;
        Bundle bundle = Platform.getBundle((String)pluginId);
        try {
            URL installURL = bundle.getEntry("/");
            resourceURL = bundle.getResource(descriptor.getResourceUrl());
            if (resourceURL == null) {
                resource = FileLocator.toFileURL((URL)new URL(installURL, descriptor.getResourceUrl())).getFile();
                if (resource == null || resource.length() == 0) {
                    ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.Unable_to_create_an_absolute_path_to_the_resource_1", (Object)descriptor.getResourceUrl()));
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_external_resource_URL_to_5", (Object)descriptor.getResourceUrl()));
                    }
                }
            } else {
                resource = resourceURL.toString();
            }
            if (resource != null) {
                descriptor.setResourceUrl(resource);
            }
        }
        catch (Throwable t) {
            ModelerCore.Util.log(4, t, ModelerCore.Util.getString("EclipseConfigurationBuilder.Error_creating_local_URL_for_2", (Object)descriptor.getResourceUrl()));
        }
        String tempDirPath = null;
        try {
            tempDirPath = Platform.getStateLocation((Bundle)bundle).toOSString();
            if (tempDirPath == null || tempDirPath.length() == 0) {
                ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.Unable_to_create_an_absolute_path_to_the_data_directory_for_resource_1", (Object)descriptor.getResourceUrl()));
                if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_temporary_directory_path_to_1", (Object)tempDirPath));
                }
            } else {
                descriptor.setTempDirectoryPath(tempDirPath);
            }
        }
        catch (Throwable throwable) {
            ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.Error_creating_the_absolute_path_to_the_data_directory_for_resource_2", (Object)descriptor.getResourceUrl()));
        }
        return descriptor;
    }

    public static List createValidationDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            CoreArgCheck.isNotNull((Object)extension, (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1", new Object[0]));
        }
        if (!"org.teiid.designer.core.modelValidation".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            CoreArgCheck.isTrue((boolean)"org.teiid.designer.core.modelValidation".equals(uniqueId), (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", new Object[]{"org.teiid.designer.core.modelValidation", uniqueId}));
        }
        if (ModelerCore.DEBUG_VALIDATION) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ValidationDescriptorImpl_instance_1", new Object[0]));
        }
        if (ModelerCore.DEBUG_VALIDATION) {
            Object[] params = new Object[]{extension.getSimpleIdentifier()};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_extension_ID_to", params));
        }
        IConfigurationElement[] elems = extension.getConfigurationElements();
        ArrayList<ValidationDescriptorImpl> descriptors = new ArrayList<ValidationDescriptorImpl>(elems.length);
        int j = 0;
        while (j < elems.length) {
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            if (elemName != null && elemName.equals("preference")) {
                String prefName = elem.getAttribute("name");
                String prefLabel = elem.getAttribute("label");
                String prefCategory = elem.getAttribute("category");
                String prefToolTip = elem.getAttribute("toolTip");
                String defaultValue = elem.getAttribute("default");
                if (prefName != null) {
                    ValidationDescriptorImpl descriptor = new ValidationDescriptorImpl();
                    descriptor.setExtensionID(extension.getSimpleIdentifier());
                    descriptor.setPrefernceName(prefName);
                    descriptor.setPrefernceLabel(prefLabel);
                    descriptor.setPrefernceCategory(prefCategory);
                    descriptor.setPrefernceToolTip(prefToolTip);
                    descriptor.setDefaultOption(defaultValue);
                    if (ModelerCore.DEBUG_VALIDATION) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_NAME_to", new Object[]{prefName}));
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_LABEL_to", new Object[]{prefLabel}));
                        if (prefCategory != null) {
                            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_CATEGORY_to", new Object[]{prefCategory}));
                        }
                        if (prefToolTip != null) {
                            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_TOOLTIP_to", new Object[]{prefToolTip}));
                        }
                        if (defaultValue != null) {
                            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Set_the_DEFAULT_OPTION_to_1", new Object[]{defaultValue}));
                        }
                    }
                    descriptors.add(descriptor);
                }
            }
            ++j;
        }
        return descriptors;
    }

    public static MetamodelDescriptor createMetamodelDescriptor(IExtension extension) {
        Object[] params;
        String uniqueId;
        if (extension == null) {
            CoreArgCheck.isNotNull((Object)extension, (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1", new Object[0]));
        }
        if (!"org.teiid.designer.core.metamodel".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            CoreArgCheck.isTrue((boolean)"org.teiid.designer.core.metamodel".equals(uniqueId), (String)ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", new Object[]{"org.teiid.designer.core.metamodel", uniqueId}));
        }
        Bundle bundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
        Properties properties = new Properties();
        String namespaceURI = null;
        String ePackageClassName = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        int j = 0;
        while (j < elems.length) {
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            String elemValue = elem.getValue();
            if (elemName != null) {
                if (elemName.equals("uri") && elemValue != null) {
                    namespaceURI = elemValue;
                } else if (elemName.equals("packageClass")) {
                    ePackageClassName = elem.getAttribute("name");
                }
            }
            ++j;
        }
        MetamodelDescriptorImpl descriptor = new MetamodelDescriptorImpl(namespaceURI, ePackageClassName, bundle);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_MetamodelDescriptorImpl_instance_1", new Object[0]));
            params = new Object[]{namespaceURI};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_URI_to", params));
            params = new Object[]{ePackageClassName, bundle};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_EPackage_class_name_to,_and_the_bundle_to", params));
        }
        descriptor.setExtensionID(extension.getSimpleIdentifier());
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            params = new Object[]{extension.getSimpleIdentifier()};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_extension_ID_to", params));
        }
        descriptor.setDisplayName(extension.getLabel());
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            params = new Object[]{extension.getLabel()};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_name_to", params));
        }
        int j2 = 0;
        while (j2 < elems.length) {
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            String elemValue = elem.getValue();
            if (elemName != null) {
                String className;
                Object[] params2;
                if (elemName.equals("alternateUri") && elemValue != null) {
                    descriptor.addAlternateNamespaceURI(elemValue);
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        params2 = new Object[]{elemValue};
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Adding_alternate_URI_1", params2));
                    }
                } else if (elemName.equals("displayName") && elemValue != null) {
                    descriptor.setDisplayName(elemValue);
                } else if (elemName.equals("fileExtension") && elemValue != null) {
                    descriptor.setFileExtension(elemValue);
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        params2 = new Object[]{elemValue};
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Setting_file_extension_to_1", params2));
                    }
                } else if (elemName.equals("adapterClass")) {
                    className = elem.getAttribute("name");
                    descriptor.addAdapterFactoryBundle(className, bundle);
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        Object[] params3 = new Object[]{className, bundle};
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_AdapterFactory_class_name_to,_and_the_bundle_to", params3));
                    }
                } else if (elemName.equals("allowableModelType") && elemValue != null) {
                    descriptor.addAllowableModelType(elemValue);
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        params2 = new Object[]{elemValue};
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Adding_model_type_1", params2));
                    }
                } else if (elemName.equals("rootEntityClass")) {
                    className = elem.getAttribute("name");
                    String maxOccurs = elem.getAttribute("maxOccurs");
                    MetamodelRootClassDescriptorImpl rootDescriptor = new MetamodelRootClassDescriptorImpl(uniqueId, className, bundle);
                    rootDescriptor.setMaxOccurs(maxOccurs);
                    descriptor.addRootClassDescriptor(rootDescriptor);
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        Object[] params4 = new Object[]{className, bundle};
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Added_root_entity_class_name,_and_bundle_1", params4));
                    }
                } else if (elemName.equals("properties")) {
                    String[] propNames = elem.getAttributeNames();
                    int i = 0;
                    while (i < propNames.length) {
                        String name = propNames[i];
                        String value = elem.getAttribute(name);
                        properties.setProperty(name, value);
                        ++i;
                    }
                    descriptor.setProperties(properties);
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        Object[] params5 = new Object[]{properties};
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Set_metamodel_properties_to_2", params5));
                    }
                } else if (elemName.equals("initializers")) {
                    IConfigurationElement[] initializers = elem.getChildren();
                    int i = 0;
                    while (i < initializers.length) {
                        IConfigurationElement initializer = initializers[i];
                        String initializerTagName = initializer.getName();
                        if (initializerTagName.equals("initializer")) {
                            String name = initializer.getAttribute("name");
                            String desc = initializer.getAttribute("description");
                            String className2 = initializer.getAttribute("class");
                            descriptor.addModelInitializer(name, desc, className2, bundle);
                        }
                        ++i;
                    }
                }
            }
            ++j2;
        }
        return descriptor;
    }

    private static List getMetamodelAspectExtensions() {
        ArrayList extensions = new ArrayList();
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions((String)"org.teiid.designer.core.umlDiagramAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions((String)"org.teiid.designer.core.itemProviderAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions((String)"org.teiid.designer.core.dependencyAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions((String)"org.teiid.designer.core.validationAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions((String)"org.teiid.designer.core.featureConstraintAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions((String)"org.teiid.designer.core.sqlAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions((String)"org.teiid.designer.core.relationshipAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions((String)"org.teiid.designer.core.importAspect"), extensions);
        return extensions;
    }

    private static void addExtensionsToList(IExtension[] extensions, List extensionList) {
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            if (!extensionList.contains(extension)) {
                extensionList.add(extension);
            }
            ++i;
        }
    }

    private static void addMetamodelAspect(MetamodelDescriptor descriptor, IExtension extension) {
        if (EclipseConfigurationBuilder.validMetamodelAspect(descriptor, extension)) {
            Bundle bundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
            String uniqueExtensionPointID = extension.getExtensionPointUniqueIdentifier();
            IConfigurationElement[] elems = extension.getConfigurationElements();
            int j = 0;
            while (j < elems.length) {
                IConfigurationElement elem = elems[j];
                String elemName = elem.getName();
                if (elemName.equals("factoryClass")) {
                    String className = elem.getAttribute("name");
                    ((MetamodelDescriptorImpl)descriptor).addAspectFactoryBundle(uniqueExtensionPointID, className, bundle);
                    if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                        Object[] params = new Object[]{className, bundle, uniqueExtensionPointID};
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Added_the_MetamodelAspect,_bundle,_extension_point_ID", params));
                    }
                }
                ++j;
            }
        }
    }

    private static boolean validMetamodelAspect(MetamodelDescriptor descriptor, IExtension extension) {
        if (descriptor == null || extension == null) {
            return false;
        }
        String uniqueExtensionPointID = extension.getExtensionPointUniqueIdentifier();
        if (!(uniqueExtensionPointID.equals("org.teiid.designer.core.umlDiagramAspect") || uniqueExtensionPointID.equals("org.teiid.designer.core.itemProviderAspect") || uniqueExtensionPointID.equals("org.teiid.designer.core.dependencyAspect") || uniqueExtensionPointID.equals("org.teiid.designer.core.validationAspect") || uniqueExtensionPointID.equals("org.teiid.designer.core.sqlAspect") || uniqueExtensionPointID.equals("org.teiid.designer.core.relationshipAspect") || uniqueExtensionPointID.equals("org.teiid.designer.core.importAspect") || uniqueExtensionPointID.equals("org.teiid.designer.core.featureConstraintAspect"))) {
            return false;
        }
        IConfigurationElement[] elems = extension.getConfigurationElements();
        int j = 0;
        while (j < elems.length) {
            String aspectMetamodelID;
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            String elemValue = elem.getValue();
            if (elemName.equals("metamodelExtensionID") && elemValue != null && (aspectMetamodelID = elemValue).equals(descriptor.getExtensionID())) {
                if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                    Object[] params = new Object[]{descriptor.getExtensionID(), uniqueExtensionPointID};
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Found_valid_MetamodelAspect_IExtension_for_the_metamodel.__The_extension_point_ID", params));
                }
                return true;
            }
            ++j;
        }
        return false;
    }

    static class ExternalResourceDescriptorComparator
    implements Comparator {
        ExternalResourceDescriptorComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            int value2;
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null && obj2 != null) {
                return 1;
            }
            if (obj1 != null && obj2 == null) {
                return -1;
            }
            ExternalResourceDescriptor descriptor1 = (ExternalResourceDescriptor)obj1;
            ExternalResourceDescriptor descriptor2 = (ExternalResourceDescriptor)obj2;
            int value1 = descriptor1.getPriority();
            if (value1 < (value2 = descriptor2.getPriority())) {
                return 1;
            }
            if (value1 > value2) {
                return -1;
            }
            return 0;
        }
    }
}

