/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.model.schema.impl;

import org.teiid.designer.schema.tools.model.schema.Relationship;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.BaseRelationship;

public class MergedRelationship
extends BaseRelationship {
    private Relationship parent;
    private Relationship child;

    public MergedRelationship(Relationship parent, Relationship child) {
        this.parent = parent;
        this.child = child;
    }

    @Override
    public String getParentRelativeXpath() {
        String parentPart = this.parent.getParentRelativeXpath();
        String childPart = this.child.getParentRelativeXpath();
        String retval = String.valueOf(childPart) + "/" + parentPart;
        return retval;
    }

    @Override
    public String getChildRelativeXpath() {
        String parentPart = this.parent.getChildRelativeXpath();
        String childPart = this.child.getChildRelativeXpath();
        String retval = String.valueOf(parentPart) + "/" + childPart;
        return retval;
    }

    @Override
    public SchemaObject getParent() {
        SchemaObject retval = this.parent.getParent();
        return retval;
    }

    @Override
    public SchemaObject getChild() {
        SchemaObject retval = this.child.getChild();
        return retval;
    }

    @Override
    public int getMinOccurs() {
        int parentMinOccurs = this.parent.getMinOccurs();
        int childMinOccurs = this.child.getMinOccurs();
        int retval = this.multiplyCardinalities(parentMinOccurs, childMinOccurs);
        return retval;
    }

    @Override
    public int getMaxOccurs() {
        int parentMinOccurs = this.parent.getMinOccurs();
        int childMinOccurs = this.child.getMinOccurs();
        int retval = this.multiplyCardinalities(parentMinOccurs, childMinOccurs);
        return retval;
    }

    public int getRepresentation() {
        return this.child.getType();
    }

    public String toString() {
        String childName = this.child.toString();
        String parentName = this.parent.toString();
        return String.valueOf(parentName) + ":" + childName;
    }

    @Override
    public void printDebug() {
        System.out.println("MergedRelationship: ");
        System.out.println("Begin Parent");
        this.parent.printDebug();
        System.out.println("parentRelativeXPath = " + this.getParentRelativeXpath());
        System.out.println("End Parent");
        System.out.println("Begin Child");
        this.child.printDebug();
        System.out.println("childRelativeXPath = " + this.getChildRelativeXpath());
        System.out.println("End Child");
    }
}

