/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.model.schema.impl;

import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.designer.schema.tools.model.schema.Column;
import org.teiid.designer.schema.tools.model.schema.ISchemaModelCopyTraversalContext;
import org.teiid.designer.schema.tools.model.schema.Relationship;
import org.teiid.designer.schema.tools.model.schema.RootElement;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.SchemaObjectKey;
import org.teiid.designer.schema.tools.model.schema.impl.BaseSchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.ElementImplKey;
import org.teiid.designer.schema.tools.model.schema.impl.RootElementImpl;

public class ElementImpl
extends BaseSchemaObject {
    protected XSDElementDeclaration elem;

    public XSDElementDeclaration getElem() {
        return this.elem;
    }

    public ElementImpl(XSDElementDeclaration elem, String namespacePrefix, XSDTypeDefinition type, XSDSchema schema) {
        super(namespacePrefix, type, schema);
        this.elem = elem;
        this.doesNotHaveUniqueName = false;
    }

    @Override
    public SchemaObject copy(ISchemaModelCopyTraversalContext ctx) {
        ElementImpl copy = new ElementImpl(this.elem, this.getNamespacePrefix(), this.type, this.schema);
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ElementImpl) {
            ElementImpl test = (ElementImpl)obj;
            if (this.elem == test.elem) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSimpleName() {
        String uniqueName;
        String elemName = this.elem.getName();
        if (this.doesNotHaveUniqueName) {
            String typeName = this.elem.getType().getName();
            uniqueName = String.valueOf(elemName) + '(' + typeName + ')';
        } else {
            uniqueName = elemName;
        }
        return uniqueName;
    }

    @Override
    public XSDTypeDefinition getType() {
        return this.type;
    }

    @Override
    public String getElementTypeNamespace() {
        String namespace = this.elem.getType().getTargetNamespace();
        return namespace;
    }

    @Override
    public String getNamespace() {
        return this.elem.getTargetNamespace();
    }

    @Override
    public String getName() {
        return this.elem.getName();
    }

    @Override
    public String toString() {
        String retval = this.elem.getName();
        if (this.elem.getTargetNamespace() != null) {
            retval = String.valueOf(retval) + " (" + this.elem.getTargetNamespace() + ")";
        }
        return retval;
    }

    @Override
    public RootElement getRootRepresentation() {
        return new RootElementImpl(this.getKey(), this.getSimpleName(), this.getNamespace(), this.isCanBeRoot());
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public int getMinOccurs() {
        XSDTypeDefinition def = this.elem.getTypeDefinition();
        XSDParticle particle = def.getComplexType();
        if (particle == null) {
            return 1;
        }
        return particle.getMinOccurs();
    }

    @Override
    public int getMaxOccurs() {
        XSDTypeDefinition def = this.elem.getTypeDefinition();
        XSDParticle particle = def.getComplexType();
        if (particle == null) {
            return 1;
        }
        return particle.getMaxOccurs();
    }

    public void printDebug() {
        StringBuffer buff = new StringBuffer();
        buff.append("\t SchemaObject: SimpleName = " + this.getSimpleName());
        buff.append(" ");
        buff.append("Prefix = " + this.getNamespacePrefix());
        buff.append(" ");
        buff.append("AvailableRoot = " + this.availableRoot);
        buff.append(" ");
        buff.append("doesNotHaveUniqueName = " + this.doesNotHaveUniqueName);
        buff.append(" ");
        buff.append("filename = " + this.fileName);
        buff.append(" ");
        buff.append("representAsTable = " + this.representAsTable);
        buff.append(" ");
        buff.append("withinSelectedHierarchy = " + this.withinSelectedHierarchy);
        buff.append(" ");
        System.out.println(buff.toString());
        if (this.attributes.size() > 0) {
            System.out.println("\t Attributes");
        }
        for (Column column : this.attributes) {
            column.printDebug();
        }
        if (this.children.size() > 0) {
            System.out.println("\t Children");
        }
        for (Relationship relationship : this.children) {
            relationship.printDebug();
        }
        if (this.parents.size() > 0) {
            System.out.println("\t Parents");
        }
        for (Relationship relationship : this.parents) {
            relationship.printDebug();
        }
    }

    @Override
    public SchemaObjectKey getKey() {
        return new ElementImplKey(this.elem);
    }
}

