/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.util.INewModelObjectHelper;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;

public class TransformationNewModelObjectHelper
implements INewModelObjectHelper {
    public static final String VIRTUAL_TABLE_CLEAR_SUPPORTS_UPDATE = "clearSupportsUpdate";
    public static final String VIRTUAL_PROCEDURE_TEMPLATE_SQL = "CREATE VIRTUAL PROCEDURE\nBEGIN\n <--insert SQL here-->;\nEND";

    public boolean canHelpCreate(Object newObject) {
        EObject newEObject;
        CoreArgCheck.isNotNull((Object)newObject);
        if (newObject instanceof EObject && TransformationHelper.isVirtual(newEObject = (EObject)newObject)) {
            if (TransformationHelper.isSqlTable(newEObject) && !TransformationHelper.isXmlDocument(newEObject)) {
                return true;
            }
            if (TransformationHelper.isSqlProcedure(newEObject)) {
                return true;
            }
        }
        return false;
    }

    public Object getTransactionSetting() {
        return null;
    }

    public boolean helpCreate(Object newObject, Map properties, List<EObject> references) {
        EObject newTarget;
        boolean doValidate;
        CoreArgCheck.isNotNull((Object)newObject);
        if (properties == null) {
            properties = new HashMap();
        }
        boolean defineDefaultTableSQL = properties.get("generateDefaultSQL") != null;
        boolean bl = doValidate = properties.get("validate") != null;
        if (newObject instanceof EObject && TransformationHelper.isVirtual(newTarget = (EObject)newObject)) {
            SqlAspect aspect = AspectManager.getSqlAspect((EObject)newTarget);
            if (aspect != null && aspect instanceof SqlTableAspect) {
                SqlTableAspect tableAspect = (SqlTableAspect)aspect;
                if (!TransformationHelper.hasSqlTransformationMappingRoot(newTarget)) {
                    SqlTransformationMappingRoot newRoot = ModelResourceContainerFactory.createNewSqlTransformationMappingRoot((EObject)newTarget, (boolean)false, (Object)this);
                    ModelResourceContainerFactory.addMappingHelper((Object)newRoot);
                    if (TransformationNewModelObjectHelper.isMapValueTrue(VIRTUAL_TABLE_CLEAR_SUPPORTS_UPDATE, properties, true)) {
                        tableAspect.setSupportsUpdate(newTarget, false);
                    }
                    if (defineDefaultTableSQL) {
                        EObject tRoot = TransformationHelper.getMappingRoot(newTarget);
                        List columns = tableAspect.getColumns(newTarget);
                        int count = 0;
                        StringBuilder sb = new StringBuilder();
                        if (!columns.isEmpty()) {
                            sb.append("SELECT");
                            for (Object col : columns) {
                                String colName = ModelerCore.getModelEditor().getName((EObject)col);
                                if (count > 0) {
                                    sb.append(',');
                                }
                                String seg = " null AS " + colName;
                                sb.append(seg);
                                ++count;
                            }
                            TransformationHelper.setSelectSqlString(tRoot, sb.toString(), false, this);
                            TransformationMappingHelper.reconcileMappingsOnSqlChange(tRoot, null);
                            TransformationMappingHelper.reconcileTargetAttributes(tRoot, null);
                        }
                        if (doValidate) {
                            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)tRoot);
                            validator.validateSql(sb.toString(), 0, true);
                        }
                    }
                    return true;
                }
                if (defineDefaultTableSQL) {
                    EObject tRoot = TransformationHelper.getMappingRoot(newTarget);
                    List columns = tableAspect.getColumns(newTarget);
                    int count = 0;
                    StringBuilder sb = new StringBuilder();
                    if (!columns.isEmpty()) {
                        sb.append("SELECT");
                        for (Object col : columns) {
                            String colName = ModelerCore.getModelEditor().getName((EObject)col);
                            if (count > 0) {
                                sb.append(',');
                            }
                            String seg = " null AS " + colName;
                            sb.append(seg);
                            ++count;
                        }
                        TransformationHelper.setSelectSqlString(tRoot, sb.toString(), false, this);
                        TransformationMappingHelper.reconcileMappingsOnSqlChange(tRoot, null);
                        TransformationMappingHelper.reconcileTargetAttributes(tRoot, null);
                    }
                    if (doValidate) {
                        TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)tRoot);
                        validator.validateSql(sb.toString(), 0, true);
                    }
                }
            } else if (TransformationHelper.isSqlProcedure(newTarget) && !TransformationHelper.isOperation(newTarget)) {
                if (!TransformationHelper.hasSqlTransformationMappingRoot(newTarget)) {
                    SqlTransformationMappingRoot newRoot = ModelResourceContainerFactory.createNewSqlTransformationMappingRoot((EObject)newTarget, (boolean)false, (Object)this);
                    ModelResourceContainerFactory.addMappingHelper((Object)newRoot);
                }
                if (defineDefaultTableSQL) {
                    EObject tRoot = TransformationHelper.getMappingRoot(newTarget);
                    TransformationHelper.setSelectSqlString(tRoot, VIRTUAL_PROCEDURE_TEMPLATE_SQL, false, this);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isMapValueTrue(String propertyName, Map properties, boolean defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        Boolean bool = (Boolean)properties.get(propertyName);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }
}

