/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TransformationContainer;
import org.teiid.designer.transformation.util.TransformationHelper;

public class TransformationSearchHelper {
    private boolean caseSensitive = false;
    private boolean wholeWordMatch = false;

    public Collection findTransformations(String searchStr) throws CoreException {
        ModelWorkspaceManager manager = ModelWorkspaceManager.getModelWorkspaceManager();
        ModelResource[] mResources = manager.getModelWorkspace().getModelResources();
        ArrayList allAffectedTransforms = new ArrayList();
        int i = 0;
        while (i < mResources.length) {
            Collection transforms = this.findTransformations(searchStr, mResources[i]);
            if (!transforms.isEmpty()) {
                allAffectedTransforms.addAll(transforms);
            }
            ++i;
        }
        return allAffectedTransforms;
    }

    public Collection findTransformationTargets(String searchStr) throws CoreException {
        ModelWorkspaceManager manager = ModelWorkspaceManager.getModelWorkspaceManager();
        ModelResource[] mResources = manager.getModelWorkspace().getModelResources();
        ArrayList allAffectedTransformTargets = new ArrayList();
        int i = 0;
        while (i < mResources.length) {
            Collection transformTargets = this.findTransformationTargets(searchStr, mResources[i]);
            if (!transformTargets.isEmpty()) {
                allAffectedTransformTargets.addAll(transformTargets);
            }
            ++i;
        }
        return allAffectedTransformTargets;
    }

    public Collection findTransformations(String searchStr, ModelResource mr) throws ModelWorkspaceException {
        ArrayList<Object> allAffectedTransforms = new ArrayList<Object>(1);
        if (mr != null && mr.getModelTransformations() != null) {
            List allTransforms = mr.getModelTransformations().getTransformations();
            Object nextObj2 = null;
            for (Object nextObj2 : allTransforms) {
                SqlTransformationMappingRoot mappingRoot;
                if (!TransformationHelper.isSqlTransformationMappingRoot(nextObj2) || !this.searchTransformationRoot(searchStr, mappingRoot = (SqlTransformationMappingRoot)nextObj2)) continue;
                allAffectedTransforms.add(nextObj2);
            }
        }
        return allAffectedTransforms;
    }

    public Collection findTransformations(String searchStr, Resource resource) {
        ArrayList<Object> allAffectedTransforms = new ArrayList<Object>(1);
        Collection allTransforms = TransformationSearchHelper.getTransformations(resource);
        Object nextObj2 = null;
        for (Object nextObj2 : allTransforms) {
            SqlTransformationMappingRoot mappingRoot;
            if (!TransformationHelper.isSqlTransformationMappingRoot(nextObj2) || !this.searchTransformationRoot(searchStr, mappingRoot = (SqlTransformationMappingRoot)nextObj2)) continue;
            allAffectedTransforms.add(nextObj2);
        }
        return allAffectedTransforms;
    }

    public Collection findTransformationTargets(String searchStr, Resource resource) {
        Collection allAffectedTransforms = this.findTransformations(searchStr, resource);
        return this.getAllTransformationTargets(allAffectedTransforms);
    }

    public Collection findTransformationTargets(String searchStr, ModelResource resource) throws ModelWorkspaceException {
        Collection allAffectedTransforms = this.findTransformations(searchStr, resource);
        return this.getAllTransformationTargets(allAffectedTransforms);
    }

    public boolean searchTransformationRoot(String searchStr, SqlTransformationMappingRoot mappingRoot) {
        boolean supportsUpdates = false;
        EObject mRootTarget = mappingRoot.getTarget();
        SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)mRootTarget);
        if (sqlAspect != null && sqlAspect instanceof SqlTableAspect) {
            supportsUpdates = ((SqlTableAspect)sqlAspect).supportsUpdate(mRootTarget);
        }
        boolean foundMatch = false;
        if (!this.caseSensitive) {
            String lowerCaseStr;
            String lowerCaseSearchStr = searchStr.toLowerCase();
            String sqlStr = TransformationSearchHelper.getUserSql(mappingRoot, 0);
            if (sqlStr != null) {
                lowerCaseStr = sqlStr.toLowerCase();
                boolean bl = foundMatch = lowerCaseStr.indexOf(lowerCaseSearchStr) > -1;
            }
            if (!foundMatch && supportsUpdates) {
                sqlStr = TransformationSearchHelper.getUserSql(mappingRoot, 1);
                if (sqlStr != null) {
                    lowerCaseStr = sqlStr.toLowerCase();
                    boolean bl = foundMatch = lowerCaseStr.indexOf(lowerCaseSearchStr) > -1;
                }
                if (!foundMatch) {
                    sqlStr = TransformationSearchHelper.getUserSql(mappingRoot, 2);
                    if (sqlStr != null) {
                        lowerCaseStr = sqlStr.toLowerCase();
                        boolean bl = foundMatch = lowerCaseStr.indexOf(lowerCaseSearchStr) > -1;
                    }
                    if (!foundMatch && (sqlStr = TransformationSearchHelper.getUserSql(mappingRoot, 3)) != null) {
                        lowerCaseStr = sqlStr.toLowerCase();
                        foundMatch = lowerCaseStr.indexOf(lowerCaseSearchStr) > -1;
                    }
                }
            }
        } else {
            String sqlStr = TransformationSearchHelper.getUserSql(mappingRoot, 0);
            if (sqlStr != null) {
                boolean bl = foundMatch = sqlStr.indexOf(searchStr) > -1;
            }
            if (!foundMatch && supportsUpdates) {
                sqlStr = TransformationSearchHelper.getUserSql(mappingRoot, 1);
                if (sqlStr != null) {
                    boolean bl = foundMatch = sqlStr.indexOf(searchStr) > -1;
                }
                if (!foundMatch) {
                    sqlStr = TransformationSearchHelper.getUserSql(mappingRoot, 2);
                    if (sqlStr != null) {
                        boolean bl = foundMatch = sqlStr.indexOf(searchStr) > -1;
                    }
                    if (!foundMatch && (sqlStr = TransformationSearchHelper.getUserSql(mappingRoot, 3)) != null) {
                        foundMatch = sqlStr.indexOf(searchStr) > -1;
                    }
                }
            }
        }
        return foundMatch;
    }

    public static Collection getTransformations(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        ArrayList transformations = new ArrayList();
        EList contents = resource.getContents();
        for (Object obj : contents) {
            if (!(obj instanceof TransformationContainer)) continue;
            EList mappings = ((TransformationContainer)obj).getTransformationMappings();
            transformations.addAll(mappings);
            break;
        }
        return transformations;
    }

    public static boolean hasUserSql(SqlTransformationMappingRoot mappingRoot, int sqlType) {
        SqlTransformation sqlTransform = TransformationHelper.getUserSqlTransformation(mappingRoot);
        if (sqlTransform != null) {
            switch (sqlType) {
                case 0: {
                    return sqlTransform.getSelectSql() != null;
                }
                case 2: {
                    return sqlTransform.getUpdateSql() != null;
                }
                case 1: {
                    return sqlTransform.getInsertSql() != null;
                }
                case 3: {
                    return sqlTransform.getDeleteSql() != null;
                }
            }
        }
        return false;
    }

    public static String getUserSql(SqlTransformationMappingRoot mappingRoot, int sqlType) {
        SqlTransformation sqlTransform = TransformationHelper.getUserSqlTransformation(mappingRoot);
        if (sqlTransform != null) {
            switch (sqlType) {
                case 0: {
                    return sqlTransform.getSelectSql();
                }
                case 2: {
                    return sqlTransform.getUpdateSql();
                }
                case 1: {
                    return sqlTransform.getInsertSql();
                }
                case 3: {
                    return sqlTransform.getDeleteSql();
                }
            }
        }
        return "";
    }

    public Collection getAllTransformationTargets(Collection allTransforms) {
        int nTransforms = allTransforms.size();
        ArrayList<EObject> allTargets = new ArrayList<EObject>(nTransforms);
        for (Object obj : allTransforms) {
            EObject table;
            if (!(obj instanceof SqlTransformationMappingRoot) || (table = ((SqlTransformationMappingRoot)obj).getTarget()) == null) continue;
            allTargets.add(table);
        }
        return allTargets;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean value) {
        this.caseSensitive = value;
    }

    public boolean isWholeWordMatch() {
        return this.wholeWordMatch;
    }

    public void setWwholeWordMatch(boolean value) {
        this.caseSensitive = this.wholeWordMatch;
    }
}

