/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.metadata;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.script.ScriptEngine;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.ModelType;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.CompositeIndexSelector;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.RuntimeIndexSelector;
import org.teiid.designer.core.index.SimpleIndexUtil;
import org.teiid.designer.metadata.runtime.ColumnRecord;
import org.teiid.designer.metadata.runtime.ColumnRecordComparator;
import org.teiid.designer.metadata.runtime.ColumnSetRecord;
import org.teiid.designer.metadata.runtime.DatatypeRecord;
import org.teiid.designer.metadata.runtime.ForeignKeyRecord;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.metadata.runtime.ModelRecord;
import org.teiid.designer.metadata.runtime.ProcedureParameterRecord;
import org.teiid.designer.metadata.runtime.ProcedureRecord;
import org.teiid.designer.metadata.runtime.PropertyRecord;
import org.teiid.designer.metadata.runtime.TableRecord;
import org.teiid.designer.metadata.runtime.TransformationRecord;
import org.teiid.designer.metadata.runtime.VdbRecord;
import org.teiid.designer.metadata.runtime.impl.RecordFactory;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.metadata.IQueryNode;
import org.teiid.designer.query.metadata.IStoredProcedureInfo;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.metadata.QueryMetadataContext;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.designer.udf.UdfManager;
import org.teiid.designer.xml.IMappingDocument;
import org.teiid.designer.xml.IMappingDocumentFactory;
import org.teiid.designer.xml.IMappingNode;

public class TransformationMetadata
implements IQueryMetadataInterface {
    private static int NULLABLE = 1;
    private static int NULLABLE_UNKNOWN = 2;
    private static int SEARCHABLE = 0;
    private static int ALL_EXCEPT_LIKE = 1;
    private static int LIKE_ONLY = 2;
    public static final char DELIMITER_CHAR = '.';
    protected static final String DELIMITER_STRING = ".";
    private static ColumnRecordComparator columnComparator = new ColumnRecordComparator();
    private static String NOT_EXISTS_MESSAGE = String.valueOf(CoreStringUtil.Constants.SPACE) + TransformationPlugin.Util.getString("TransformationMetadata.does_not_exist._1");
    private final QueryMetadataContext context;

    protected TransformationMetadata(QueryMetadataContext context) {
        CoreArgCheck.isNotNull((Object)context);
        this.context = context;
    }

    public ITeiidServerVersion getTeiidVersion() {
        return ModelerCore.getTeiidServerVersion();
    }

    public Object getElementID(String elementName) throws Exception {
        CoreArgCheck.isNotEmpty((String)elementName);
        if (CoreStringUtil.startsWithIgnoreCase((String)elementName, (String)"mmuuid") || CoreStringUtil.getTokens((String)elementName, (String)DELIMITER_STRING).size() >= 3) {
            return this.getRecordByType(elementName, 'G');
        }
        throw new Exception(String.valueOf(elementName) + NOT_EXISTS_MESSAGE);
    }

    public Object getGroupID(String groupName) throws Exception {
        CoreArgCheck.isNotEmpty((String)groupName);
        if (CoreStringUtil.startsWithIgnoreCase((String)groupName, (String)"mmuuid") || CoreStringUtil.getTokens((String)groupName, (String)DELIMITER_STRING).size() >= 2) {
            return this.getRecordByType(groupName, 'B');
        }
        throw new Exception(String.valueOf(groupName) + NOT_EXISTS_MESSAGE);
    }

    public Collection getGroupsForPartialName(String partialGroupName) throws Exception {
        CoreArgCheck.isNotEmpty((String)partialGroupName);
        Collection tableRecords = null;
        String partialName = partialGroupName;
        if (!CoreStringUtil.startsWithIgnoreCase((String)partialGroupName, (String)"mmuuid")) {
            partialName = String.valueOf('.') + partialGroupName;
        }
        tableRecords = this.findMetadataRecords('B', partialName, true);
        ArrayList<String> tableNames = new ArrayList<String>(tableRecords.size());
        for (TableRecord tableRecord : tableRecords) {
            tableNames.add(this.getFullName(tableRecord));
        }
        return tableNames;
    }

    public Object getModelID(Object groupOrElementID) throws Exception {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)groupOrElementID);
        MetadataRecord metadataRecord = (MetadataRecord)groupOrElementID;
        String modelName = metadataRecord.getModelName();
        return this.getRecordByType(modelName, 'A');
    }

    public String getFullName(Object metadataID) {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        MetadataRecord metadataRecord = (MetadataRecord)metadataID;
        return metadataRecord.getFullName();
    }

    public List getElementIDsInGroupID(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        String groupUUID = tableRecord.getUUID();
        CoreArgCheck.isNotNull((Object)groupUUID);
        Collection results = this.findChildRecords((MetadataRecord)tableRecord, 'G');
        if (results.isEmpty()) {
            throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.Group(0}_does_not_have_elements", (Object)groupName));
        }
        ArrayList columnRecords = new ArrayList(results);
        Collections.sort(columnRecords, columnComparator);
        return columnRecords;
    }

    public Object getGroupIDForElementID(Object elementID) throws Exception {
        if (elementID instanceof ColumnRecord) {
            ColumnRecord columnRecord = (ColumnRecord)elementID;
            String tableUUID = columnRecord.getParentUUID();
            return this.getGroupID(tableUUID);
        }
        if (elementID instanceof ProcedureParameterRecord) {
            ProcedureParameterRecord columnRecord = (ProcedureParameterRecord)elementID;
            String tableUUID = columnRecord.getParentUUID();
            return this.getGroupID(tableUUID);
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public IStoredProcedureInfo getStoredProcedureInfoForProcedure(String procedureName) throws Exception {
        IStoredProcedureInfo result = this.getStoredProcInfoDirect(procedureName);
        if (result == null) {
            throw new Exception(String.valueOf(procedureName) + NOT_EXISTS_MESSAGE);
        }
        return result;
    }

    public boolean hasProcedure(String name) {
        try {
            return this.getStoredProcInfoDirect(name) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private ISPParameter.ParameterInfo convertParamRecordTypeToStoredProcedureType(int parameterType) {
        switch (parameterType) {
            case 0: {
                return ISPParameter.ParameterInfo.IN;
            }
            case 1: {
                return ISPParameter.ParameterInfo.OUT;
            }
            case 2: {
                return ISPParameter.ParameterInfo.INOUT;
            }
            case 3: {
                return ISPParameter.ParameterInfo.RETURN_VALUE;
            }
            case 4: {
                return ISPParameter.ParameterInfo.RESULT_SET;
            }
        }
        throw new RuntimeException();
    }

    public String getElementType(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getRuntimeType();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getRuntimeType();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public Object getDefaultValue(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getDefaultValue();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getDefaultValue();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public Object getMinimumValue(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getMinValue();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public Object getMaximumValue(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getMaxValue();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public boolean isVirtualGroup(Object groupID) {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        return ((TableRecord)groupID).isVirtual();
    }

    public boolean isProcedure(Object groupID) {
        if (groupID instanceof ProcedureRecord) {
            return true;
        }
        if (groupID instanceof TableRecord) {
            return false;
        }
        throw this.createInvalidRecordTypeException(groupID);
    }

    public boolean isVirtualModel(Object modelID) {
        CoreArgCheck.isInstanceOf(ModelRecord.class, (Object)modelID);
        ModelRecord modelRecord = (ModelRecord)modelID;
        return modelRecord.getModelType() == ModelType.VIRTUAL;
    }

    public IQueryNode getVirtualPlan(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            int resultSize;
            Collection results = this.findMetadataRecords('P', groupName, false);
            if (results.isEmpty()) {
                results = this.findMetadataRecords('U', groupName, false);
            }
            if ((resultSize = results.size()) == 1) {
                TransformationRecord transformRecord = (TransformationRecord)results.iterator().next();
                String transQuery = transformRecord.getTransformation();
                IQueryService queryService = ModelerCore.getTeiidQueryService();
                IQueryFactory factory = queryService.createQueryFactory();
                IQueryNode queryNode = factory.createQueryNode(transQuery);
                List bindings = transformRecord.getBindings();
                if (bindings != null) {
                    Iterator bindIter = bindings.iterator();
                    while (bindIter.hasNext()) {
                        queryNode.addBinding((String)bindIter.next());
                    }
                }
                return queryNode;
            }
            if (resultSize == 0) {
                throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Could_not_find_query_plan_for_the_group__5")) + groupName);
            }
            if (resultSize > 1) {
                throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.GroupID_ambiguous_there_are_multiple_virtual_plans_available_for_this_groupID__1")) + groupName);
            }
        }
        throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.QueryPlan_could_not_be_found_for_physical_group__6")) + groupName);
    }

    public String getInsertPlan(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            Collection results = this.findMetadataRecords('Q', groupName, false);
            int resultSize = results.size();
            if (resultSize == 1) {
                TransformationRecord transformRecord = (TransformationRecord)results.iterator().next();
                return transformRecord.getTransformation();
            }
            if (resultSize == 0) {
                return null;
            }
            if (resultSize > 1) {
                throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.GroupID_ambiguous_there_are_multiple_insert_plans_available_for_this_groupID__2")) + groupName);
            }
        }
        throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.InsertPlan_could_not_be_found_for_physical_group__8")) + groupName);
    }

    public String getUpdatePlan(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            Collection results = this.findMetadataRecords('R', groupName, false);
            int resultSize = results.size();
            if (resultSize == 1) {
                TransformationRecord transformRecord = (TransformationRecord)results.iterator().next();
                return transformRecord.getTransformation();
            }
            if (resultSize == 0) {
                return null;
            }
            if (resultSize > 1) {
                throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.GroupID_ambiguous_there_are_multiple_update_plans_available_for_this_groupID__3")) + groupName);
            }
        }
        throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.InsertPlan_could_not_be_found_for_physical_group__10")) + groupName);
    }

    public String getDeletePlan(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            Collection results = this.findMetadataRecords('S', groupName, false);
            int resultSize = results.size();
            if (resultSize == 1) {
                TransformationRecord transformRecord = (TransformationRecord)results.iterator().next();
                return transformRecord.getTransformation();
            }
            if (resultSize == 0) {
                return null;
            }
            if (resultSize > 1) {
                throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.GroupID_ambiguous_there_are_multiple_delete_plans_available_for_this_groupID__4")) + groupName);
            }
        }
        throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.DeletePlan_could_not_be_found_for_physical_group__12")) + groupName);
    }

    public boolean modelSupports(Object modelID, int modelConstant) {
        CoreArgCheck.isInstanceOf(ModelRecord.class, (Object)modelID);
        throw new UnsupportedOperationException(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12")) + modelConstant);
    }

    public boolean groupSupports(Object groupID, int groupConstant) {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        switch (groupConstant) {
            case 0: {
                return tableRecord.supportsUpdate();
            }
        }
        throw new UnsupportedOperationException(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12")) + groupConstant);
    }

    public boolean elementSupports(Object elementID, int elementConstant) {
        if (elementID instanceof ColumnRecord) {
            ColumnRecord columnRecord = (ColumnRecord)elementID;
            switch (elementConstant) {
                case 4: {
                    int ntype1 = columnRecord.getNullType();
                    return ntype1 == NULLABLE;
                }
                case 10: {
                    int ntype2 = columnRecord.getNullType();
                    return ntype2 == NULLABLE_UNKNOWN;
                }
                case 2: {
                    int stype1 = columnRecord.getSearchType();
                    return stype1 == SEARCHABLE || stype1 == ALL_EXCEPT_LIKE;
                }
                case 1: {
                    int stype2 = columnRecord.getSearchType();
                    return stype2 == SEARCHABLE || stype2 == LIKE_ONLY;
                }
                case 0: {
                    return columnRecord.isSelectable();
                }
                case 5: {
                    return columnRecord.isUpdatable();
                }
                case 7: {
                    Object defaultValue = columnRecord.getDefaultValue();
                    return defaultValue != null;
                }
                case 8: {
                    return columnRecord.isAutoIncrementable();
                }
                case 9: {
                    return columnRecord.isCaseSensitive();
                }
                case 11: {
                    return columnRecord.isSigned();
                }
            }
            throw new UnsupportedOperationException(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12")) + elementConstant);
        }
        if (elementID instanceof ProcedureParameterRecord) {
            ProcedureParameterRecord columnRecord = (ProcedureParameterRecord)elementID;
            switch (elementConstant) {
                case 4: {
                    int ntype1 = columnRecord.getNullType();
                    return ntype1 == NULLABLE;
                }
                case 10: {
                    int ntype2 = columnRecord.getNullType();
                    return ntype2 == NULLABLE_UNKNOWN;
                }
                case 1: 
                case 2: {
                    return false;
                }
                case 0: {
                    return columnRecord.getType() != 0;
                }
                case 5: {
                    return false;
                }
                case 7: {
                    Object defaultValue = columnRecord.getDefaultValue();
                    return defaultValue != null;
                }
                case 8: {
                    return false;
                }
                case 9: {
                    return false;
                }
                case 11: {
                    return true;
                }
            }
            throw new UnsupportedOperationException(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12")) + elementConstant);
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    private IllegalArgumentException createInvalidRecordTypeException(Object elementID) {
        return new IllegalArgumentException(TransformationPlugin.Util.getString("TransformationMetadata.Invalid_type", (Object)elementID.getClass().getName()));
    }

    public int getMaxSetSize(Object modelID) {
        CoreArgCheck.isInstanceOf(ModelRecord.class, (Object)modelID);
        return ((ModelRecord)modelID).getMaxSetSize();
    }

    public Collection getIndexesInGroup(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupUUID = tableRecord.getUUID();
        CoreArgCheck.isNotNull((Object)groupUUID);
        Collection indexIDs = tableRecord.getIndexIDs();
        HashSet indexRecords = new HashSet(indexIDs.size());
        for (String indexID : tableRecord.getIndexIDs()) {
            Collection results = this.findMetadataRecords('L', indexID, false);
            if (results.size() != 1) {
                if (results.isEmpty()) {
                    throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.No_metadata_info_available_for_the_index_with_UUID_{0}._1", (Object)indexID));
                }
                throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.Ambigous_index_with_UUID_{0},_found_multiple_indexes_with_the_given_UUID._2", (Object)indexID));
            }
            indexRecords.addAll(results);
        }
        return indexRecords;
    }

    public Collection getUniqueKeysInGroup(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupUUID = tableRecord.getUUID();
        CoreArgCheck.isNotNull((Object)groupUUID);
        return this.findChildRecords((MetadataRecord)tableRecord, 'I');
    }

    public Collection getForeignKeysInGroup(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupUUID = tableRecord.getUUID();
        CoreArgCheck.isNotNull((Object)groupUUID);
        return this.findChildRecords((MetadataRecord)tableRecord, 'J');
    }

    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws Exception {
        CoreArgCheck.isInstanceOf(ForeignKeyRecord.class, (Object)foreignKeyID);
        ForeignKeyRecord fkRecord = (ForeignKeyRecord)foreignKeyID;
        String uuid = (String)fkRecord.getUniqueKeyID();
        return this.getRecordByType(uuid, 'K');
    }

    public Collection getAccessPatternsInGroup(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupUUID = tableRecord.getUUID();
        CoreArgCheck.isNotNull((Object)groupUUID);
        return this.findChildRecords((MetadataRecord)tableRecord, 'H');
    }

    public List getElementIDsInIndex(Object index) throws Exception {
        boolean recordMatch;
        CoreArgCheck.isInstanceOf(ColumnSetRecord.class, (Object)index);
        ColumnSetRecord indexRecord = (ColumnSetRecord)index;
        boolean bl = recordMatch = indexRecord.getRecordType() == 'L';
        if (!recordMatch) {
            throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.The_metadataID_passed_does_not_match_a_index_record._1"));
        }
        List uuids = indexRecord.getColumnIDs();
        ArrayList<Object> columnRecords = new ArrayList<Object>(uuids.size());
        for (String uuid : uuids) {
            columnRecords.add(this.getElementID(uuid));
        }
        return columnRecords;
    }

    public List getElementIDsInKey(Object key) throws Exception {
        boolean recordMatch;
        CoreArgCheck.isInstanceOf(ColumnSetRecord.class, (Object)key);
        ColumnSetRecord keyRecord = (ColumnSetRecord)key;
        boolean bl = recordMatch = keyRecord.getRecordType() == 'J' || keyRecord.getRecordType() == 'K' || keyRecord.getRecordType() == 'I';
        if (!recordMatch) {
            throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.Expected_id_of_the_type_key_record_as_the_argument_2"));
        }
        List uuids = keyRecord.getColumnIDs();
        String groupUUID = keyRecord.getParentUUID();
        CoreArgCheck.isNotNull((Object)groupUUID);
        TableRecord tableRecord = (TableRecord)this.getGroupID(groupUUID);
        Collection results = this.findChildRecordsForColumns((MetadataRecord)tableRecord, 'G', uuids);
        if (results.isEmpty()) {
            throw new Exception(String.valueOf(tableRecord.getFullName()) + NOT_EXISTS_MESSAGE);
        }
        return new ArrayList(results);
    }

    public List getElementIDsInAccessPattern(Object accessPattern) throws Exception {
        boolean recordMatch;
        CoreArgCheck.isInstanceOf(ColumnSetRecord.class, (Object)accessPattern);
        ColumnSetRecord accessRecord = (ColumnSetRecord)accessPattern;
        boolean bl = recordMatch = accessRecord.getRecordType() == 'H';
        if (!recordMatch) {
            throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.Expected_id_of_the_type_accesspattern_record_as_the_argument_3"));
        }
        List uuids = accessRecord.getColumnIDs();
        String groupUUID = accessRecord.getParentUUID();
        CoreArgCheck.isNotNull((Object)groupUUID);
        TableRecord tableRecord = (TableRecord)this.getGroupID(groupUUID);
        Collection results = this.findChildRecordsForColumns((MetadataRecord)tableRecord, 'G', uuids);
        if (results.isEmpty()) {
            throw new Exception(String.valueOf(tableRecord.getFullName()) + NOT_EXISTS_MESSAGE);
        }
        return new ArrayList(results);
    }

    public boolean isXMLGroup(Object groupID) {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        return tableRecord.getTableType() == 2;
    }

    public boolean hasMaterialization(Object groupID) {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        return tableRecord.isMaterialized();
    }

    public Object getMaterialization(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        if (tableRecord.isMaterialized()) {
            String uuid = (String)tableRecord.getMaterializedTableID();
            return this.getGroupID(uuid);
        }
        return null;
    }

    public Object getMaterializationStage(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        if (tableRecord.isMaterialized()) {
            String uuid = (String)tableRecord.getMaterializedStageTableID();
            return this.getGroupID(uuid);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMappingNode getMappingNode(Object groupID) throws Exception {
        IMappingDocument iMappingDocument;
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        if (!tableRecord.isVirtual()) return null;
        TransformationRecord transformRecord = null;
        Collection results = this.findMetadataRecords('U', groupName, false);
        int resultSize = results.size();
        if (resultSize == 1) {
            transformRecord = (TransformationRecord)results.iterator().next();
        } else {
            if (resultSize == 0) {
                throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Could_not_find_transformation_record_for_the_group__1")) + groupName);
            }
            if (resultSize > 1) {
                throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Multiple_transformation_records_found_for_the_group___1")) + groupName);
            }
        }
        String document = transformRecord.getTransformation();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(document.getBytes());
        IMappingDocument mappingDoc = null;
        try {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            IMappingDocumentFactory factory = queryService.getMappingDocumentFactory();
            iMappingDocument = mappingDoc = factory.loadMappingDocument((InputStream)inputStream, groupName);
        }
        catch (Exception e) {
            try {
                throw new TeiidDesignerException((Throwable)e, TransformationPlugin.Util.getString("TransformationMetadata.Error_trying_to_read_virtual_document_{0},_with_body__n{1}_1", new Object[]{groupName, mappingDoc}));
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)inputStream).close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)inputStream).close();
            return iMappingDocument;
        }
        catch (Exception exception) {}
        return iMappingDocument;
    }

    public String getVirtualDatabaseName() {
        try {
            VdbRecord vdbRecord = (VdbRecord)this.getRecordByType(null, 'V');
            return vdbRecord.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection<Object> getXMLTempGroups(Object groupID) throws Exception {
        Collection results;
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        int tableType = tableRecord.getTableType();
        if (tableType == 2 && !(results = this.findChildRecordsWithoutFiltering((MetadataRecord)tableRecord, 'B')).isEmpty()) {
            HashSet<Object> tempGroups = new HashSet<Object>(results.size());
            for (TableRecord record : results) {
                if (record.getTableType() != 4) continue;
                tempGroups.add(record);
            }
            return tempGroups;
        }
        return Collections.EMPTY_SET;
    }

    public float getCardinality(Object groupID) {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        return ((TableRecord)groupID).getCardinality();
    }

    public List getXMLSchemas(Object groupID) throws Exception {
        if (!(this.getIndexSelector() instanceof CompositeIndexSelector) && !(this.getIndexSelector() instanceof RuntimeIndexSelector)) {
            return Collections.EMPTY_LIST;
        }
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String groupName = tableRecord.getFullName();
        TransformationRecord transformRecord = null;
        Collection results = this.findMetadataRecords('U', groupName, false);
        int resultSize = results.size();
        if (resultSize == 1) {
            transformRecord = (TransformationRecord)results.iterator().next();
        } else {
            if (resultSize == 0) {
                throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Could_not_find_transformation_record_for_the_group__1")) + groupName);
            }
            if (resultSize > 1) {
                throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Multiple_transformation_records_found_for_the_group___1")) + groupName);
            }
        }
        List schemaPaths = transformRecord.getSchemaPaths();
        LinkedList<String> fullPaths = new LinkedList<String>();
        for (String string : schemaPaths) {
            fullPaths.add(string);
        }
        List schemas = this.getIndexSelector().getFileContentsAsString(fullPaths);
        if ((schemas == null || schemas.isEmpty()) && ((schemas = this.getIndexSelector().getFileContentsAsString(schemaPaths)) == null || schemas.isEmpty())) {
            throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Error_trying_to_read_schemas_for_the_document/table____1")) + groupName);
        }
        return schemas;
    }

    public String getNameInSource(Object metadataID) {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        return ((MetadataRecord)metadataID).getNameInSource();
    }

    public int getElementLength(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getLength();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getLength();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public int getPosition(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getPosition();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getPosition();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public int getPrecision(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getPrecision();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getPrecision();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public int getRadix(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getRadix();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getRadix();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public String getFormat(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getFormat();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public int getScale(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getScale();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return ((ProcedureParameterRecord)elementID).getScale();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public float getDistinctValues(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getDistinctValues();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return -1.0f;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public float getNullValues(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getNullValues();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return -1.0f;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public String getNativeType(Object elementID) {
        if (elementID instanceof ColumnRecord) {
            return ((ColumnRecord)elementID).getNativeType();
        }
        if (elementID instanceof ProcedureParameterRecord) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    public Properties getExtensionProperties(Object metadataID) throws Exception {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        MetadataRecord metadataRecord = (MetadataRecord)metadataID;
        Properties extProps = new Properties();
        String uuid = metadataRecord.getUUID();
        String prefixString = this.getUUIDPrefixPattern('X', uuid);
        Index[] indexes = this.getIndexes('X', this.getIndexSelector());
        IEntryResult[] results = this.queryIndex(indexes, prefixString.toCharArray(), true, true);
        if (results != null && results.length > 0) {
            int i = 0;
            while (i < results.length) {
                PropertyRecord record;
                if (results[i] != null && (record = (PropertyRecord)this.findMetadataRecord(results[i])) != null) {
                    extProps.setProperty(record.getPropertyName(), record.getPropertyValue());
                }
                ++i;
            }
        }
        return extProps;
    }

    public byte[] getBinaryVDBResource(String resourcePath) throws Exception {
        String content = this.getCharacterVDBResource(resourcePath);
        if (content != null) {
            return content.getBytes();
        }
        return null;
    }

    public String getCharacterVDBResource(String resourcePath) throws Exception {
        CompositeIndexSelector compSelector;
        List selectors;
        IndexSelector selector = this.getIndexSelector();
        try {
            selector.getIndexes();
        }
        catch (IOException e) {
            throw new TeiidDesignerException((Throwable)e, TransformationPlugin.Util.getString("TransformationMetadata.error_intialize_selector"));
        }
        if (selector instanceof CompositeIndexSelector && (selectors = (compSelector = (CompositeIndexSelector)selector).getIndexSelectors()).size() > 0) {
            IndexSelector firstSelector = (IndexSelector)selectors.get(0);
            return firstSelector.getFileContentAsString(resourcePath);
        }
        return selector.getFileContentAsString(resourcePath);
    }

    public String[] getVDBResourcePaths() throws Exception {
        CompositeIndexSelector compSelector;
        List selectors;
        IndexSelector selector = this.getIndexSelector();
        try {
            selector.getIndexes();
        }
        catch (IOException e) {
            throw new TeiidDesignerException((Throwable)e, TransformationPlugin.Util.getString("TransformationMetadata.error_intialize_selector"));
        }
        if (selector instanceof CompositeIndexSelector && (selectors = (compSelector = (CompositeIndexSelector)selector).getIndexSelectors()).size() > 0) {
            IndexSelector firstSelector = (IndexSelector)selectors.get(0);
            return firstSelector.getFilePaths();
        }
        return selector.getFilePaths();
    }

    public String getModeledType(Object elementID) throws Exception {
        DatatypeRecord record = this.getDatatypeRecord(elementID);
        if (record != null) {
            return record.getDatatypeID();
        }
        return null;
    }

    public String getModeledBaseType(Object elementID) throws Exception {
        DatatypeRecord record = this.getDatatypeRecord(elementID);
        if (record != null) {
            return record.getBasetypeID();
        }
        return null;
    }

    public String getModeledPrimitiveType(Object elementID) throws Exception {
        DatatypeRecord record = this.getDatatypeRecord(elementID);
        if (record != null) {
            return record.getPrimitiveTypeID();
        }
        return null;
    }

    public Object getPrimaryKey(Object metadataID) {
        Collection pk;
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)metadataID);
        TableRecord tableRecord = (TableRecord)metadataID;
        String groupUUID = tableRecord.getUUID();
        CoreArgCheck.isNotNull((Object)groupUUID);
        try {
            pk = this.findChildRecords((MetadataRecord)tableRecord, 'K');
        }
        catch (Exception e) {
            throw new TeiidDesignerRuntimeException((Throwable)e);
        }
        if (pk.size() > 1) {
            throw new TeiidDesignerRuntimeException("Multiple primary keys for table");
        }
        return pk.iterator().next();
    }

    public String getName(Object metadataID) {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        MetadataRecord metadataRecord = (MetadataRecord)metadataID;
        return metadataRecord.getName();
    }

    public IFunctionLibrary getFunctionLibrary() {
        return UdfManager.getInstance().getFunctionLibrary();
    }

    protected DatatypeRecord getDatatypeRecord(Object elementID) throws Exception {
        if (elementID instanceof ColumnRecord) {
            String uuid = ((ColumnRecord)elementID).getDatatypeUUID();
            if (!CoreStringUtil.isEmpty((String)uuid)) {
                Collection results = this.findMetadataRecords('M', uuid, false);
                int resultSize = results.size();
                if (resultSize == 1) {
                    return (DatatypeRecord)results.iterator().next();
                }
                if (resultSize == 0) {
                    throw new Exception(String.valueOf(uuid) + NOT_EXISTS_MESSAGE);
                }
                throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.0", (Object)uuid));
            }
            return null;
        }
        if (elementID instanceof ProcedureParameterRecord) {
            String uuid = ((ProcedureParameterRecord)elementID).getDatatypeUUID();
            if (!CoreStringUtil.isEmpty((String)uuid)) {
                Collection results = this.findMetadataRecords('M', uuid, false);
                int resultSize = results.size();
                if (resultSize == 1) {
                    return (DatatypeRecord)results.iterator().next();
                }
                if (resultSize == 0) {
                    throw new Exception(String.valueOf(uuid) + NOT_EXISTS_MESSAGE);
                }
                throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.0", (Object)uuid));
            }
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    protected Index[] getIndexes(char recordType, IndexSelector selector) throws Exception {
        try {
            return selector.getIndexes();
        }
        catch (IOException e) {
            throw new TeiidDesignerException((Throwable)e, TransformationPlugin.Util.getString("TransformationMetadata.Error_trying_to_obtain_index_file_using_IndexSelector_1", (Object)selector));
        }
    }

    protected String getDatatypeUUIDMatchPattern(String uuid) {
        CoreArgCheck.isNotNull((Object)uuid);
        String uuidString = uuid;
        if (CoreStringUtil.startsWithIgnoreCase((String)uuid, (String)"mmuuid")) {
            uuidString = uuid.toLowerCase();
        }
        String patternStr = "M\u00a0*\u00a0*\u00a0*\u00a0" + uuidString + '\u00a0' + '*';
        return patternStr;
    }

    protected String getUUIDMatchPattern(char recordType, String uuid) {
        CoreArgCheck.isNotNull((Object)uuid);
        String uuidString = uuid;
        if (CoreStringUtil.startsWithIgnoreCase((String)uuid, (String)"mmuuid")) {
            uuidString = uuid.toLowerCase();
        }
        String patternStr = "" + recordType + '\u00a0' + '*' + '\u00a0' + uuidString + '\u00a0' + '*';
        return patternStr;
    }

    protected String getMatchPattern(char recordType, String name) {
        CoreArgCheck.isNotNull((Object)name);
        String patternStr = "" + recordType + '\u00a0' + '*';
        if (name != null) {
            patternStr = String.valueOf(patternStr) + name.trim().toUpperCase() + '\u00a0' + '*';
        }
        return patternStr;
    }

    protected String getPrefixPattern(char recordType, String name) {
        String patternStr = "" + recordType + '\u00a0';
        if (name != null) {
            patternStr = String.valueOf(patternStr) + name.trim().toUpperCase() + '\u00a0';
        }
        return patternStr;
    }

    protected String getUUIDPrefixPattern(char recordType, String uuid) {
        String patternStr = "" + recordType + '\u00a0';
        if (uuid != null) {
            patternStr = String.valueOf(patternStr) + uuid.trim() + '\u00a0';
        }
        return patternStr;
    }

    protected String getParentPrefixPattern(char recordType, String name) {
        String patternStr = "" + recordType + '\u00a0';
        if (name != null) {
            patternStr = String.valueOf(patternStr) + name.trim().toUpperCase() + '.';
        }
        return patternStr;
    }

    protected MetadataRecord getRecordByType(String entityName, char recordType) throws Exception {
        Collection results = this.findMetadataRecords(recordType, entityName, false);
        int resultSize = results.size();
        if (resultSize == 1) {
            return (MetadataRecord)results.iterator().next();
        }
        if (resultSize == 0) {
            throw new Exception(String.valueOf(entityName) + NOT_EXISTS_MESSAGE);
        }
        throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.0", (Object)entityName));
    }

    protected void filterMetadataRecordForUUID(String uuid, Collection records) {
        if (uuid != null && records != null) {
            Iterator iter = records.iterator();
            while (iter.hasNext()) {
                MetadataRecord record = (MetadataRecord)iter.next();
                if (record != null && uuid.equals(record.getUUID())) continue;
                iter.remove();
            }
        }
    }

    protected IndexSelector getIndexSelector() {
        return this.context.getIndexSelector();
    }

    protected QueryMetadataContext getContext() {
        return this.context;
    }

    protected Collection findChildRecords(MetadataRecord parentRecord, char childRecordType) throws Exception {
        IEntryResult[] results = this.queryIndexByParentPath(childRecordType, parentRecord.getFullName());
        Collection records = this.findMetadataRecords(results);
        if (childRecordType == 'I') {
            Collection primarKeyRecords = this.findMetadataRecords(this.queryIndexByParentPath('K', parentRecord.getFullName()));
            records.addAll(primarKeyRecords);
        }
        String groupUUID = parentRecord.getUUID();
        ArrayList<MetadataRecord> filteredRecords = new ArrayList<MetadataRecord>(records.size());
        for (MetadataRecord record : records) {
            String parentUUID = record.getParentUUID();
            if (parentUUID == null || !parentUUID.equalsIgnoreCase(groupUUID)) continue;
            filteredRecords.add(record);
        }
        return filteredRecords;
    }

    protected Collection findChildRecordsForColumns(MetadataRecord parentRecord, char childRecordType, List uuids) throws Exception {
        IEntryResult[] results = this.queryIndexByParentPath(childRecordType, parentRecord.getFullName());
        Collection records = this.findMetadataRecords(results);
        if (childRecordType == 'I') {
            Collection primarKeyRecords = this.findMetadataRecords(this.queryIndexByParentPath('K', parentRecord.getFullName()));
            records.addAll(primarKeyRecords);
        }
        ArrayList<MetadataRecord> columnRecords = new ArrayList<MetadataRecord>(uuids.size());
        for (MetadataRecord record : records) {
            if (record == null || !uuids.contains(record.getUUID())) continue;
            columnRecords.add(record);
        }
        return columnRecords;
    }

    protected Collection findChildRecordsWithoutFiltering(MetadataRecord parentRecord, char childRecordType) throws Exception {
        IEntryResult[] results = this.queryIndexByParentPath(childRecordType, parentRecord.getFullName());
        Collection records = this.findMetadataRecords(results);
        if (childRecordType == 'I') {
            Collection primarKeyRecords = this.findMetadataRecords(this.queryIndexByParentPath('K', parentRecord.getFullName()));
            records.addAll(primarKeyRecords);
        }
        return records;
    }

    protected Collection findMetadataRecords(IEntryResult[] results) {
        return RecordFactory.getMetadataRecord((IEntryResult[])results, null);
    }

    protected MetadataRecord findMetadataRecord(IEntryResult result) {
        return RecordFactory.getMetadataRecord((IEntryResult)result, null);
    }

    protected Collection findMetadataRecords(char recordType, String entityName, boolean isPartialName) throws Exception {
        IEntryResult[] results = this.queryIndex(recordType, entityName, isPartialName);
        Collection records = this.findMetadataRecords(results);
        if (CoreStringUtil.startsWithIgnoreCase((String)entityName, (String)"mmuuid")) {
            this.filterMetadataRecordForUUID(entityName, records);
        }
        return records;
    }

    protected IEntryResult[] queryIndex(char recordType, String entityName, boolean isPartialName) throws Exception {
        IEntryResult[] results = null;
        Index[] indexes = this.getIndexes(recordType, this.getIndexSelector());
        if (CoreStringUtil.startsWithIgnoreCase((String)entityName, (String)"mmuuid")) {
            String patternString = null;
            patternString = recordType == 'M' ? this.getDatatypeUUIDMatchPattern(entityName) : this.getUUIDMatchPattern(recordType, entityName);
            results = this.queryIndex(indexes, patternString.toCharArray(), false, true);
        } else if (isPartialName) {
            String patternString = this.getMatchPattern(recordType, entityName);
            results = this.queryIndex(indexes, patternString.toCharArray(), false, false);
        } else {
            String prefixString = this.getPrefixPattern(recordType, entityName);
            results = this.queryIndex(indexes, prefixString.toCharArray(), true, true);
        }
        return results;
    }

    protected IEntryResult[] queryIndex(Index[] indexes, char[] pattern, boolean isPrefix, boolean returnFirstMatch) throws Exception {
        return SimpleIndexUtil.queryIndex((Index[])indexes, (char[])pattern, (boolean)isPrefix, (boolean)returnFirstMatch);
    }

    protected IEntryResult[] queryIndex(Index[] indexes, char[] pattern, boolean isPrefix, boolean isCaseSensitive, boolean returnFirstMatch) throws Exception {
        return SimpleIndexUtil.queryIndex(null, (Index[])indexes, (char[])pattern, (boolean)isPrefix, (boolean)isCaseSensitive, (boolean)returnFirstMatch);
    }

    private String getProcedurePlan(String procedureName) throws Exception {
        CoreArgCheck.isNotEmpty((String)procedureName);
        Collection results = this.findMetadataRecords('T', procedureName, false);
        int resultSize = results.size();
        if (resultSize == 1) {
            TransformationRecord transformRecord = (TransformationRecord)results.iterator().next();
            return transformRecord.getTransformation();
        }
        if (resultSize > 1) {
            throw new Exception(String.valueOf(TransformationPlugin.Util.getString("TransformationMetadata.Procedure_ambiguous_there_are_multiple_procedure_plans_available_for_this_name___4")) + procedureName);
        }
        return null;
    }

    private ColumnRecord[] getColumnRecordsForUUIDs(List uuids) throws Exception {
        ColumnRecord[] columnRecords = new ColumnRecord[uuids.size()];
        int i = 0;
        while (i < uuids.size()) {
            String colUUID = (String)uuids.get(i);
            columnRecords[i] = (ColumnRecord)this.getElementID(colUUID);
            ++i;
        }
        return columnRecords;
    }

    private IEntryResult[] queryIndexByParentPath(char recordType, String parentFullName) throws Exception {
        String prefixString = this.getParentPrefixPattern(recordType, parentFullName);
        Index[] indexes = this.getIndexes(recordType, this.getIndexSelector());
        IEntryResult[] results = this.queryIndex(indexes, prefixString.toCharArray(), true, false);
        return results;
    }

    private IStoredProcedureInfo getStoredProcInfoDirect(String procedureName) throws Exception {
        String procedurePlan;
        CoreArgCheck.isNotEmpty((String)procedureName);
        ProcedureRecord procRecord = null;
        IDataTypeManagerService dataTypeService = ModelerCore.getTeiidDataTypeManagerService();
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        if (CoreStringUtil.startsWithIgnoreCase((String)procedureName, (String)"mmuuid") || CoreStringUtil.getTokens((String)procedureName, (String)DELIMITER_STRING).size() >= 2) {
            Collection results = this.findMetadataRecords('E', procedureName, false);
            int resultSize = results.size();
            if (resultSize == 1) {
                procRecord = (ProcedureRecord)results.iterator().next();
            } else if (resultSize == 0) {
                if (CoreStringUtil.startsWithIgnoreCase((String)procedureName, (String)"mmuuid")) {
                    return null;
                }
            } else {
                throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.0", (Object)procedureName));
            }
        }
        if (procRecord == null) {
            String partialName = String.valueOf('.') + procedureName;
            Collection results = this.findMetadataRecords('E', partialName, true);
            int resultSize = results.size();
            if (resultSize == 1) {
                procRecord = (ProcedureRecord)results.iterator().next();
            } else {
                if (resultSize == 0) {
                    throw new Exception(String.valueOf(procedureName) + NOT_EXISTS_MESSAGE);
                }
                throw new Exception(TransformationPlugin.Util.getString("TransformationMetadata.0", (Object)procedureName));
            }
        }
        String procedureFullName = procRecord.getFullName();
        IStoredProcedureInfo procInfo = factory.createStoredProcedureInfo();
        procInfo.setProcedureCallableName(procedureFullName);
        procInfo.setProcedureID((Object)procRecord);
        MetadataRecord modelRecord = (MetadataRecord)this.getModelID(procRecord);
        procInfo.setModelID((Object)modelRecord);
        for (String paramID : procRecord.getParameterIDs()) {
            ProcedureParameterRecord paramRecord = (ProcedureParameterRecord)this.getRecordByType(paramID, 'F');
            String runtimeType = paramRecord.getRuntimeType();
            ISPParameter.ParameterInfo direction = this.convertParamRecordTypeToStoredProcedureType(paramRecord.getType());
            ISPParameter spParam = factory.createSPParameter(paramRecord.getPosition(), direction, paramRecord.getFullName());
            spParam.setMetadataID((Object)paramRecord);
            spParam.setClassType(dataTypeService.getDataTypeClass(runtimeType));
            procInfo.addParameter(spParam);
        }
        String resultID = (String)procRecord.getResultSetID();
        if (resultID != null) {
            try {
                ColumnSetRecord resultRecord = (ColumnSetRecord)this.getRecordByType(resultID, 'C');
                int lastParamIndex = procInfo.getParameters().size() + 1;
                ISPParameter param = factory.createSPParameter(lastParamIndex, ISPParameter.ParameterInfo.RESULT_SET, resultRecord.getFullName());
                param.setClassType(ResultSet.class);
                param.setMetadataID((Object)resultRecord);
                ColumnRecord[] columnRecords = this.getColumnRecordsForUUIDs(resultRecord.getColumnIDs());
                int i = 0;
                while (i < columnRecords.length) {
                    String colType = columnRecords[i].getRuntimeType();
                    param.addResultSetColumn(columnRecords[i].getFullName(), dataTypeService.getDataTypeClass(colType), (Object)columnRecords[i]);
                    ++i;
                }
                procInfo.addParameter(param);
            }
            catch (Exception exception) {}
        }
        if (procRecord.isVirtual() && (procedurePlan = this.getProcedurePlan(procedureFullName)) != null) {
            IQueryNode queryNode = factory.createQueryNode(procedurePlan);
            procInfo.setQueryPlan(queryNode);
        }
        procInfo.setUpdateCount(procRecord.getUpdateCount() - 1);
        return procInfo;
    }

    public boolean isTemporaryTable(Object groupID) throws Exception {
        return false;
    }

    public Object addToMetadataCache(Object metadataID, String key, Object value) throws Exception {
        return null;
    }

    public Object getFromMetadataCache(Object metadataID, String key) throws Exception {
        return null;
    }

    public boolean isScalarGroup(Object groupID) throws Exception {
        return false;
    }

    public boolean isMultiSource(Object modelId) throws Exception {
        return false;
    }

    public boolean isMultiSourceElement(Object elementId) throws Exception {
        return false;
    }

    public IQueryMetadataInterface getDesignTimeMetadata() {
        return this;
    }

    public IQueryMetadataInterface getSessionMetadata() {
        return null;
    }

    public Set getImportedModels() {
        return Collections.emptySet();
    }

    public ScriptEngine getScriptEngine(String langauge) throws Exception {
        return null;
    }

    public boolean isVariadic(Object metadataID) {
        return false;
    }

    public Map getFunctionBasedExpressions(Object metadataID) {
        return null;
    }

    public boolean isPseudo(Object elementId) {
        return false;
    }

    public Object getModelID(String modelName) throws Exception {
        return null;
    }

    public String getExtensionProperty(Object metadataID, String key, boolean checkUnqualified) {
        return null;
    }

    public boolean findShortName() {
        return false;
    }

    public boolean useOutputName() {
        return false;
    }
}

