/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.validation.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.TargetLocationIndexSelector;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.mapping.factory.DefaultMappableTree;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;
import org.teiid.designer.metamodels.transformation.impl.MappingClassImpl;
import org.teiid.designer.metamodels.xml.ChoiceOption;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlChoice;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlDocumentEntity;
import org.teiid.designer.metamodels.xml.XmlDocumentNode;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlEntityHolder;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.metamodels.xml.XmlValueHolder;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.query.IQueryParser;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.IGroupsUsedByElementsVisitor;
import org.teiid.designer.query.sql.IResolverVisitor;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.metadata.QueryMetadataContext;
import org.teiid.designer.transformation.metadata.TransformationMetadataFactory;
import org.teiid.designer.validator.IValidator;
import org.teiid.designer.xml.PluginConstants;
import org.teiid.designer.xml.aspects.sql.XmlElementSqlAspect;

public class XmlDocumentValidationRule
implements ObjectValidationRule {
    private static String RULE_NAME = XmlDocumentValidationRule.class.getName();
    private Map elementColumnMap = null;
    private Map elementMappingClassMap = null;
    private ValidationContext context;

    public synchronized void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(TreeMappingRoot.class, (Object)eObject);
        TreeMappingRoot transRoot = (TreeMappingRoot)eObject;
        EObject target = transRoot.getTarget();
        if (target == null || !(target instanceof XmlDocument)) {
            return;
        }
        XmlDocument document = (XmlDocument)target;
        String uuid = ModelerCore.getObjectIdString((EObject)document);
        if (context.hasRunRule(uuid, RULE_NAME)) {
            return;
        }
        context.recordRuleRun(uuid, RULE_NAME);
        Resource documentResource = document.eResource();
        this.context = context;
        ModelContents mdlContents = new ModelContents(documentResource);
        Iterator contentIter = mdlContents.getTransformations((EObject)document).iterator();
        if (!contentIter.hasNext()) {
            return;
        }
        try {
            this.elementColumnMap = new HashMap();
            this.elementMappingClassMap = new HashMap();
            while (contentIter.hasNext()) {
                MappingRoot mappingRoot = (MappingRoot)contentIter.next();
                if (mappingRoot == null || !(mappingRoot instanceof TreeMappingRoot)) continue;
                EList inputClasses = mappingRoot.getInputs();
                EList outputRootElements = mappingRoot.getOutputs();
                if (!outputRootElements.isEmpty() && !inputClasses.isEmpty()) {
                    Object input = inputClasses.iterator().next();
                    Iterator outputIter = outputRootElements.iterator();
                    while (outputIter.hasNext()) {
                        this.elementMappingClassMap.put(outputIter.next(), input);
                    }
                }
                for (Mapping nestedMapping : mappingRoot.getNested()) {
                    EList inputColumns = nestedMapping.getInputs();
                    EList outputElements = nestedMapping.getOutputs();
                    if (outputElements.isEmpty() || inputColumns.isEmpty()) continue;
                    Object input = inputColumns.iterator().next();
                    Iterator outputIter = outputElements.iterator();
                    while (outputIter.hasNext()) {
                        this.elementColumnMap.put(outputIter.next(), input);
                    }
                }
            }
            ValidationResultImpl validationResult = new ValidationResultImpl((Object)transRoot, (Object)target);
            DocumentVisitor visitor = new DocumentVisitor();
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
            try {
                processor.walk((EObject)document, 2);
            }
            catch (ModelerCoreException e) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(TransformationPlugin.Util.getString("XmlDocumentValidationRule.Error_trying_to_collect_XmlElements_in_an_XmlDocument__1")) + e.getMessage());
                validationResult.addProblem((ValidationProblem)problem);
                this.elementColumnMap = null;
                this.context = null;
                this.elementMappingClassMap = null;
                return;
            }
            ArrayList entities = new ArrayList();
            entities.addAll(visitor.getElements());
            entities.addAll(visitor.getAttributes());
            this.validateEntities(entities, (ValidationResult)validationResult, context);
            this.validateMappingClassRecursionAllowed((ValidationResult)validationResult, context);
            if (!visitor.getChoices().isEmpty()) {
                TreeMappingAdapter mappingAdapter = new TreeMappingAdapter((EObject)document);
                DefaultMappableTree mappableTree = new DefaultMappableTree((EObject)document);
                this.validateChoiceEntities(visitor.getChoices(), mappingAdapter, (IMappableTree)mappableTree, (ValidationResult)validationResult, context);
            }
            if (!this.isLogicalModel(eObject)) {
                this.validateColumnToElementTypes((ValidationResult)validationResult, context);
            }
            context.addResult((ValidationResult)validationResult);
        }
        finally {
            this.elementColumnMap = null;
            this.context = null;
            this.elementMappingClassMap = null;
        }
    }

    private boolean isLogicalModel(EObject eObject) {
        EmfResource eResource;
        CoreArgCheck.isNotNull((Object)eObject);
        Resource r = eObject.eResource();
        return r instanceof EmfResource && (eResource = (EmfResource)r).getModelType() == ModelType.LOGICAL_LITERAL;
    }

    private void validateColumnToElementTypes(ValidationResult validationResult, ValidationContext context) {
        for (Map.Entry entry : this.elementColumnMap.entrySet()) {
            MappingClassColumn column;
            EObject columnType;
            if (!(entry.getKey() instanceof XmlDocumentNode)) continue;
            XmlDocumentNode element = (XmlDocumentNode)entry.getKey();
            XSDTypeDefinition xsdType = XmlDocumentUtil.findXSDType((Object)element);
            DatatypeManager dtm = ModelerCore.getDatatypeManager((EObject)xsdType, (boolean)true);
            if (xsdType == null || !(xsdType instanceof XSDSimpleTypeDefinition) || this.isStringType((EObject)xsdType, dtm) || (columnType = (column = (MappingClassColumn)entry.getValue()).getType()) == null || !(columnType instanceof XSDSimpleTypeDefinition) || this.isStringType(columnType, dtm) || columnType == xsdType || !this.isAtomicLiteral((XSDSimpleTypeDefinition)xsdType) || !this.isAtomicLiteral((XSDSimpleTypeDefinition)columnType)) continue;
            List xsdTypeList = this.createHierarcyList((EObject)xsdType, dtm);
            List columnTypeList = this.createHierarcyList(columnType, dtm);
            if (columnTypeList.size() > 0 && xsdTypeList.size() > 0) {
                boolean compatible = false;
                boolean nonAtomicAncestor = false;
                int i = 1;
                while (i < xsdTypeList.size()) {
                    XSDSimpleTypeDefinition std = (XSDSimpleTypeDefinition)xsdTypeList.get(i);
                    if (!this.isAtomicLiteral(std)) {
                        nonAtomicAncestor = true;
                        break;
                    }
                    int index = columnTypeList.indexOf(std);
                    if (index != -1) {
                        if (index != 0) {
                            String msg = TransformationPlugin.Util.getString("XmlDocumentValidationRule.Column_and_element_types_possibly_not_compatible", new Object[]{column.getName(), dtm.getName(columnType), element.getName(), dtm.getName((EObject)xsdType)});
                            ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg, XmlDocumentValidationRule.getLocationPath((EObject)column), XmlDocumentValidationRule.getURIString((EObject)column));
                            validationResult.addProblem((ValidationProblem)problem);
                        }
                        compatible = true;
                        break;
                    }
                    ++i;
                }
                if (compatible || nonAtomicAncestor) continue;
            }
            int status = context.getPreferenceStatus("xmlPreferences.incompatibleElementColumnDatatypes", 2);
            String msg = TransformationPlugin.Util.getString("XmlDocumentValidationRule.Column_and_element_types_not_compatible", new Object[]{column.getName(), dtm.getName(columnType), element.getName(), dtm.getName((EObject)xsdType)});
            ValidationProblemImpl problem = new ValidationProblemImpl(0, status, msg, XmlDocumentValidationRule.getLocationPath((EObject)column), XmlDocumentValidationRule.getURIString((EObject)column));
            validationResult.addProblem((ValidationProblem)problem);
        }
    }

    private boolean isStringType(EObject xsdType, DatatypeManager dtm) {
        EObject object = null;
        try {
            object = dtm.getDatatypeForXsdType(xsdType);
        }
        catch (ModelerCoreException err) {
            PluginConstants.Util.log((Throwable)err);
        }
        return object != null && dtm.isBuiltInDatatype(object) && "string".equals(dtm.getName(object));
    }

    private boolean isAtomicLiteral(XSDSimpleTypeDefinition type) {
        return type.getVariety() == XSDVariety.ATOMIC_LITERAL;
    }

    private List createHierarcyList(EObject type, DatatypeManager dtm) {
        EObject[] hierarchy = dtm.getTypeHierarchy(type);
        if (hierarchy.length < 2) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.addAll(Arrays.asList(hierarchy));
        result.remove(result.size() - 1);
        return result;
    }

    private boolean validateMappingClassRecursionAllowed(ValidationResult validationResult, ValidationContext context) {
        for (Map.Entry entry : this.elementMappingClassMap.entrySet()) {
            MappingClassImpl mc;
            EObject xmlNode = (EObject)entry.getKey();
            EObject mapping = (EObject)entry.getValue();
            if (!(mapping instanceof MappingClassImpl) || !(xmlNode instanceof XmlContainerNode) || !(mc = (MappingClassImpl)mapping).isRecursionAllowed() || !mc.isRecursive()) continue;
            String msg = TransformationPlugin.Util.getString("XmlDocumentValidationRule.Recursion_not_allowed_on_compositor");
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg, XmlDocumentValidationRule.getLocationPath(xmlNode), XmlDocumentValidationRule.getURIString(xmlNode));
            validationResult.addProblem((ValidationProblem)problem);
            return false;
        }
        return true;
    }

    private static String getURIString(EObject eoj) {
        return ModelerCore.getModelEditor().getUri(eoj).toString();
    }

    private static String getLocationPath(EObject eoj) {
        return ModelerCore.getModelEditor().getModelRelativePath(eoj).toString();
    }

    private boolean validateChoiceEntities(Collection choices, TreeMappingAdapter mappingAdapter, IMappableTree mappableTree, ValidationResult validationResult, ValidationContext context) {
        EmfResource emfResource;
        boolean isLogicalXMLModel = false;
        if (choices != null && choices.size() > 0 && (emfResource = (EmfResource)((EObject)choices.iterator().next()).eResource()).getModelAnnotation() != null) {
            ModelType type = emfResource.getModelAnnotation().getModelType();
            String stringURI = emfResource.getModelAnnotation().getPrimaryMetamodelUri();
            if (type.equals(ModelType.LOGICAL_LITERAL) && "http://www.metamatrix.com/metamodels/XmlDocument".equals(stringURI)) {
                isLogicalXMLModel = true;
            }
        }
        for (XmlChoice xmlChoice : choices) {
            ChoiceOption defaultOption = xmlChoice.getDefaultOption();
            DocumentVisitor visitor = new DocumentVisitor();
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
            try {
                processor.walk((EObject)xmlChoice, 1);
            }
            catch (ModelerCoreException e) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(TransformationPlugin.Util.getString("XmlDocumentValidationRule.Error_trying_to_collect_XmlElements_in_an_XmlDocument__2")) + e.getMessage(), XmlDocumentValidationRule.getLocationPath((EObject)xmlChoice), XmlDocumentValidationRule.getURIString((EObject)xmlChoice));
                validationResult.addProblem((ValidationProblem)problem);
                return false;
            }
            if (isLogicalXMLModel) continue;
            Collection choiceContents = visitor.getEntities();
            for (Object choiceEntity : choiceContents) {
                XmlDocumentNode documentNode;
                if (choiceEntity.equals(xmlChoice) || !(choiceEntity instanceof ChoiceOption)) continue;
                ChoiceOption option = (ChoiceOption)choiceEntity;
                if (choiceEntity instanceof XmlDocumentNode && (documentNode = (XmlDocumentNode)choiceEntity).isExcludeFromDocument()) continue;
                String choiceCriteria = option.getChoiceCriteria();
                if (CoreStringUtil.isEmpty((String)choiceCriteria)) {
                    if (ModelerCore.getModelEditor().equals((EObject)option, (EObject)defaultOption)) continue;
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_option_of_a_Choice_must_either_have_the_criteria_defined,_or_be_the_default._3"), XmlDocumentValidationRule.getLocationPath((EObject)option), XmlDocumentValidationRule.getURIString((EObject)option));
                    validationResult.addProblem((ValidationProblem)problem);
                    return false;
                }
                if (this.validateCriteria(option, xmlChoice, mappingAdapter, mappableTree, validationResult, context)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateEntities(Collection entities, ValidationResult validationResult, ValidationContext context) {
        EmfResource emfResource;
        boolean isLogicalXMLModel = false;
        if (entities != null && entities.size() > 0 && (emfResource = (EmfResource)((EObject)entities.iterator().next()).eResource()).getModelAnnotation() != null) {
            ModelType type = emfResource.getModelAnnotation().getModelType();
            String stringURI = emfResource.getModelAnnotation().getPrimaryMetamodelUri();
            if (type.equals(ModelType.LOGICAL_LITERAL) && "http://www.metamatrix.com/metamodels/XmlDocument".equals(stringURI)) {
                isLogicalXMLModel = true;
            }
        }
        for (Object entity : entities) {
            int status;
            int maxOccurs;
            XSDComponent xsdComponent;
            if (entity instanceof XmlDocument || !(entity instanceof XmlDocumentNode)) continue;
            XmlDocumentNode node = (XmlDocumentNode)entity;
            this.validateSchemaComponent(node, validationResult, context);
            if (!this.isElementOrAttribute(node)) continue;
            boolean isProcMapping = false;
            SqlAspect aspect = AspectManager.getSqlAspect((EObject)node);
            if (aspect != null && aspect instanceof XmlElementSqlAspect) {
                isProcMapping = ((XmlElementSqlAspect)aspect).isTranformationInputParameter((EObject)node);
            }
            int minOccurs = (xsdComponent = node.getXsdComponent()) != null ? XsdUtil.getMinOccurs((XSDComponent)xsdComponent) : -1;
            int n = maxOccurs = xsdComponent != null ? XsdUtil.getMaxOccurs((XSDComponent)xsdComponent) : -1;
            if (this.hasMappedMappingClassColumn(node)) {
                ValidationProblemImpl problem;
                int status2;
                XmlValueHolder valueHolder = (XmlValueHolder)node;
                if (valueHolder.isValueFixed() || valueHolder.isValueDefault()) {
                    status2 = context.getPreferenceStatus("xmlPreferences.fixedDefaultElementMapped", 2);
                    if (!isProcMapping && status2 != 0) {
                        problem = new ValidationProblemImpl(0, status2, TransformationPlugin.Util.getString("XmlDocumentValidationRule.This_entity_{0}_is_fixed_or_default_and_should_not_have_a_mapping_attribute_defined_in_MappingClasses_1", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                        problem.setHasPreference(this.context.hasPreferences());
                        validationResult.addProblem((ValidationProblem)problem);
                        if (status2 == 4) {
                            return false;
                        }
                    }
                }
                if (node.isExcludeFromDocument()) {
                    status2 = context.getPreferenceStatus("xmlPreferences.excludeElementMapped", 2);
                    if (!isProcMapping && status2 != 0) {
                        problem = new ValidationProblemImpl(0, status2, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_entity_{0}_has_been_selected_to_be_excluded_from_the_Document,_but_has_a_mapping_attribute_defined_in_MappingClasses_2", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                        problem.setHasPreference(this.context.hasPreferences());
                        validationResult.addProblem((ValidationProblem)problem);
                        if (status2 == 4) {
                            return false;
                        }
                    }
                }
                if (minOccurs == 0 && (status2 = context.getPreferenceStatus("xmlPreferences.mappedElementZeroMinOccurs", 2)) != 0) {
                    problem = new ValidationProblemImpl(0, status2, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_entity_{0}_has_a_min_occurs_of_zero,_but_has_a_mapping_attribute_defined_in_MappingClasses_3", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                    validationResult.addProblem((ValidationProblem)problem);
                    problem.setHasPreference(this.context.hasPreferences());
                    if (status2 == 4) {
                        return false;
                    }
                }
                if (!XsdUtil.isNillable((XSDComponent)xsdComponent)) continue;
                status2 = context.getPreferenceStatus("xmlPreferences.mappedElementNillable", 2);
                if (isProcMapping || status2 == 0) continue;
                problem = new ValidationProblemImpl(0, status2, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_entity_{0}__s_schema_component_reference_is_nullable,_but_has_a_mapping_attribute_defined_in_MappingClasses._5", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                validationResult.addProblem((ValidationProblem)problem);
                problem.setHasPreference(this.context.hasPreferences());
                if (status2 != 4) continue;
                return false;
            }
            if (!this.hasMappedMappingClass(node) || isLogicalXMLModel) continue;
            if (node instanceof XmlRoot) {
                int status3 = context.getPreferenceStatus("xmlPreferences.rootElementMappingClass", 2);
                if (status3 == 0) continue;
                ValidationProblemImpl problem = new ValidationProblemImpl(0, status3, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_element_{0}_is_root_but_is_mapped_to_a_MappingClass", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                problem.setHasPreference(this.context.hasPreferences());
                validationResult.addProblem((ValidationProblem)problem);
                if (status3 != 4) continue;
                return false;
            }
            if (maxOccurs != 1 || !(node instanceof XmlElement) || (status = context.getPreferenceStatus("xmlPreferences.mappedElementOneMaxOccurs", 2)) == 0) continue;
            ValidationProblemImpl problem = new ValidationProblemImpl(0, status, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_element_{0}_has_a_max_occurs_of_one,_but_is_mapped_to_a_MappingClass", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
            problem.setHasPreference(this.context.hasPreferences());
            validationResult.addProblem((ValidationProblem)problem);
            if (status != 4) continue;
            return false;
        }
        return true;
    }

    private boolean validateSchemaComponent(XmlDocumentNode node, ValidationResult validationResult, ValidationContext context) {
        XSDComponent xsdComponent = node.getXsdComponent();
        if (xsdComponent == null) {
            int status;
            if (this.isElementOrAttribute(node) && (status = context.getPreferenceStatus("xmlPreferences.elementSchemaRef", 2)) != 0) {
                EObject containerNode = node.eContainer();
                CoreArgCheck.isInstanceOf(XmlDocumentEntity.class, (Object)containerNode);
                XSDComponent containerComponent = this.getXsdComponent((XmlDocumentEntity)containerNode);
                if (containerComponent != null) {
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, status, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_document_element/attribute_{0}_doesn__t_reference_a_schema_component._10", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                    problem.setHasPreference(this.context.hasPreferences());
                    validationResult.addProblem((ValidationProblem)problem);
                    return false;
                }
            }
            return true;
        }
        if (xsdComponent.eIsProxy()) {
            try {
                Container container = ModelerCore.getModelContainer();
                EcoreUtil.resolve((EObject)xsdComponent, (ResourceSet)container);
            }
            catch (CoreException err) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, err.getMessage());
                validationResult.addProblem((ValidationProblem)problem);
                return false;
            }
        }
        int maxOccurs = XsdUtil.getMaxOccurs((XSDComponent)xsdComponent);
        EObject parent = node.eContainer();
        if (parent != null && maxOccurs > -1) {
            int status;
            int childCount = 0;
            for (Object child : parent.eContents()) {
                XSDComponent childComponent;
                XmlDocumentNode childNode;
                if (!(child instanceof XmlDocumentNode) || (childNode = (XmlDocumentNode)child).isExcludeFromDocument() || (childComponent = childNode.getXsdComponent()) == null || !ModelerCore.getModelEditor().equals((EObject)xsdComponent, (EObject)childComponent)) continue;
                ++childCount;
            }
            if (childCount > maxOccurs && (status = context.getPreferenceStatus("xmlPreferences.maxOccursViolation", 2)) != 0) {
                ValidationProblemImpl problem;
                if (maxOccurs == 0 && XsdUtil.isAttribute((XSDComponent)xsdComponent)) {
                    problem = new ValidationProblemImpl(0, status, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_attribute_{0}_references_a_prohibited_schema_attribute._7", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                    problem.setHasPreference(this.context.hasPreferences());
                    validationResult.addProblem((ValidationProblem)problem);
                } else {
                    problem = new ValidationProblemImpl(0, status, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_entity_{0},_may_be_violating_maxOccurs_specified_by_the_schema._1", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                    problem.setHasPreference(this.context.hasPreferences());
                    validationResult.addProblem((ValidationProblem)problem);
                }
            }
        }
        if (node.isExcludeFromDocument()) {
            EObject container = node.eContainer();
            CoreArgCheck.isInstanceOf(XmlDocumentEntity.class, (Object)container);
            XmlDocumentEntity containerNode = (XmlDocumentEntity)container;
            if (!this.isOptional((XmlDocumentEntity)node) && !this.isOptional(containerNode)) {
                boolean isProcMapping = false;
                SqlAspect aspect = AspectManager.getSqlAspect((EObject)node);
                if (aspect != null && aspect instanceof XmlElementSqlAspect) {
                    isProcMapping = ((XmlElementSqlAspect)aspect).isTranformationInputParameter((EObject)node);
                }
                int status = context.getPreferenceStatus("xmlPreferences.requiredElementExclude", 2);
                if (!isProcMapping && status != 0) {
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, status, TransformationPlugin.Util.getString("XmlDocumentValidationRule.The_entity_{0}_has_been_selected_to_be_excluded_from_the_Document,_but_the_neither_the_entity_nor_its_parent_are_optional._9", (Object)node.getName()), XmlDocumentValidationRule.getLocationPath((EObject)node), XmlDocumentValidationRule.getURIString((EObject)node));
                    problem.setHasPreference(this.context.hasPreferences());
                    validationResult.addProblem((ValidationProblem)problem);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateCriteria(ChoiceOption option, XmlChoice xmlChoice, TreeMappingAdapter mappingAdapter, IMappableTree mappableTree, ValidationResult validationResult, ValidationContext context) {
        String choiceCriteria = option.getChoiceCriteria();
        ICriteria criteria = null;
        Collection groups = null;
        try {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            IQueryParser parser = queryService.getQueryParser();
            criteria = parser.parseCriteria(choiceCriteria);
            IQueryMetadataInterface metadata = null;
            if (context != null && context.useServerIndexes()) {
                TargetLocationIndexSelector selector = new TargetLocationIndexSelector(context.getIndexLocation());
                QueryMetadataContext queryContext = new QueryMetadataContext((IndexSelector)selector);
                queryContext.setResources(Arrays.asList(context.getResourcesInScope()));
                queryContext.setRestrictedSearch(true);
                metadata = TransformationMetadataFactory.getInstance().getVdbMetadata(queryContext, context.getResourceContainer());
            } else {
                metadata = TransformationMetadataFactory.getInstance().getModelerMetadata((EObject)option, true);
            }
            groups = this.getGroups(criteria, metadata);
            IResolverVisitor resolverVisitor = queryService.getResolverVisitor();
            resolverVisitor.resolveLanguageObject((ILanguageObject)criteria, groups, metadata);
            IValidator validator = queryService.getValidator();
            IValidator.IValidatorReport report = validator.validate((ILanguageObject)criteria, metadata);
            if (report.hasItems()) {
                Collection problems = this.createValidationProblems(report);
                Iterator probIter = problems.iterator();
                while (probIter.hasNext()) {
                    validationResult.addProblem((ValidationProblem)probIter.next());
                }
                return false;
            }
        }
        catch (Throwable e) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(TransformationPlugin.Util.getString("XmlDocumentValidationRule.Error_trying_validate_choice_criteria__14")) + choiceCriteria + TransformationPlugin.Util.getString("XmlDocumentValidationRule.__15") + e.getMessage());
            validationResult.addProblem((ValidationProblem)problem);
            return false;
        }
        MappingClass mc = mappingAdapter.getMappingClass((EObject)xmlChoice);
        if (mc == null) {
            XmlEntityHolder parent = xmlChoice.getParent();
            while (parent != null && mc == null) {
                mc = mappingAdapter.getMappingClass((EObject)parent);
                parent = parent.eContainer();
            }
        }
        List validMappingClasses = XmlDocumentValidationRule.getParentMappingClasses(mc, mappingAdapter, mappableTree);
        if (mc != null) {
            validMappingClasses.add(mc);
        }
        for (IGroupSymbol grpSymbol : groups) {
            MetadataRecord record = (MetadataRecord)grpSymbol.getMetadataID();
            EObject grpObject = (EObject)context.getResourceContainer().getEObjectFinder().find((Object)record.getUUID());
            if (validMappingClasses.contains(grpObject)) continue;
            String choicePath = ModelerCore.getModelEditor().getModelRelativePath((EObject)option).toString();
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("XmlDocumentValidationRule.0", new Object[]{grpSymbol, choicePath}));
            validationResult.addProblem((ValidationProblem)problem);
            return false;
        }
        return true;
    }

    static List getParentMappingClasses(MappingClass mappingClass, TreeMappingAdapter mappingAdapter, IMappableTree mappableTree) {
        List parentMappingClasses;
        ArrayList result = new ArrayList();
        if (mappingAdapter != null && (parentMappingClasses = mappingAdapter.getParentMappingClasses(mappingClass, mappableTree, false)) != null && !parentMappingClasses.isEmpty()) {
            result.addAll(parentMappingClasses);
        }
        return result;
    }

    private Collection getGroups(ICriteria criteria, IQueryMetadataInterface metadata) throws Exception {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IGroupsUsedByElementsVisitor groupsUsedByElementsVisitor = queryService.getGroupsUsedByElementsVisitor();
        Set groups = groupsUsedByElementsVisitor.findGroups((ILanguageObject)criteria);
        for (IGroupSymbol groupSymbol : groups) {
            queryService.resolveGroup(groupSymbol, metadata);
        }
        return groups;
    }

    private boolean isElementOrAttribute(Object entity) {
        return entity instanceof XmlElement || entity instanceof XmlAttribute;
    }

    private boolean isOptional(XmlDocumentEntity node) {
        if (this.isElementOrAttribute(node)) {
            XSDComponent xsdComponent = this.getXsdComponent(node);
            CoreArgCheck.isNotNull((Object)xsdComponent);
            if (XsdUtil.getMinOccurs((XSDComponent)xsdComponent) == 0) {
                return true;
            }
            if (XsdUtil.isNillable((XSDComponent)xsdComponent)) {
                return true;
            }
        }
        return false;
    }

    private XSDComponent getXsdComponent(XmlDocumentEntity node) {
        XSDComponent xsdComponent = null;
        if (node instanceof XmlDocumentNode) {
            xsdComponent = ((XmlDocumentNode)node).getXsdComponent();
        } else if (node instanceof XmlContainerNode) {
            xsdComponent = ((XmlContainerNode)node).getXsdComponent();
        }
        return xsdComponent;
    }

    private boolean hasMappedMappingClassColumn(Object entity) {
        Object mappedObj = this.elementColumnMap.get(entity);
        return mappedObj != null;
    }

    private boolean hasMappedMappingClass(Object entity) {
        Object mappedObj = this.elementMappingClassMap.get(entity);
        return mappedObj != null;
    }

    private Collection createValidationProblems(IValidator.IValidatorReport report) {
        if (report != null && report.hasItems()) {
            Collection items = report.getItems();
            ArrayList<ValidationProblemImpl> problemList = new ArrayList<ValidationProblemImpl>(items.size());
            for (IValidator.IValidatorFailure item : items) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, item.toString());
                problemList.add(problem);
            }
            return problemList;
        }
        return Collections.EMPTY_LIST;
    }

    class DocumentVisitor
    implements ModelVisitor {
        Collection elements = new ArrayList();
        Collection attributes = new ArrayList();
        Collection choices = new ArrayList();
        Collection entities = new ArrayList();

        DocumentVisitor() {
        }

        public boolean visit(EObject eObject) {
            if (eObject instanceof XmlElement) {
                this.elements.add(eObject);
            }
            if (eObject instanceof XmlAttribute) {
                this.attributes.add(eObject);
            }
            if (eObject instanceof XmlChoice) {
                this.choices.add(eObject);
            }
            this.entities.add(eObject);
            return true;
        }

        public Collection getElements() {
            return this.elements;
        }

        public Collection getEntities() {
            return this.entities;
        }

        public Collection getChoices() {
            return this.choices;
        }

        public Collection getAttributes() {
            return this.attributes;
        }

        public boolean visit(Resource resource) {
            return true;
        }
    }
}

