/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.validation.rules;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.mapping.Mapping;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.transformation.TransformationMapping;
import org.teiid.designer.transformation.TransformationPlugin;

public class TransformationMappingValidationRule
implements ObjectValidationRule {
    private static char DELIMITER = (char)46;

    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(TransformationMapping.class, (Object)eObject);
        Mapping transMapping = (Mapping)eObject;
        String problemMessage = this.getProblem(transMapping);
        if (problemMessage != null) {
            ValidationResultImpl validationResult = new ValidationResultImpl((Object)eObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, problemMessage);
            validationResult.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)validationResult);
        }
    }

    private String getProblem(Mapping transMapping) {
        EList outputs = transMapping.getOutputs();
        EList inputs = transMapping.getInputs();
        String modelName = this.getModelName((EObject)transMapping);
        for (EObject inputElement : inputs) {
            if (!inputElement.eIsProxy()) continue;
            Object[] params = new Object[]{modelName, ((InternalEObject)inputElement).eProxyURI()};
            return TransformationPlugin.Util.getString("TransformationMappingValidationRule.Sql_transformation_in_the_model_contains_the_unresolved_reference_1", params);
        }
        String inputElements = this.getInputNames(inputs);
        if (outputs.size() < 1) {
            if (!inputElements.equals("")) {
                return String.valueOf(TransformationPlugin.Util.getString("TransformationMappingValidationRule.Sql_transformation_in_the_model__1")) + modelName + TransformationPlugin.Util.getString("TransformationMappingValidationRule._does_not_have_targets_mapped_for_source_element/s__2") + inputElements;
            }
            return String.valueOf(TransformationPlugin.Util.getString("TransformationMappingValidationRule.Sql_transformation_in_the_model__3")) + modelName + TransformationPlugin.Util.getString("TransformationMappingValidationRule._does_not_have_target_elements._4");
        }
        if (outputs.size() > 1) {
            if (!inputElements.equals("")) {
                return String.valueOf(TransformationPlugin.Util.getString("TransformationMappingValidationRule.Sql_transformation_in_the_model__5")) + modelName + TransformationPlugin.Util.getString("TransformationMappingValidationRule._cannot_have_multiple_targets_mapped_for_source_element/s__6") + inputElements;
            }
            return String.valueOf(TransformationPlugin.Util.getString("TransformationMappingValidationRule.Sql_transformation_in_the_model__7")) + modelName + TransformationPlugin.Util.getString("TransformationMappingValidationRule._cannot_have_multiple_target_elements._8");
        }
        return null;
    }

    private String getModelName(EObject eObj) {
        ModelEditor modelEditor = ModelerCore.getModelEditor();
        return modelEditor.getModelName(eObj).toString();
    }

    private String getName(EObject eObj) {
        ModelEditor modelEditor = ModelerCore.getModelEditor();
        String objectPath = modelEditor.getModelRelativePathIncludingModel(eObj).toString();
        return objectPath.replace('/', DELIMITER);
    }

    private String getInputNames(EList inputs) {
        Iterator inputIter = inputs.iterator();
        StringBuffer buf = new StringBuffer();
        while (inputIter.hasNext()) {
            EObject inputElement = (EObject)inputIter.next();
            String elementName = this.getName(inputElement);
            buf.append(elementName);
            if (!inputIter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

