/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IndexingContext;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTransformationInfo;
import org.teiid.designer.metamodels.transformation.InputBinding;
import org.teiid.designer.metamodels.transformation.InputParameter;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryParser;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.aspects.sql.TransformationMappingRootSqlAspect;
import org.teiid.designer.transformation.util.SqlConverter;

public class SqlTransformationMappingRootSqlAspect
extends TransformationMappingRootSqlAspect {
    protected SqlTransformationMappingRootSqlAspect(MetamodelEntity entity) {
        super(entity);
    }

    public Object getTransformedObject(EObject eObject) {
        CoreArgCheck.isInstanceOf(TransformationMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        EObject targetEObj = root.getTarget();
        if (targetEObj == null) {
            TransformationPlugin.Util.log(2, TransformationPlugin.Util.getString("SqlTransformationMappingRootSqlAspect.0", (Object)ModelerCore.getObjectIdString((EObject)root)));
        }
        return targetEObj;
    }

    public List getInputObjects(EObject eObject) {
        CoreArgCheck.isInstanceOf(TransformationMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        return root.getInputs();
    }

    public List getNestedInputObjects(EObject eObject) {
        CoreArgCheck.isInstanceOf(TransformationMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        if (root.getNested() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        for (Mapping mapping : root.getNested()) {
            if (mapping == null) continue;
            result.addAll(mapping.getInputs());
        }
        return result;
    }

    public List getNestedOutputObjects(EObject eObject) {
        CoreArgCheck.isInstanceOf(TransformationMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        if (root.getNested() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        for (Mapping mapping : root.getNested()) {
            if (mapping == null) continue;
            result.addAll(mapping.getInputs());
        }
        return result;
    }

    public List getNestedInputsForOutput(EObject eObject, EObject output) {
        CoreArgCheck.isInstanceOf(TransformationMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        if (root.getNested() != null) {
            for (Mapping mapping : root.getNested()) {
                if (mapping == null || !mapping.getOutputs().contains((Object)output)) continue;
                return mapping.getInputs();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List getNestedOutputsForInput(EObject eObject, EObject input) {
        CoreArgCheck.isInstanceOf(TransformationMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        if (root.getNested() != null) {
            for (Mapping mapping : root.getNested()) {
                if (mapping == null || !mapping.getInputs().contains((Object)input)) continue;
                return mapping.getOutputs();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List getOutputObjects(EObject eObject) {
        CoreArgCheck.isInstanceOf(TransformationMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        return root.getOutputs();
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'P' || recordType == 'Q' || recordType == 'R' || recordType == 'S' || recordType == 'T';
    }

    public boolean isQueryable(EObject eObject) {
        return true;
    }

    public String getName(EObject eObject) {
        EObject transformedObject = (EObject)this.getTransformedObject(eObject);
        if (transformedObject == null) {
            return null;
        }
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)transformedObject);
        if (sqlAspect != null) {
            return sqlAspect.getName(transformedObject);
        }
        return null;
    }

    @Override
    public String getFullName(EObject eObject) {
        EObject transformedObject = (EObject)this.getTransformedObject(eObject);
        if (transformedObject == null) {
            return null;
        }
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)transformedObject);
        if (sqlAspect != null) {
            return sqlAspect.getFullName(transformedObject);
        }
        return null;
    }

    public String getNameInSource(EObject eObject) {
        EObject transformedObject = (EObject)this.getTransformedObject(eObject);
        if (transformedObject == null) {
            return null;
        }
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)transformedObject);
        if (sqlAspect != null) {
            return sqlAspect.getNameInSource(transformedObject);
        }
        return null;
    }

    public String[] getTransformationTypes(EObject eObject) {
        CoreArgCheck.isInstanceOf(SqlTransformationMappingRoot.class, (Object)eObject);
        SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)eObject;
        SqlTransformation transformation = (SqlTransformation)root.getHelper();
        if (transformation != null) {
            String selectSql = SqlTransformationMappingRootSqlAspect.getSelectSqlUserString(root);
            String insertSql = SqlTransformationMappingRootSqlAspect.getInsertSqlUserString(root);
            String updateSql = SqlTransformationMappingRootSqlAspect.getUpdateSqlUserString(root);
            String deleteSql = SqlTransformationMappingRootSqlAspect.getDeleteSqlUserString(root);
            ArrayList<String> result = new ArrayList<String>(4);
            if (!CoreStringUtil.isEmpty((String)selectSql)) {
                EObject transformedObject = (EObject)this.getTransformedObject(eObject);
                if (transformedObject == null) {
                    return null;
                }
                SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)transformedObject);
                if (sqlAspect == null || sqlAspect instanceof SqlTableAspect) {
                    result.add("Select");
                } else if (sqlAspect instanceof SqlProcedureAspect) {
                    result.add("Procedure");
                }
            }
            if (!CoreStringUtil.isEmpty((String)insertSql) && !transformation.isInsertSqlDefault()) {
                result.add("Insert");
            }
            if (!CoreStringUtil.isEmpty((String)updateSql) && !transformation.isUpdateSqlDefault()) {
                result.add("Update");
            }
            if (!CoreStringUtil.isEmpty((String)deleteSql) && !transformation.isDeleteSqlDefault()) {
                result.add("Delete");
            }
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    public String getTransformation(EObject eObject, String type) {
        CoreArgCheck.isInstanceOf(SqlTransformationMappingRoot.class, (Object)eObject);
        SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)eObject;
        SqlTransformation transformation = (SqlTransformation)root.getHelper();
        if (transformation != null) {
            if ("Select".equals(type) || "Procedure".equals(type)) {
                return SqlConverter.convertToString(transformation.getSelectSql(), (EObject)root, 0, true);
            }
            if ("Insert".equals(type)) {
                return SqlConverter.convertToString(transformation.getInsertSql(), (EObject)root, 1, true);
            }
            if ("Update".equals(type)) {
                return SqlConverter.convertToString(transformation.getUpdateSql(), (EObject)root, 2, true);
            }
            if ("Delete".equals(type)) {
                return SqlConverter.convertToString(transformation.getDeleteSql(), (EObject)root, 3, true);
            }
        }
        return null;
    }

    public boolean isDeleteAllowed(EObject eObject) {
        CoreArgCheck.isInstanceOf(SqlTransformationMappingRoot.class, (Object)eObject);
        SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)eObject;
        SqlTransformation sqlTransformation = (SqlTransformation)root.getHelper();
        return sqlTransformation.isDeleteAllowed();
    }

    public boolean isInsertAllowed(EObject eObject) {
        CoreArgCheck.isInstanceOf(SqlTransformationMappingRoot.class, (Object)eObject);
        SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)eObject;
        SqlTransformation sqlTransformation = (SqlTransformation)root.getHelper();
        return sqlTransformation.isInsertAllowed();
    }

    public boolean isUpdateAllowed(EObject eObject) {
        CoreArgCheck.isInstanceOf(SqlTransformationMappingRoot.class, (Object)eObject);
        SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)eObject;
        SqlTransformation sqlTransformation = (SqlTransformation)root.getHelper();
        return sqlTransformation.isUpdateAllowed();
    }

    public SqlTransformationInfo getTransformationInfo(EObject eObject, IndexingContext context, String type) {
        CoreArgCheck.isInstanceOf(SqlTransformationMappingRoot.class, (Object)eObject);
        SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)eObject;
        SqlTransformation uuidTransformation = (SqlTransformation)root.getHelper();
        if (uuidTransformation != null) {
            String deleteSql;
            String updateSql;
            String insertSql;
            if ("Select".equals(type) || "Procedure".equals(type)) {
                String selectSql = SqlTransformationMappingRootSqlAspect.getSelectSqlUserString(root);
                Object target = this.getTransformedObject(eObject);
                ArrayList<String> bindingNames = null;
                if (target instanceof MappingClass) {
                    ICommand command = SqlTransformationMappingRootSqlAspect.parseSQL(selectSql);
                    InputSet inputSet = ((MappingClass)target).getInputSet();
                    if (inputSet != null) {
                        bindingNames = new ArrayList<String>(inputSet.getInputParameters().size());
                        try {
                            for (InputParameter param : inputSet.getInputParameters()) {
                                MappingClass mappingClass = (MappingClass)target;
                                for (InputBinding binding : mappingClass.getMappingClassSet().getInputBinding()) {
                                    String inputName;
                                    MappingClass paramMappingClass;
                                    InputParameter inputParam = binding.getInputParameter();
                                    if (inputParam == null || !(paramMappingClass = inputParam.getInputSet().getMappingClass()).equals(target) || (inputName = inputParam.getName()) == null || !inputName.equalsIgnoreCase(param.getName())) continue;
                                    MappingClassColumn mappingColumn = binding.getMappingClassColumn();
                                    SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)mappingColumn);
                                    String mappingColumnName = sqlAspect.getFullName((EObject)mappingColumn);
                                    IQueryService queryService = ModelerCore.getTeiidQueryService();
                                    IQueryFactory factory = queryService.createQueryFactory();
                                    bindingNames.add(factory.createAliasSymbol(inputName, (IExpression)factory.createElementSymbol(mappingColumnName)).toString());
                                }
                            }
                        }
                        catch (Throwable e) {
                            TransformationPlugin.Util.log(4, e, e.getLocalizedMessage());
                        }
                    }
                    String tranformedSql = null;
                    if (command != null) {
                        tranformedSql = command.toString();
                    }
                    return new SqlTransformationInfo(tranformedSql, bindingNames);
                }
                return new SqlTransformationInfo(selectSql);
            }
            if ("Insert".equals(type) && uuidTransformation.isInsertAllowed() && !CoreStringUtil.isEmpty((String)(insertSql = SqlTransformationMappingRootSqlAspect.getInsertSqlUserString(root)))) {
                return new SqlTransformationInfo(insertSql);
            }
            if ("Update".equals(type) && uuidTransformation.isUpdateAllowed() && !CoreStringUtil.isEmpty((String)(updateSql = SqlTransformationMappingRootSqlAspect.getUpdateSqlUserString(root)))) {
                return new SqlTransformationInfo(updateSql);
            }
            if ("Delete".equals(type) && uuidTransformation.isDeleteAllowed() && !CoreStringUtil.isEmpty((String)(deleteSql = SqlTransformationMappingRootSqlAspect.getDeleteSqlUserString(root)))) {
                return new SqlTransformationInfo(deleteSql);
            }
        }
        return null;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    public static SqlTransformation getUserSqlTransformation(SqlTransformationMappingRoot root) {
        MappingHelper helper;
        SqlTransformation nestedSqlTrans = null;
        if (root != null && (helper = root.getHelper()) != null) {
            for (Object obj : helper.getNested()) {
                if (obj == null || !(obj instanceof SqlTransformation)) continue;
                nestedSqlTrans = (SqlTransformation)obj;
                break;
            }
        }
        return nestedSqlTrans;
    }

    public static ICommand parseSQL(String sqlString) {
        ICommand command = null;
        try {
            IQueryParser parser = ModelerCore.getTeiidQueryService().getQueryParser();
            command = parser.parseDesignerCommand(sqlString);
        }
        catch (Exception e) {
            TransformationPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
        }
        return command;
    }

    private static String getSelectSqlUserString(SqlTransformationMappingRoot root) {
        SqlTransformation userSqlTransformation = SqlTransformationMappingRootSqlAspect.getUserSqlTransformation(root);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getSelectSql();
        }
        return result;
    }

    private static String getInsertSqlUserString(SqlTransformationMappingRoot root) {
        SqlTransformation userSqlTransformation = SqlTransformationMappingRootSqlAspect.getUserSqlTransformation(root);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getInsertSql();
        }
        return result;
    }

    private static String getUpdateSqlUserString(SqlTransformationMappingRoot root) {
        SqlTransformation userSqlTransformation = SqlTransformationMappingRootSqlAspect.getUserSqlTransformation(root);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getUpdateSql();
        }
        return result;
    }

    private static String getDeleteSqlUserString(SqlTransformationMappingRoot root) {
        SqlTransformation userSqlTransformation = SqlTransformationMappingRootSqlAspect.getUserSqlTransformation(root);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getDeleteSql();
        }
        return result;
    }
}

