/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.wizards;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.xml.BuildStatus;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlBuildable;
import org.teiid.designer.metamodels.xml.XmlDocumentEntity;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlFragment;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.MessageLabel;
import org.teiid.designer.xml.IVirtualDocumentFragmentSource;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;
import org.teiid.designer.xml.ui.wizards.NewDocumentWizardModel;

public class VirtualDocumentStatisticsWizardPage
extends WizardPage
implements ModelerXmlUiConstants,
IVirtualDocumentFragmentSource {
    private static final int MAX_NODES = 4000;
    private static final String TITLE = Util.getString("VirtualDocumentStatisticsWizardPage.title", new Object[0]);
    private static final String DESCRIPTION = Util.getString("VirtualDocumentStatisticsWizardPage.description", new Object[0]);
    static final String WAITING_TEXT = Util.getString("VirtualDocumentStatisticsWizardPage.waitingText", new Object[0]);
    private static final String LABEL_DOCUMENTS = Util.getString("VirtualDocumentStatisticsWizardPage.labelDocuments", new Object[0]);
    private static final String LABEL_TOTAL = Util.getString("VirtualDocumentStatisticsWizardPage.labelTotal", new Object[0]);
    private static final String LABEL_ATTRIBUTES = Util.getString("VirtualDocumentStatisticsWizardPage.labelAttributes", new Object[0]);
    private static final String LABEL_SUBTYPE = Util.getString("VirtualDocumentStatisticsWizardPage.labelSubtypes", new Object[0]);
    private static final String LABEL_RECURSIVE = Util.getString("VirtualDocumentStatisticsWizardPage.labelRecursives", new Object[0]);
    private static final String LABEL_ELEMENTS = Util.getString("VirtualDocumentStatisticsWizardPage.labelElements", new Object[0]);
    private static final String SUBTASK_ANALYZING = Util.getString("VirtualDocumentStatisticsWizardPage.subtaskAnalyzing", new Object[0]);
    private static final String SUBTASK_BUILDING = Util.getString("VirtualDocumentStatisticsWizardPage.subtaskBuilding", new Object[0]);
    private static final String TEXT_ERROR = Util.getString("VirtualDocumentStatisticsWizardPage.issueError", new Object[0]);
    private static final String TEXT_WARNING = Util.getString("VirtualDocumentStatisticsWizardPage.issueWarning", new Object[0]);
    static final IStatus ERROR_STATUS = new Status(4, "org.teiid.designer.xml.ui", 0, TEXT_ERROR, null);
    static final IStatus WARNING_STATUS = new Status(2, "org.teiid.designer.xml.ui", 0, TEXT_WARNING, null);
    static final IStatus OK_STATUS = new Status(0, "org.teiid.designer.xml.ui", 0, "", null);
    StatsClass sts;
    private XmlFragment[] fragments;
    private final NewDocumentWizardModel model;
    Text docCount;
    Text attribCount;
    Text elementCount;
    Text subtypeCount;
    Text recursiveCount;
    Text ttlCount;
    MessageLabel message;
    private boolean tooManyTreeNodes = false;

    public VirtualDocumentStatisticsWizardPage(NewDocumentWizardModel wizardModel) {
        super("virtualDocumentStatisticsWizardPage");
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setPageComplete(true);
        this.model = wizardModel;
    }

    public void createControl(Composite parent) {
        this.model.setWizHolder(parent);
        Composite panel = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        panel.setLayout((Layout)gl);
        Label l = new Label(panel, 0);
        l.setText(LABEL_DOCUMENTS);
        GridData gd = new GridData(128);
        l.setLayoutData((Object)gd);
        this.docCount = WidgetFactory.createTextField((Composite)panel, (int)768, (String)WAITING_TEXT);
        this.docCount.setEditable(false);
        l = new Label(panel, 0);
        l.setText(LABEL_ELEMENTS);
        gd = new GridData(128);
        l.setLayoutData((Object)gd);
        this.elementCount = WidgetFactory.createTextField((Composite)panel, (int)768, (String)WAITING_TEXT);
        this.elementCount.setEditable(false);
        l = new Label(panel, 0);
        l.setText(LABEL_RECURSIVE);
        gd = new GridData(128);
        l.setLayoutData((Object)gd);
        this.recursiveCount = WidgetFactory.createTextField((Composite)panel, (int)768, (String)WAITING_TEXT);
        this.recursiveCount.setEditable(false);
        l = new Label(panel, 0);
        l.setText(LABEL_SUBTYPE);
        gd = new GridData(128);
        l.setLayoutData((Object)gd);
        this.subtypeCount = WidgetFactory.createTextField((Composite)panel, (int)768, (String)WAITING_TEXT);
        this.subtypeCount.setEditable(false);
        l = new Label(panel, 0);
        l.setText(LABEL_ATTRIBUTES);
        gd = new GridData(128);
        l.setLayoutData((Object)gd);
        this.attribCount = WidgetFactory.createTextField((Composite)panel, (int)768, (String)WAITING_TEXT);
        this.attribCount.setEditable(false);
        l = new Label(panel, 0);
        l.setText(LABEL_TOTAL);
        gd = new GridData(128);
        l.setLayoutData((Object)gd);
        this.ttlCount = WidgetFactory.createTextField((Composite)panel, (int)768, (String)WAITING_TEXT);
        this.ttlCount.setEditable(false);
        this.message = new MessageLabel(panel);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.message.setLayoutData((Object)gd);
        this.setControl((Control)panel);
    }

    public void dispose() {
        super.dispose();
        Control c = this.getControl();
        if (c != null) {
            c.dispose();
        }
    }

    public XmlFragment[] getFragments(ModelResource modelResource, IProgressMonitor monitor) {
        return this.model.getFragments(modelResource, monitor);
    }

    public void updateSourceFragments(boolean isVisible, IProgressMonitor monitor) {
        monitor.subTask(SUBTASK_BUILDING);
        XmlFragment[] frags = this.model.getFragments(null, monitor);
        if (this.getControl() != null && frags != this.fragments) {
            this.fragments = frags;
            monitor.subTask(SUBTASK_ANALYZING);
            this.analyzeFragments(this.fragments, monitor);
        }
    }

    private void analyzeFragments(XmlFragment[] fragments, IProgressMonitor monitor) {
        this.sts = new StatsClass();
        this.updateDisplay(false, -1);
        int i = 0;
        while (i < fragments.length) {
            if (monitor.isCanceled()) break;
            this.gatherNodeInfo((XmlDocumentEntity)fragments[i], this.sts, monitor);
            monitor.worked(1);
            ++i;
        }
        this.tooManyTreeNodes = false;
        if (this.sts.total > 4000) {
            this.tooManyTreeNodes = true;
        }
        this.updateDisplay(false, fragments.length);
    }

    private void updateDisplay(boolean async, final int fragmentCount) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (fragmentCount != -1) {
                    VirtualDocumentStatisticsWizardPage.this.docCount.setText(Integer.toString(fragmentCount));
                    VirtualDocumentStatisticsWizardPage.this.elementCount.setText(Integer.toString(VirtualDocumentStatisticsWizardPage.this.sts.elements));
                    VirtualDocumentStatisticsWizardPage.this.recursiveCount.setText(Integer.toString(VirtualDocumentStatisticsWizardPage.this.sts.recursives));
                    VirtualDocumentStatisticsWizardPage.this.subtypeCount.setText(Integer.toString(VirtualDocumentStatisticsWizardPage.this.sts.subtypes));
                    VirtualDocumentStatisticsWizardPage.this.attribCount.setText(Integer.toString(VirtualDocumentStatisticsWizardPage.this.sts.attribs));
                    VirtualDocumentStatisticsWizardPage.this.ttlCount.setText(Integer.toString(VirtualDocumentStatisticsWizardPage.this.sts.total));
                    VirtualDocumentStatisticsWizardPage.this.setPageComplete(true);
                    if (VirtualDocumentStatisticsWizardPage.this.sts.total > 4000) {
                        VirtualDocumentStatisticsWizardPage.this.message.setErrorStatus(ERROR_STATUS);
                    } else if (VirtualDocumentStatisticsWizardPage.this.sts.total > 1000) {
                        VirtualDocumentStatisticsWizardPage.this.message.setErrorStatus(WARNING_STATUS);
                    } else {
                        VirtualDocumentStatisticsWizardPage.this.message.setErrorStatus(OK_STATUS);
                    }
                } else {
                    VirtualDocumentStatisticsWizardPage.this.docCount.setText(WAITING_TEXT);
                    VirtualDocumentStatisticsWizardPage.this.elementCount.setText(WAITING_TEXT);
                    VirtualDocumentStatisticsWizardPage.this.recursiveCount.setText(WAITING_TEXT);
                    VirtualDocumentStatisticsWizardPage.this.subtypeCount.setText(WAITING_TEXT);
                    VirtualDocumentStatisticsWizardPage.this.attribCount.setText(WAITING_TEXT);
                    VirtualDocumentStatisticsWizardPage.this.ttlCount.setText(WAITING_TEXT);
                    VirtualDocumentStatisticsWizardPage.this.message.setErrorStatus(OK_STATUS);
                    VirtualDocumentStatisticsWizardPage.this.setPageComplete(true);
                }
            }
        };
        if (async) {
            Display.getDefault().asyncExec(r);
        } else {
            Display.getDefault().syncExec(r);
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null && !this.tooManyTreeNodes;
    }

    private void gatherNodeInfo(XmlDocumentEntity node, StatsClass sts, IProgressMonitor monitor) {
        EList kids = node.eContents();
        int i = 0;
        while (i < kids.size()) {
            if (monitor.isCanceled()) {
                return;
            }
            XmlDocumentEntity kid = (XmlDocumentEntity)kids.get(i);
            this.gatherNodeInfo(kid, sts, monitor);
            ++i;
        }
        if (monitor.isCanceled()) {
            return;
        }
        ++sts.total;
        if (node instanceof XmlElement) {
            ++sts.elements;
        } else if (node instanceof XmlAttribute) {
            ++sts.attribs;
        } else {
            ++sts.other;
        }
        if (XmlDocumentUtil.isRecursive((Object)node)) {
            ++sts.recursives;
        } else if (node instanceof XmlBuildable && ((XmlBuildable)node).getBuildState() == BuildStatus.INCOMPLETE_LITERAL) {
            ++sts.subtypes;
        }
    }

    static class StatsClass {
        int other;
        int attribs;
        int elements;
        int subtypes;
        int recursives;
        int total;

        StatsClass() {
        }

        public String toString() {
            return " StatsClass:\n  attributes:\t" + this.attribs + "\n  elements:\t" + this.elements + "\n  subtypes\t" + this.subtypes + "\n  recursives:\t" + this.recursives + "\n  other:\t" + this.other + "\n  total:\t" + this.total;
        }
    }
}

