/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.wizards;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.xml.XmlFragment;
import org.teiid.designer.xml.IVirtualDocumentFragmentSource;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;
import org.teiid.designer.xml.ui.editor.EditVirtualDocumentsPanel;
import org.teiid.designer.xml.ui.wizards.NewDocumentWizardModel;

public class PreviewVirtualDocumentWizardPage
extends WizardPage
implements ModelerXmlUiConstants,
IVirtualDocumentFragmentSource {
    private EditVirtualDocumentsPanel panel;
    private final NewDocumentWizardModel model;

    public PreviewVirtualDocumentWizardPage(NewDocumentWizardModel wizModel) {
        super("previewVirtualDocumentPage");
        this.model = wizModel;
        this.setTitle(Util.getString("PreviewVirtualDocumentPage.title", new Object[0]));
        this.setDescription(Util.getString("PreviewVirtualDocumentPage.description", new Object[0]));
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.panel = new EditVirtualDocumentsPanel(parent);
        this.setControl((Control)this.panel);
    }

    public void dispose() {
        super.dispose();
        Control c = this.getControl();
        if (c != null) {
            c.dispose();
        }
    }

    public Collection getRoots(ModelResource modelResource, IProgressMonitor monitor) {
        if (this.panel == null) {
            XmlFragment[] fragments = this.model.getFragments(modelResource, monitor);
            return Arrays.asList(fragments);
        }
        if (this.panel.getRoots(monitor).isEmpty()) {
            XmlFragment[] fragments = this.model.getFragments(modelResource, monitor);
            this.panel.setFragments(fragments);
        }
        return this.panel.getRoots(monitor);
    }

    public XmlFragment[] getFragments(ModelResource modelResource, IProgressMonitor monitor) {
        if (this.panel == null) {
            this.createControl(this.model.getWizHolder());
            this.panel.setVisible(false);
        }
        return this.panel.getFragments(null, monitor);
    }

    public void updateSourceFragments(boolean isVisible, IProgressMonitor monitor) {
        monitor.subTask(Util.getString("PreviewVirtualDocumentPage.subtaskBuilding", new Object[0]));
        XmlFragment[] fragments = this.model.getFragments(null, monitor);
        if (this.panel != null && fragments != this.panel.getStartingFragments()) {
            monitor.subTask(Util.getString("PreviewVirtualDocumentPage.subtaskTree", new Object[0]));
            this.panel.setStartingFragments(fragments, isVisible, monitor);
        }
    }
}

