/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;

public class ConfirmSaveXsdModelDialog
extends MessageDialog
implements ModelerXmlUiConstants {
    private IProgressMonitor monitor;
    private boolean schemaSaved;
    private ModelResource schemaModel;

    public ConfirmSaveXsdModelDialog(Shell theShell, ModelResource theSchemaModel) {
        super(theShell, Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(ConfirmSaveXsdModelDialog.class)) + "title", new Object[0]), null, Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(ConfirmSaveXsdModelDialog.class)) + "msg", new Object[0]), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.schemaModel = theSchemaModel;
    }

    public ConfirmSaveXsdModelDialog(Shell theShell, ModelResource theSchemaModel, IProgressMonitor theMonitor) {
        this(theShell, theSchemaModel);
        this.monitor = theMonitor;
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            try {
                if (this.schemaModel.getEmfResource().isModified()) {
                    IFile file = (IFile)this.schemaModel.getUnderlyingResource();
                    IEditorReference editorRef = ModelEditorManager.getEditorReferenceForFile((IFile)file);
                    if (editorRef != null) {
                        editorRef.getEditor(false).doSave(this.monitor);
                    } else {
                        this.schemaModel.save(this.monitor, false);
                    }
                }
                this.schemaSaved = true;
            }
            catch (ModelWorkspaceException theException) {
                this.schemaSaved = false;
                Util.log((Throwable)theException);
            }
        } else {
            this.schemaSaved = false;
        }
        return super.close();
    }

    public boolean isSchemaSaved() {
        return this.schemaSaved;
    }
}

