/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;

public class PrintDiagramHelper
implements DiagramUiConstants {
    private static final long MAX_PRINTABLE_DIAGRAM_SIZE = 81000000L;
    private static final int COLOR_DEPTH = 16;

    protected static Shell getShell() {
        return DiagramUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    public static Image getImage(Rectangle rectFullDiagram) {
        Image image = null;
        boolean bContinue = PrintDiagramHelper.checkDiagramSize(rectFullDiagram);
        if (!bContinue) {
            return image;
        }
        Display display = Display.getDefault();
        System.gc();
        ImageData imageData = new ImageData(10, 10, 16, new PaletteData(255, 65280, 0xFF0000));
        ImageData scaledIData = imageData.scaledTo(rectFullDiagram.width, rectFullDiagram.height);
        image = new Image((Device)display, scaledIData);
        return image;
    }

    public static boolean checkDiagramSize(Rectangle rect) {
        long lRectangleSize = rect.width * rect.height;
        if (lRectangleSize > 81000000L) {
            String sMessage = String.valueOf(Util.getString("PrintDiagramWarningDialog1.message", (Object)81000000L)) + Util.getString("PrintDiagramWarningDialog2.message", (Object)lRectangleSize);
            MessageDialog.openWarning((Shell)PrintDiagramHelper.getShell(), (String)Util.getString("PrintDiagramWarningDialog.title", new Object[0]), (String)sMessage);
            return false;
        }
        return true;
    }
}

