/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.connection.DiagramUmlAssociation;
import org.teiid.designer.diagram.ui.connection.DiagramUmlDependency;
import org.teiid.designer.diagram.ui.connection.DiagramUmlGeneralization;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.figure.DiagramFigure;
import org.teiid.designer.diagram.ui.figure.LabeledRectangleFigure;
import org.teiid.designer.diagram.ui.model.AbstractFreeDiagramModelNode;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierContainerNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlClassifierContainerEditPart;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlClassifierEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramEntityManager;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.AbstractDiagramEntity;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramContainer;
import org.teiid.designer.metamodels.diagram.DiagramEntity;
import org.teiid.designer.metamodels.diagram.DiagramFactory;
import org.teiid.designer.metamodels.diagram.DiagramLink;
import org.teiid.designer.metamodels.diagram.DiagramLinkType;
import org.teiid.designer.metamodels.diagram.DiagramPosition;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.graphics.GlobalUiFontManager;
import org.teiid.designer.ui.util.DiagramProxy;
import org.teiid.designer.ui.viewsupport.MarkerUtilities;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DiagramUiUtilities {
    private static DiagramFactory diagramFactory = DiagramFactory.eINSTANCE;
    public static final int LOG_NONE = -1;
    public static final int UML_DIAGRAM = 0;
    public static final int TABLE_DIAGRAM = 1;
    public static int iDE = 0;
    private static Font baseFont;
    private static Font toolTipFont;

    public static Font getFont() {
        if (baseFont == null) {
            baseFont = GlobalUiFontManager.getFont((FontData)new FontData("Verdana", 10, 0));
        }
        return baseFont;
    }

    public static Font getToolTipFont() {
        if (toolTipFont == null) {
            toolTipFont = GlobalUiFontManager.getFont((FontData)new FontData("Veranda", 8, 0));
        }
        return toolTipFont;
    }

    public static String getFontString(Font theFont) {
        FontData[] fontDataArray = theFont.getFontData();
        FontData firstFont = fontDataArray[0];
        firstFont.getHeight();
        String message = "  Font =( " + firstFont.getName() + ", " + firstFont.getHeight() + ", " + firstFont.getStyle() + ")";
        return message;
    }

    public static int getLargestSubstringConfinedTo(String s, Font f, int availableWidth) {
        FontMetrics metrics = FigureUtilities.getFontMetrics((Font)f);
        float avg = metrics.getAverageCharWidth();
        int min = 0;
        int max = s.length() + 1;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(availableWidth - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = FigureUtilities.getTextExtents((String)s.substring((int)0, (int)guess), (Font)f).width) < availableWidth) {
                min = guess;
                continue;
            }
            max = guess;
        }
        return min;
    }

    public int getFontAscent(Font someFont) {
        return FigureUtilities.getFontMetrics((Font)someFont).getAscent();
    }

    public int getFontDescent(Font someFont) {
        return FigureUtilities.getFontMetrics((Font)someFont).getDescent();
    }

    public int getFontLeading(Font someFont) {
        return FigureUtilities.getFontMetrics((Font)someFont).getLeading();
    }

    public static DiagramEntity getDiagramEntity(EObject eObj, Diagram diagram) {
        DiagramEntity diagramEntity = null;
        AbstractDiagramEntity de = DiagramUiUtilities.findDiagramEntity(diagram, eObj);
        if (de == null) {
            diagramEntity = diagramFactory.createDiagramEntity();
            if (diagram != null) {
                diagramEntity.setDiagram(diagram);
            }
            diagramEntity.setModelObject(eObj);
            try {
                ModelerCore.getModelEditor().addValue((Object)diagram, (Object)diagramEntity, diagram.getDiagramEntity());
            }
            catch (ModelerCoreException err) {
                DiagramUiConstants.Util.log((Throwable)err);
            }
            DiagramEntityManager.addEntity(diagram, (AbstractDiagramEntity)diagramEntity, eObj);
        } else if (de instanceof DiagramEntity) {
            diagramEntity = (DiagramEntity)de;
        }
        return diagramEntity;
    }

    public static DiagramLink createDiagramLink(EObject eObj, Diagram diagram) {
        DiagramLink diagramLink = diagramFactory.createDiagramLink();
        if (diagram != null) {
            diagramLink.setDiagram(diagram);
        }
        diagramLink.setModelObject(eObj);
        DiagramEntityManager.addEntity(diagram, (AbstractDiagramEntity)diagramLink, eObj);
        return diagramLink;
    }

    public static DiagramLink createDiagramLink(EObject eObj, Diagram diagram, int routerStyle) {
        DiagramLink diagramLink = diagramFactory.createDiagramLink();
        if (diagram != null) {
            diagramLink.setDiagram(diagram);
        }
        diagramLink.setModelObject(eObj);
        diagramLink.setType(DiagramLinkType.get((int)routerStyle));
        DiagramEntityManager.addEntity(diagram, (AbstractDiagramEntity)diagramLink, eObj);
        return diagramLink;
    }

    public static DiagramPosition createDiagramPosition(DiagramLink diagramLink, Point position) {
        DiagramPosition diagramPosition = diagramFactory.createDiagramPosition();
        if (diagramLink != null) {
            diagramPosition.setDiagramLink(diagramLink);
        }
        diagramPosition.setXPosition(position.x);
        diagramPosition.setYPosition(position.y);
        return diagramPosition;
    }

    public static List createDiagramPositions(DiagramLink diagramLink, List points) {
        ArrayList<DiagramPosition> positions = new ArrayList<DiagramPosition>(points.size());
        Iterator iter = points.iterator();
        Object nextObj = null;
        while (iter.hasNext()) {
            nextObj = iter.next();
            if (!(nextObj instanceof Point)) continue;
            positions.add(DiagramUiUtilities.createDiagramPosition(diagramLink, nextObj));
        }
        return positions;
    }

    public static void deleteDiagramEntity(DiagramEntity diagramEntity, Object txnSource) {
        if (diagramEntity != null && diagramEntity.getDiagram() != null) {
            boolean requiresStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Delete Diagram Entity", (Object)txnSource);
            boolean succeeded = false;
            try {
                ModelObjectUtilities.delete((EObject)diagramEntity, (boolean)false, (boolean)false, (Object)txnSource, (boolean)false);
                succeeded = true;
            }
            finally {
                if (requiresStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void deleteDiagramEntities(List diagramEntities, Object txnSource) {
        if (diagramEntities != null && !diagramEntities.isEmpty()) {
            boolean requiresStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Delete Diagram Entities", (Object)txnSource);
            boolean succeeded = false;
            try {
                ModelObjectUtilities.delete((List)diagramEntities, (boolean)false, (boolean)false, (Object)txnSource, (boolean)false);
                succeeded = true;
            }
            finally {
                if (requiresStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static DiagramModelNode getDiagramModelNode(EObject eObj, DiagramModelNode diagramRootModelNode) {
        List currentChildren = diagramRootModelNode.getChildren();
        if (currentChildren != null && !currentChildren.isEmpty()) {
            for (DiagramModelNode childModelNode : currentChildren) {
                if (childModelNode.getModelObject() == null || childModelNode.getModelObject() == null || !eObj.equals(childModelNode.getModelObject())) continue;
                return childModelNode;
            }
        }
        return null;
    }

    public static DiagramModelNode getRootDiagramModelNode(DiagramModelNode diagramModelNode) {
        DiagramModelNode rootNode = null;
        if (diagramModelNode.getModelObject() != null) {
            DiagramModelNode parentNode = diagramModelNode;
            while (rootNode == null && diagramModelNode.getParent() != null && diagramModelNode.getModelObject() != null) {
                if (parentNode.getModelObject() instanceof Diagram) {
                    rootNode = parentNode;
                    continue;
                }
                parentNode = parentNode.getParent();
            }
        }
        return rootNode;
    }

    public static DiagramModelNode getModelNode(EObject someModelObject, DiagramModelNode diagramModelNode) {
        if (diagramModelNode.getModelObject() != null && diagramModelNode.getModelObject() == someModelObject) {
            return diagramModelNode;
        }
        DiagramModelNode matchedNode = null;
        List contents = diagramModelNode.getChildren();
        if (contents != null && !contents.isEmpty()) {
            Iterator iter = contents.iterator();
            Object nextObj = null;
            DiagramModelNode nextNode = null;
            while (iter.hasNext() && matchedNode == null) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramModelNode)) continue;
                nextNode = nextObj;
                matchedNode = DiagramUiUtilities.getModelNode(someModelObject, nextNode);
            }
        }
        return matchedNode;
    }

    public static boolean diagramContainsEObject(EObject eObj, DiagramModelNode diagramRootModelNode) {
        return DiagramUiUtilities.getDiagramModelNode(eObj, diagramRootModelNode) != null;
    }

    public static DiagramEditPart getDiagramEditPart(DiagramEditPart someDiagramEditPart, DiagramModelNode targetDiagramModelNode) {
        DiagramEditPart diagramEP = (DiagramEditPart)someDiagramEditPart.getViewer().getContents();
        DiagramEditPart foundEP = (DiagramEditPart)diagramEP.getViewer().getEditPartRegistry().get(targetDiagramModelNode);
        return foundEP;
    }

    public static boolean isDiagramObject(EObject eObject) {
        return eObject instanceof DiagramContainer || eObject instanceof Diagram || eObject instanceof AbstractDiagramEntity;
    }

    public static boolean isNonDrawingDiagramObject(EObject eObject) {
        return eObject instanceof DiagramContainer || eObject instanceof Diagram || eObject instanceof DiagramEntity;
    }

    public static boolean isPackageDiagram(EObject eObject) {
        return eObject instanceof Diagram && ((Diagram)eObject).getType() != null && ((Diagram)eObject).getType().equals("packageDiagramType");
    }

    public static String getDiagramNotation(Diagram diagramContainerObject) {
        String diagramNotation = diagramContainerObject.getNotation();
        if (diagramNotation == null) {
            diagramNotation = DiagramUiPlugin.getDiagramNotationManager().getCurrentExtensionId();
        }
        return diagramNotation;
    }

    public static void setDiagramNotation(String notationId, Diagram diagramContainerObject) {
        diagramContainerObject.setNotation(notationId);
    }

    public static void hiliteCurrentSelectionDependencies() {
        EObject selectedEO;
        ISelection selection;
        DiagramEditor de = DiagramEditorUtil.getVisibleDiagramEditor();
        if (de != null && de.getDiagramViewer() != null && SelectionUtilities.isSingleSelection((ISelection)(selection = DiagramEditorUtil.getVisibleDiagramEditor().getDiagramViewer().getSelection())) && (selectedEO = SelectionUtilities.getSelectedEObject((ISelection)selection)) != null) {
            DiagramEditorUtil.getVisibleDiagramEditor().getDiagramViewer().getSelectionHandler().hiliteDependencies(selectedEO);
        }
    }

    public static DiagramEditPart getClassifierParent(DiagramEditPart someEditPart) {
        DiagramEditPart parentEditPart = null;
        if (someEditPart.getParent() != null && someEditPart.getParent() instanceof UmlClassifierContainerEditPart) {
            parentEditPart = (DiagramEditPart)someEditPart.getParent().getParent();
            if (parentEditPart.getParent() != null && parentEditPart.getParent() instanceof UmlClassifierContainerEditPart) {
                parentEditPart = DiagramUiUtilities.getClassifierParent(parentEditPart);
            } else if (!(parentEditPart instanceof UmlClassifierEditPart)) {
                parentEditPart = null;
            }
        } else if (someEditPart instanceof UmlClassifierEditPart) {
            parentEditPart = someEditPart;
        }
        return parentEditPart;
    }

    public static DiagramEditPart getTopClassifierParent(DiagramEditPart someEditPart) {
        DiagramEditPart parentEditPart = DiagramUiUtilities.getClassifierParent(someEditPart);
        return parentEditPart;
    }

    public static DiagramModelNode getClassifierParentNode(DiagramModelNode someDiagramNode) {
        DiagramModelNode parentClassifierNode = null;
        if (someDiagramNode.getParent() != null && someDiagramNode.getParent() instanceof UmlClassifierContainerNode) {
            parentClassifierNode = someDiagramNode.getParent().getParent();
            if (parentClassifierNode.getParent() != null && parentClassifierNode.getParent() instanceof UmlClassifierContainerNode) {
                parentClassifierNode = DiagramUiUtilities.getClassifierParentNode(parentClassifierNode);
            } else if (!(parentClassifierNode instanceof UmlClassifierNode)) {
                parentClassifierNode = null;
            }
        } else if (someDiagramNode instanceof UmlClassifierNode) {
            parentClassifierNode = someDiagramNode;
        }
        return parentClassifierNode;
    }

    public static DiagramModelNode getTopClassifierParentNode(DiagramModelNode someDiagramNode) {
        DiagramModelNode parentClassifierNode = DiagramUiUtilities.getClassifierParentNode(someDiagramNode);
        return parentClassifierNode;
    }

    public static EObject getParentClassifier(EObject eObject) {
        EObject topClassifier = null;
        EObject parentObject = null;
        if (DiagramUiPlugin.getDiagramAspectManager().isClassifier(eObject)) {
            topClassifier = eObject;
            parentObject = eObject.eContainer();
            if (parentObject != null && parentObject instanceof EObject && DiagramUiPlugin.getDiagramAspectManager().isClassifier(parentObject)) {
                topClassifier = DiagramUiUtilities.getParentClassifier(parentObject);
            }
        } else {
            parentObject = eObject.eContainer();
            if (parentObject != null && parentObject instanceof EObject) {
                topClassifier = DiagramUiUtilities.getParentClassifier(parentObject);
            }
        }
        return topClassifier;
    }

    public static boolean isStandardUmlPackage(Object input) {
        MetamodelDescriptor md;
        String mmUri;
        EObject eObject;
        MetamodelAspect theAspect;
        boolean result = false;
        if (input instanceof EObject && (theAspect = ModelObjectUtilities.getUmlAspect((EObject)(eObject = (EObject)input))) instanceof UmlPackage && (mmUri = eObject.eClass().getEPackage().getNsURI()) != null && (md = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(mmUri)) != null) {
            result = md.supportsDiagrams();
        }
        return result;
    }

    public static boolean hasParentPackage(Object input) {
        EObject eObject;
        EObject parentPackage;
        boolean result = false;
        if (input instanceof EObject && (parentPackage = DiagramUiUtilities.getParentPackage(eObject = (EObject)input)) != null) {
            result = true;
        }
        return result;
    }

    public static EObject getParentPackage(Object input) {
        EObject eObject;
        EObject parent;
        EObject packageEObject = null;
        if (input instanceof EObject && (parent = (eObject = (EObject)input).eContainer()) != null && parent instanceof EObject) {
            packageEObject = DiagramUiUtilities.isStandardUmlPackage(parent) ? parent : DiagramUiUtilities.getParentPackage(parent);
        }
        return packageEObject;
    }

    public static boolean isModelResourceChild(Object input) {
        EObject eObject;
        EObject parent;
        boolean result = false;
        if (input instanceof EObject && !(input instanceof Diagram) && (parent = (eObject = (EObject)input).eContainer()) == null) {
            result = true;
        }
        return result;
    }

    public static DiagramModelNode[] getNodeArray(List nodeList) {
        if (nodeList != null && !nodeList.isEmpty()) {
            DiagramModelNode[] nodeArray = new DiagramModelNode[nodeList.size()];
            DiagramModelNode nextNode = null;
            Iterator iter = nodeList.iterator();
            int count = 0;
            while (iter.hasNext()) {
                nodeArray[count] = nextNode = (DiagramModelNode)iter.next();
                ++count;
            }
            return nodeArray;
        }
        DiagramModelNode[] emptyArray = new DiagramModelNode[1];
        return emptyArray;
    }

    public static List getConnectedModelNodes(DiagramModelNode parentDiagramModelNode) {
        ArrayList childNodes = new ArrayList(parentDiagramModelNode.getChildren());
        HashMap<DiagramModelNode, String> connectedNodes = new HashMap<DiagramModelNode, String>();
        Iterator iter = childNodes.iterator();
        Object nextObject = null;
        DiagramModelNode nextDiagramNode = null;
        while (iter.hasNext()) {
            nextObject = iter.next();
            if (!(nextObject instanceof DiagramModelNode) || !DiagramUiUtilities.diagramNodeIsLinked(nextDiagramNode = (DiagramModelNode)nextObject) || connectedNodes.get(nextDiagramNode) != null) continue;
            connectedNodes.put(nextDiagramNode, "x");
        }
        if (connectedNodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(connectedNodes.keySet());
    }

    public static List getAllSourceConnections(DiagramModelNode parentDiagramModelNode) {
        ArrayList childNodes = new ArrayList(parentDiagramModelNode.getChildren());
        Iterator iter = childNodes.iterator();
        ArrayList connectionModelNodes = new ArrayList(childNodes.size());
        Object nextObject = null;
        DiagramModelNode nextDiagramNode = null;
        while (iter.hasNext()) {
            nextObject = iter.next();
            if (!(nextObject instanceof DiagramModelNode) || (nextDiagramNode = (DiagramModelNode)nextObject).getSourceConnections() == null || nextDiagramNode.getSourceConnections().isEmpty()) continue;
            connectionModelNodes.addAll(nextDiagramNode.getSourceConnections());
        }
        if (connectionModelNodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return connectionModelNodes;
    }

    public static List getNonConnectedModelNodes(DiagramModelNode parentDiagramModelNode) {
        ArrayList childNodes = new ArrayList(parentDiagramModelNode.getChildren());
        HashMap<DiagramModelNode, String> nonConnectedNodes = new HashMap<DiagramModelNode, String>();
        Iterator iter = childNodes.iterator();
        Object nextObject = null;
        DiagramModelNode nextDiagramNode = null;
        while (iter.hasNext()) {
            nextObject = iter.next();
            if (!(nextObject instanceof DiagramModelNode) || nextObject instanceof AbstractFreeDiagramModelNode || DiagramUiUtilities.diagramNodeIsLinked(nextDiagramNode = (DiagramModelNode)nextObject) || nonConnectedNodes.get(nextDiagramNode) != null) continue;
            nonConnectedNodes.put(nextDiagramNode, "x");
        }
        if (nonConnectedNodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(nonConnectedNodes.keySet());
    }

    public static boolean diagramNodeIsLinked(DiagramModelNode diagramModelNode) {
        if (diagramModelNode.getSourceConnections() != null && !diagramModelNode.getSourceConnections().isEmpty()) {
            return true;
        }
        return diagramModelNode.getTargetConnections() != null && !diagramModelNode.getTargetConnections().isEmpty();
    }

    public static String getEObjectLabel(EObject eObject) {
        return DiagramUiPlugin.getDiagramNotationManager().getLabelProvider().getText((Object)eObject);
    }

    public static ImageDescriptor getDecorationIcon(EObject element) {
        ImageDescriptor icon = null;
        IMarker[] markers = null;
        IResource resrc = null;
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)element);
        if (modelResource != null) {
            resrc = modelResource.getResource();
        }
        if (resrc != null) {
            boolean errorOccurred = false;
            try {
                markers = resrc.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            }
            catch (CoreException ex) {
                DiagramUiConstants.Util.log((Throwable)ex);
                errorOccurred = true;
            }
            if (!errorOccurred) {
                int ndx = markers.length;
                while (--ndx >= 0) {
                    Object attr;
                    boolean usable;
                    IMarker marker = markers[ndx];
                    EObject targetEObject = ModelObjectUtilities.getMarkedEObject((IMarker)marker);
                    boolean bl = usable = element == targetEObject || ModelObjectUtilities.isDescendant((EObject)element, (EObject)targetEObject);
                    if (!usable || (attr = MarkerUtilities.getMarkerAttribute((IMarker)marker, (String)"severity", (ModelResource)modelResource)) == null) continue;
                    int severity = (Integer)attr;
                    if (severity == 2) {
                        icon = DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/ovr16/error_co.gif");
                        break;
                    }
                    if (icon != null || severity != 1) continue;
                    icon = DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/ovr16/warning_co.gif");
                }
            }
        }
        return icon;
    }

    public static int getErrorState(EObject eObject) {
        int errorState = 0;
        IMarker[] markers = null;
        IResource resrc = null;
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject);
        if (modelResource != null) {
            resrc = modelResource.getResource();
        }
        if (resrc != null) {
            boolean errorOccurred = false;
            try {
                markers = resrc.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            }
            catch (CoreException ex) {
                DiagramUiConstants.Util.log((Throwable)ex);
                errorOccurred = true;
            }
            if (!errorOccurred) {
                int ndx = markers.length;
                while (--ndx >= 0) {
                    Object attr;
                    boolean usable;
                    IMarker marker = markers[ndx];
                    EObject targetEObject = ModelObjectUtilities.getMarkedEObject((IMarker)marker);
                    boolean bl = usable = eObject == targetEObject;
                    if (!usable || (attr = MarkerUtilities.getMarkerAttribute((IMarker)marker, (String)"severity", (ModelResource)modelResource)) == null) continue;
                    int severity = (Integer)attr;
                    if (severity == 2) {
                        errorState = 2;
                        break;
                    }
                    if (errorState != 0 || severity != 1) continue;
                    errorState = 1;
                    break;
                }
            }
        }
        return errorState;
    }

    public static List getEObjectsWithErrorsOrWarnings(DiagramModelNode parentDiagramModelNode) {
        ArrayList<EObject> resultList = new ArrayList<EObject>();
        List diagramContents = parentDiagramModelNode.getChildren();
        Iterator iter1 = diagramContents.iterator();
        Object nextObject = null;
        DiagramModelNode nextNode = null;
        while (iter1.hasNext()) {
            nextObject = iter1.next();
            if (!(nextObject instanceof DiagramModelNode)) continue;
            nextNode = nextObject;
            if (nextNode.getModelObject() != null && (nextNode.hasErrors() || nextNode.hasWarnings())) {
                resultList.add(nextNode.getModelObject());
            }
            if (nextNode.getChildren() == null || nextNode.getChildren().isEmpty()) continue;
            DiagramUiUtilities.getEObjectsWithErrorsOrWarnings(resultList, nextNode);
        }
        return resultList;
    }

    public static boolean hasEObjectsWithErrorsOrWarnings(DiagramModelNode parentDiagramModelNode) {
        if (parentDiagramModelNode == null) {
            return false;
        }
        List diagramContents = parentDiagramModelNode.getChildren();
        Iterator iter1 = diagramContents.iterator();
        Object nextObject = null;
        DiagramModelNode nextNode = null;
        while (iter1.hasNext()) {
            nextObject = iter1.next();
            if (!(nextObject instanceof DiagramModelNode)) continue;
            nextNode = nextObject;
            if (nextNode.getModelObject() != null && (nextNode.hasErrors() || nextNode.hasWarnings())) {
                return true;
            }
            List kids = nextNode.getChildren();
            if (kids == null || kids.isEmpty() || !DiagramUiUtilities.hasEObjectsWithErrorsOrWarnings(nextNode)) continue;
            return true;
        }
        return false;
    }

    private static List getEObjectsWithErrorsOrWarnings(List resultList, DiagramModelNode parentDiagramModelNode) {
        List nodeContents = parentDiagramModelNode.getChildren();
        Iterator iter1 = nodeContents.iterator();
        Object nextObject = null;
        DiagramModelNode nextNode = null;
        while (iter1.hasNext()) {
            nextObject = iter1.next();
            if (!(nextObject instanceof DiagramModelNode)) continue;
            nextNode = nextObject;
            if (nextNode.getModelObject() != null && (nextNode.hasErrors() || nextNode.hasWarnings())) {
                resultList.add(nextNode.getModelObject());
            }
            if (nextNode.getChildren() == null || nextNode.getChildren().isEmpty()) continue;
            DiagramUiUtilities.getEObjectsWithErrorsOrWarnings(resultList, nextNode);
        }
        return resultList;
    }

    public static boolean isNestedClassifier(DiagramModelNode targetNode) {
        return targetNode.getParent() != null && targetNode.getParent() instanceof UmlClassifierContainerNode;
    }

    public static boolean isNestedClassifier(DiagramEditPart editPart) {
        return ((DiagramModelNode)editPart.getModel()).getParent() != null && ((DiagramModelNode)editPart.getModel()).getParent() instanceof UmlClassifierContainerNode;
    }

    public static Point getNestedRelativeLocation(DiagramEditPart editPart) {
        Point relPt = new Point();
        DiagramEditPart classifierPart = editPart;
        DiagramEditPart containerPart = null;
        boolean wasNested = false;
        while (DiagramUiUtilities.isNestedClassifier(classifierPart)) {
            wasNested = true;
            relPt.x += classifierPart.getFigure().getBounds().x;
            relPt.y += classifierPart.getFigure().getBounds().y;
            containerPart = (DiagramEditPart)classifierPart.getParent();
            relPt.x += containerPart.getFigure().getBounds().x;
            relPt.y += containerPart.getFigure().getBounds().y;
            classifierPart = (DiagramEditPart)containerPart.getParent();
        }
        if (wasNested) {
            relPt.x += classifierPart.getFigure().getBounds().x;
            relPt.y += classifierPart.getFigure().getBounds().y;
        }
        return relPt;
    }

    public static boolean isLassoableEditPart(EditPart editPart) {
        boolean canLasso = false;
        if (editPart instanceof DiagramEditPart && !DiagramUiUtilities.isNestedClassifier((DiagramEditPart)editPart)) {
            DiagramEditPart dep = (DiagramEditPart)editPart;
            canLasso = dep.isSelectablePart();
        }
        return canLasso;
    }

    public static boolean isLassoableFigure(IFigure figure) {
        boolean canLasso = false;
        if (figure instanceof DiagramFigure && !(figure instanceof LabeledRectangleFigure)) {
            canLasso = true;
        }
        return canLasso;
    }

    public static boolean isNodeConnected(DiagramModelNode node) {
        return node.getSourceConnections() != null && !node.getSourceConnections().isEmpty() || node.getTargetConnections() != null && !node.getTargetConnections().isEmpty();
    }

    public static EditPart getSourceEndEditPart(NodeConnectionEditPart ncep) {
        DiagramEditPart targetEP = (DiagramEditPart)ncep.getSource();
        NodeConnectionModel ncm = (NodeConnectionModel)ncep.getModel();
        if (ncm instanceof DiagramUmlGeneralization) {
            return targetEP;
        }
        if (ncm instanceof DiagramUmlDependency) {
            return targetEP;
        }
        if (ncm instanceof DiagramUmlAssociation) {
            DiagramEditPart dep = null;
            DiagramModelNode diagramNode = ((DiagramModelNode)targetEP.getModel()).getParent();
            EObject endEObject = ((DiagramUmlAssociation)ncm).getBAssociation().getEnd(0);
            if (endEObject != null) {
                DiagramModelNode someSourceNode = DiagramUiUtilities.getModelNode(endEObject, diagramNode);
                if (someSourceNode != null) {
                    dep = DiagramUiUtilities.getDiagramEditPart(targetEP, someSourceNode);
                }
                if (dep != null) {
                    return dep;
                }
            }
        }
        return targetEP;
    }

    public static EditPart getTargetEndEditPart(NodeConnectionEditPart ncep) {
        DiagramEditPart targetEP = (DiagramEditPart)ncep.getTarget();
        NodeConnectionModel ncm = (NodeConnectionModel)ncep.getModel();
        if (ncm instanceof DiagramUmlGeneralization) {
            return targetEP;
        }
        if (ncm instanceof DiagramUmlDependency) {
            return targetEP;
        }
        if (ncm instanceof DiagramUmlAssociation) {
            DiagramEditPart dep = null;
            if (targetEP != null && targetEP.getModel() != null) {
                DiagramModelNode diagramNode = ((DiagramModelNode)targetEP.getModel()).getParent();
                EObject endEObject = ((DiagramUmlAssociation)ncm).getBAssociation().getEnd(1);
                if (endEObject != null) {
                    DiagramModelNode someTargetNode = DiagramUiUtilities.getModelNode(endEObject, diagramNode);
                    if (someTargetNode != null) {
                        dep = DiagramUiUtilities.getDiagramEditPart(targetEP, someTargetNode);
                    }
                    if (dep != null) {
                        return dep;
                    }
                }
            }
        }
        return targetEP;
    }

    public static boolean nodesAreConnected(DiagramModelNode sourceNode, DiagramModelNode targetNode) {
        Vector nodeConnections = sourceNode.getSourceConnections();
        NodeConnectionModel nextConn2 = null;
        for (NodeConnectionModel nextConn2 : nodeConnections) {
            if (!((DiagramModelNode)nextConn2.getTargetNode()).getModelObject().equals(targetNode.getModelObject())) continue;
            return true;
        }
        nodeConnections = sourceNode.getTargetConnections();
        for (NodeConnectionModel nextConn2 : nodeConnections) {
            if (!((DiagramModelNode)nextConn2.getSourceNode()).getModelObject().equals(targetNode.getModelObject())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDiagramEntity(Diagram diagram, EObject eObject) {
        ArrayList dEntities = new ArrayList(diagram.eContents());
        Iterator iter = dEntities.iterator();
        AbstractDiagramEntity nextDE = null;
        while (iter.hasNext()) {
            nextDE = (AbstractDiagramEntity)iter.next();
            EObject someDEMO = nextDE.getModelObject();
            if (someDEMO == null || !someDEMO.equals(eObject)) continue;
            return true;
        }
        return false;
    }

    public static AbstractDiagramEntity findDiagramEntity(Diagram diagram, EObject eObject) {
        ArrayList dEntities = new ArrayList(diagram.eContents());
        Iterator iter = dEntities.iterator();
        AbstractDiagramEntity nextDE = null;
        while (iter.hasNext()) {
            nextDE = (AbstractDiagramEntity)iter.next();
            EObject someDEMO = nextDE.getModelObject();
            if (someDEMO == null || !someDEMO.equals(eObject)) continue;
            return nextDE;
        }
        return null;
    }

    public static DiagramLink findDiagramLink(Diagram diagram, EObject eObject) {
        ArrayList dEntities = new ArrayList(diagram.eContents());
        Iterator iter = dEntities.iterator();
        AbstractDiagramEntity nextDE = null;
        while (iter.hasNext()) {
            nextDE = (AbstractDiagramEntity)iter.next();
            EObject someDEMO = nextDE.getModelObject();
            if (someDEMO == null || !(nextDE instanceof DiagramLink) || !someDEMO.equals(eObject)) continue;
            return (DiagramLink)nextDE;
        }
        return null;
    }

    public static boolean getReadOnlyState(Object someObject) {
        DiagramModelNode diagramNode;
        if (someObject != null && ModelUtilities.isModelDiagramLocked((Object)someObject)) {
            return true;
        }
        boolean rOnly = true;
        Diagram someDiagram = null;
        if (someObject instanceof Diagram) {
            someDiagram = (Diagram)someObject;
        } else if (someObject instanceof DiagramModelNode && (diagramNode = (DiagramModelNode)someObject).getModelObject() != null && diagramNode.getModelObject() instanceof Diagram) {
            someDiagram = (Diagram)diagramNode.getModelObject();
        }
        if (someDiagram != null) {
            rOnly = someDiagram.getType().equals("packageDiagramType") ? (someDiagram.getTarget() != null && someDiagram.getTarget() instanceof ModelAnnotation ? ModelObjectUtilities.isReadOnly((EObject)someDiagram.getTarget()) : ModelObjectUtilities.isReadOnly((EObject)someDiagram)) : ModelObjectUtilities.isReadOnly((EObject)someDiagram);
        }
        return rOnly;
    }

    public static int getCurrentRouterStyle() {
        int style = 1;
        String router = DiagramUiUtilities.getCurrentRouterStylePreference();
        if (router != null) {
            boolean selected = false;
            int i = 0;
            String[] routers = DiagramUiConstants.LinkRouter.types;
            while (!selected && i < routers.length) {
                String thisRouter = routers[i];
                if (thisRouter.equals(router)) {
                    style = i;
                    selected = true;
                    continue;
                }
                ++i;
            }
        }
        return style;
    }

    public static int getCurrentRouterStyleID(String type) {
        int style = 1;
        boolean selected = false;
        int i = 0;
        String[] routers = DiagramUiConstants.LinkRouter.types;
        while (!selected && i < routers.length) {
            String thisRouter = routers[i];
            if (thisRouter.equals(type)) {
                style = i;
                selected = true;
                continue;
            }
            ++i;
        }
        return style;
    }

    public static String getCurrentRouterStylePreference() {
        String router = null;
        String prefName = "modeler.preference.diagram.diagramRouterStyle";
        IPreferenceStore preferenceStore = DiagramUiPlugin.getDefault().getPreferenceStore();
        if (preferenceStore != null) {
            router = preferenceStore.getString(prefName);
        }
        return router;
    }

    public static void setRouterStylePreference(String style) {
        boolean notFound = true;
        int i = 0;
        String currentStyle = DiagramUiUtilities.getCurrentRouterStylePreference();
        if (!currentStyle.equals(style)) {
            String[] routers = DiagramUiConstants.LinkRouter.types;
            while (notFound && i < routers.length) {
                String thisRouter = routers[i];
                if (thisRouter.equals(style)) {
                    IPreferenceStore preferenceStore = DiagramUiPlugin.getDefault().getPreferenceStore();
                    if (preferenceStore != null) {
                        preferenceStore.setValue("modeler.preference.diagram.diagramRouterStyle", style);
                        DiagramUiPlugin.getDefault().savePreferences();
                    }
                    notFound = false;
                    continue;
                }
                ++i;
            }
            DiagramUiPlugin.updateEditorForPreferences();
        }
    }

    public static void setRouterStylePreference(int id) {
        int currentId = DiagramUiUtilities.getCurrentRouterStyle();
        String[] routers = DiagramUiConstants.LinkRouter.types;
        if (currentId != id && id >= 0 && id < routers.length) {
            IPreferenceStore preferenceStore = DiagramUiPlugin.getDefault().getPreferenceStore();
            if (preferenceStore != null) {
                preferenceStore.setValue("modeler.preference.diagram.diagramRouterStyle", routers[id]);
                DiagramUiPlugin.getDefault().savePreferences();
            }
            DiagramUiPlugin.updateEditorForPreferences();
        }
    }

    public static Collection getEObjects(DiagramModelNode root) {
        List children;
        HashSet<EObject> rv = new HashSet<EObject>();
        EObject e = root.getModelObject();
        if (e != null) {
            rv.add(e);
        }
        if ((children = root.getChildren()) != null) {
            for (DiagramModelNode child : children) {
                rv.addAll(DiagramUiUtilities.getEObjects(child));
            }
        }
        return rv;
    }

    public static boolean isValidDiagram(Diagram diagram) {
        if (diagram instanceof DiagramProxy && ((DiagramProxy)diagram).getModelResource() == null) {
            return false;
        }
        if (diagram.getTarget() == null) {
            return false;
        }
        if (diagram.getTarget().eResource() == null) {
            return false;
        }
        boolean isTransient = DiagramUiPlugin.getDiagramTypeManager().isTransientDiagram(diagram);
        return isTransient || diagram.eResource() != null;
    }
}

