/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.DependencyAspect;
import org.teiid.designer.core.metamodel.aspect.FeatureConstraintAspect;
import org.teiid.designer.core.metamodel.aspect.ImportsAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.ValidationAspect;
import org.teiid.designer.core.metamodel.aspect.relationship.RelationshipMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlClassifier;
import org.teiid.designer.core.metamodel.aspect.uml.UmlDiagramAspect;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class AspectManager {
    private static final Map<String, Class<? extends MetamodelAspect>> EXTENSION_ID_TO_ASPECT_INTERFACE_MAP = new HashMap<String, Class<? extends MetamodelAspect>>(7);
    private HashMap<EClass, MetamodelAspect> hmAspectCache = new HashMap();
    private String sAspectId;

    static {
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("sqlAspect", SqlAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("umlDiagramAspect", UmlDiagramAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("validationAspect", ValidationAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("dependencyAspect", DependencyAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("featureConstraintAspect", FeatureConstraintAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("importAspect", ImportsAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("relationshipAspect", RelationshipMetamodelAspect.class);
    }

    public AspectManager(String sAspectId) {
        this.setAspectId(sAspectId);
    }

    public AspectManager() {
        this("umlDiagramAspect");
    }

    public void setAspectId(String sAspectId) {
        this.sAspectId = sAspectId;
        if (this.hmAspectCache != null) {
            this.hmAspectCache.clear();
        }
    }

    public String getAspectId() {
        return this.sAspectId;
    }

    public MetamodelAspect getUmlAspect(EObject eObject) {
        MetamodelAspect aspect;
        Class<? extends MetamodelAspect> type;
        EClass eClass = eObject.eClass();
        if (!this.hmAspectCache.containsKey(eClass) && (type = EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.get(this.getAspectId())) != null && (aspect = ModelerCore.getMetamodelRegistry().getMetamodelAspect(eClass, type)) != null) {
            this.hmAspectCache.put(eClass, aspect);
        }
        return this.hmAspectCache.get(eClass);
    }

    public List<Object> getChildren(EObject parent) {
        ITreeContentProvider provider = ModelUtilities.getModelContentProvider();
        if (provider.hasChildren((Object)parent)) {
            return Arrays.asList(provider.getChildren((Object)parent));
        }
        return Collections.emptyList();
    }

    public boolean isClassifier(EObject eObject) {
        MetamodelAspect someAspect = this.getUmlAspect(eObject);
        return someAspect != null && someAspect instanceof UmlClassifier;
    }
}

