/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.association.AbstractAssociationDescriptor;
import org.teiid.designer.core.association.AssociationDescriptor;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.wizards.NewModelObjectWizardManager;

public class SetAssociationCommand
extends Command
implements DiagramUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(SetAssociationCommand.class);
    private List selectedEObjects;

    public SetAssociationCommand(List selectedEObjects) {
        super("Set Foreign Key");
        this.selectedEObjects = selectedEObjects;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        StructuredSelection selection;
        Shell shell;
        if (this.selectedEObjects == null) return;
        Collection descriptors = null;
        try {
            descriptors = ModelerCore.getModelEditor().getNewAssociationDescriptors(this.selectedEObjects);
        }
        catch (ModelerCoreException theException) {
            Util.log((Throwable)theException);
        }
        if (descriptors == null || descriptors.isEmpty()) return;
        AssociationDescriptor descriptor = null;
        if (descriptors.size() == 1) {
            descriptor = (AssociationDescriptor)descriptors.iterator().next();
        } else {
            Object[] result;
            AssociationDescriptorLabelProvider provider = new AssociationDescriptorLabelProvider();
            ListDialog dialog = new ListDialog(UiUtil.getWorkbenchShellOnlyIfUiThread());
            dialog.setLabelProvider((ILabelProvider)provider);
            dialog.setContentProvider((IStructuredContentProvider)provider);
            dialog.setInput(new ArrayList(descriptors));
            dialog.setTitle(Util.getString(String.valueOf(PREFIX) + "dialog.title", new Object[0]));
            dialog.setMessage(Util.getString(String.valueOf(PREFIX) + "dialog.msg", new Object[0]));
            dialog.setInitialSelections(new Object[]{descriptors.iterator().next()});
            if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
                descriptor = (AssociationDescriptor)result[0];
            }
        }
        if (descriptor == null || !NewModelObjectWizardManager.isAssociationDescriptorValid((Shell)(shell = DiagramUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell()), (AssociationDescriptor)descriptor, (ISelection)(selection = new StructuredSelection(this.selectedEObjects)))) return;
        if (!descriptor.creationComplete()) {
            String undoText = Util.getString(String.valueOf(PREFIX) + "undoText", new Object[]{descriptor.getText()});
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)undoText, (Object)this);
            boolean succeeded = false;
            try {
                try {
                    EObject newAssociation = ModelerCore.getModelEditor().createNewAssociationFromDescriptor((Object)descriptor);
                    ModelEditorManager.open((EObject)newAssociation, (boolean)true);
                    succeeded = true;
                    return;
                }
                catch (ModelerCoreException theException) {
                    Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "msg.createDescriptorProblem", new Object[]{descriptor}));
                    if (!requiredStart) return;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        return;
                    }
                    ModelerCore.rollbackTxn();
                }
                return;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        } else {
            EObject newAssociation = ((AbstractAssociationDescriptor)descriptor).getNewAssociation();
            if (newAssociation == null) return;
            ModelEditorManager.open((EObject)newAssociation, (boolean)true);
        }
    }

    public void redo() {
    }

    public void undo() {
    }

    class AssociationDescriptorLabelProvider
    extends LabelProvider
    implements IStructuredContentProvider {
        AssociationDescriptorLabelProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getText(Object theElement) {
            String result = null;
            result = theElement != null && theElement instanceof AssociationDescriptor ? ((AssociationDescriptor)theElement).getText() : super.getText(theElement);
            return result;
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }
    }
}

