/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.layout.spring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.layout.DefaultLayoutNode;
import org.teiid.designer.diagram.ui.layout.DiagramLayout;
import org.teiid.designer.diagram.ui.layout.LayoutNode;
import org.teiid.designer.diagram.ui.layout.LayoutUtilities;
import org.teiid.designer.diagram.ui.layout.spring.Spring;
import org.teiid.designer.diagram.ui.layout.spring.SpringLinkConstraints;
import org.teiid.designer.diagram.ui.layout.spring.SpringNodeConstraints;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;

public class SpringLayout
extends DiagramLayout {
    static final String CLASS_NAME = "SpringLayout";
    public static final int LEFT_ALIGNMENT = 0;
    public static final int CENTER_ALIGNMENT = 2;
    public static final int RIGHT_ALIGNMENT = 1;
    public static final int TOP_ALIGNMENT = 3;
    public static final int ERROR_NO_COMPONENT = 1;
    public static final int ERROR_NON_CONNECTED_GRAPH = 2;
    public static final int ERROR_ALL_COMPONENTS_FIXED = 3;
    private boolean _autoEdgeLength = true;
    private double _edgeLength = 1000.0;
    private boolean _useObjectsSizes = true;
    private double _XSpacing = 10.0;
    private double _YSpacing = 10.0;
    private boolean _automaticSingleSpacing = true;
    private boolean _specifyLayoutSize = false;
    private double _layoutSize = 500.0;
    private int _horizontalAlignment = 2;
    private int _verticalAlignment = 2;
    private int _repaintPeriod = 0;
    private double _epsilon = 1.5;
    private final HashMap _nodeConstraints = new HashMap();
    private final WeakHashMap _linkConstraints = new WeakHashMap();
    private DiagramModelNode diagramNode;
    private LayoutNode[] springNodes;

    public SpringLayout(List nodes) {
        Object firstNode = nodes.get(0);
        if (firstNode instanceof DiagramModelNode) {
            this.diagramNode = ((DiagramModelNode)firstNode).getParent();
        } else if (firstNode instanceof LayoutNode) {
            this.diagramNode = ((LayoutNode)firstNode).getModelNode().getParent();
        }
        this.createSpringNodes(nodes);
    }

    public void createSpringNodes(List nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            LayoutNode nextSpringNode = null;
            Iterator iter = nodes.iterator();
            int nNodes = nodes.size();
            this.springNodes = new LayoutNode[nNodes];
            int iNode = 0;
            Object nextObject = null;
            while (iter.hasNext()) {
                nextObject = iter.next();
                if (nextObject instanceof DiagramModelNode) {
                    nextSpringNode = new DefaultLayoutNode(nextObject);
                } else if (nextObject instanceof LayoutNode) {
                    nextSpringNode = nextObject;
                }
                SpringNodeConstraints newConstraint = null;
                if (nextSpringNode == null) continue;
                this.springNodes[iNode] = nextSpringNode;
                EObject modelObject = nextSpringNode.getModelNode().getModelObject();
                newConstraint = new SpringNodeConstraints(false, 50.0);
                this._nodeConstraints.put(modelObject, newConstraint);
                ++iNode;
            }
        }
    }

    @Override
    public int run() {
        int resultValue = this.run(this.springNodes, 0.0, 0.0);
        LayoutUtilities.justifyAllToCorner(this.springNodes);
        this.setFinalNodePositions();
        return resultValue;
    }

    int run(LayoutNode[] nodeArray, double deltaX, double deltaY) {
        Rectangle rectangle2d;
        int nNodes = nodeArray.length;
        Spring spring = new Spring(this);
        if (nNodes == 0) {
            return 0;
        }
        if (this._specifyLayoutSize) {
            rectangle2d = new Rectangle(this.getStartX(), this.getStartY(), (int)this._layoutSize, (int)this._layoutSize);
        } else {
            int length = (int)this.getSizeEstimate();
            rectangle2d = new Rectangle(this.getStartX(), this.getStartY(), length, length);
        }
        spring.setRectangle(rectangle2d);
        spring.setAutoEdgeLength(this._autoEdgeLength);
        spring.setEdgeLength(this._edgeLength);
        spring.setWidthIgnored(!this._useObjectsSizes);
        spring.setHeightIgnored(!this._useObjectsSizes);
        spring.setRepaintPeriod(this._repaintPeriod);
        spring.setEpsilon(this._epsilon);
        spring.setNodeConstraints(this._nodeConstraints);
        spring.setLinkConstraints(this._linkConstraints);
        String string = spring.compute(nodeArray, nNodes);
        int i = 0;
        while (i < nodeArray.length) {
            LayoutNode nextNode = nodeArray[i];
            nextNode.setCenterXY(spring.centerX[i], spring.centerY[i]);
            ++i;
        }
        Rectangle rectangle = new Rectangle(nodeArray[0].getBounds());
        double startX = rectangle.x;
        double startY = rectangle.y;
        double currentW = rectangle.width;
        double currentH = rectangle.height;
        int i2 = 1;
        while (i2 < nodeArray.length) {
            double thisX = nodeArray[i2].getX();
            double thisY = nodeArray[i2].getY();
            double thisW = nodeArray[i2].getBounds().width;
            double thisH = nodeArray[i2].getBounds().height;
            startX = Math.min(thisX, startX);
            startY = Math.min(thisY, startY);
            currentW = Math.max(currentW, thisW);
            currentH = Math.max(currentH, thisH);
            ++i2;
        }
        double totalCenterX = rectangle.getCenter().x;
        double totalCenterY = rectangle.getCenter().y;
        double xOffset = this._horizontalAlignment == 0 ? -deltaX + (double)rectangle.x - (double)this.getStartX() : (this._horizontalAlignment == 2 ? -deltaX + (double)rectangle.x + (double)rectangle.width * 0.5 - totalCenterX : -deltaX + (double)rectangle.x + (double)rectangle.width - (double)this.getStartX() - (double)this.getWidth());
        double yOffset = this._verticalAlignment == 2 ? -deltaY + (double)rectangle.y + (double)rectangle.height * 0.5 - totalCenterY : -deltaY + (double)rectangle.y - (double)this.getStartY();
        int i3 = 0;
        while (i3 < nNodes) {
            LayoutNode nextNode = nodeArray[i3];
            nextNode.setCenterXY(spring.centerX[i3] - xOffset, spring.centerY[i3] - yOffset);
            ++i3;
        }
        if (string == null) {
            return 0;
        }
        if (string.endsWith("to layout")) {
            return 1;
        }
        if (string.endsWith("non-connected graph!")) {
            return 2;
        }
        return 3;
    }

    public SpringNodeConstraints getNodeConstraints(LayoutNode springNode) {
        if (!this._nodeConstraints.containsKey(springNode)) {
            throw new IllegalArgumentException("Node " + springNode + " is not managed by this layout");
        }
        return (SpringNodeConstraints)this._nodeConstraints.get(springNode);
    }

    public void removeNodeConstraints(LayoutNode springNode) {
        if (!this._nodeConstraints.containsKey(springNode)) {
            throw new IllegalArgumentException("Node " + springNode + " is not managed by this layout");
        }
        this._nodeConstraints.put(springNode, null);
    }

    public void setNodeConstraints(LayoutNode springNode, SpringNodeConstraints springnodeconstraints) {
        if (!this._nodeConstraints.containsKey(springNode)) {
            throw new IllegalArgumentException("Node " + springNode + " is not managed by this layout");
        }
        this._nodeConstraints.put(springNode, springnodeconstraints);
    }

    public SpringLinkConstraints getLinkConstraints(NodeConnectionModel connectionModel) {
        return (SpringLinkConstraints)this._linkConstraints.get(connectionModel);
    }

    public void removeLinkConstraints(NodeConnectionModel connectionModel) {
        this._linkConstraints.remove(connectionModel);
    }

    public void setLinkConstraints(NodeConnectionModel connectionModel, SpringLinkConstraints springlinkconstraints) {
        this._linkConstraints.put(connectionModel, springlinkconstraints);
    }

    public boolean getAutoEdgeLength() {
        return this._autoEdgeLength;
    }

    public double getEdgeLength() {
        return this._edgeLength;
    }

    public double getEpsilon() {
        return this._epsilon;
    }

    public int getRepaintPeriod() {
        return this._repaintPeriod;
    }

    public boolean getUseObjectsSizes() {
        return this._useObjectsSizes;
    }

    public void setAutoEdgeLength(boolean bool) {
        this._autoEdgeLength = bool;
    }

    public void setEdgeLength(double d) {
        this._edgeLength = d;
    }

    public void setEpsilon(double d) {
        this._epsilon = d;
    }

    public void setRepaintPeriod(int i) {
        this._repaintPeriod = i;
    }

    public void setUseObjectsSizes(boolean bool) {
        this._useObjectsSizes = bool;
    }

    public int getHorizontalAlignment() {
        return this._horizontalAlignment;
    }

    public void setHorizontalAlignment(int i) {
        if (i <= 2) {
            this._horizontalAlignment = i;
        }
    }

    public int getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public void setVerticalAlignment(int i) {
        if (i >= 2) {
            this._verticalAlignment = i;
        }
    }

    public boolean getSpecifyLayoutSize() {
        return this._specifyLayoutSize;
    }

    public void setSpecifyLayoutSize(boolean bool) {
        this._specifyLayoutSize = bool;
    }

    public boolean getAutomaticSingleSpacing() {
        return this._automaticSingleSpacing;
    }

    public void setAutomaticSingleSpacing(boolean bool) {
        this._automaticSingleSpacing = bool;
    }

    public double getLayoutSize() {
        return this._layoutSize;
    }

    public void setLayoutSize(double d) {
        this._layoutSize = d;
    }

    public double getXSpacing() {
        return this._XSpacing;
    }

    public void setXSpacing(double d) {
        this._XSpacing = d;
    }

    public double getYSpacing() {
        return this._YSpacing;
    }

    public void setYSpacing(double d) {
        this._YSpacing = d;
    }

    private void setFinalNodePositions() {
        int i = 0;
        while (i < this.springNodes.length) {
            this.springNodes[i].setFinalPosition();
            ++i;
        }
    }

    public DiagramModelNode getDiagramNode() {
        return this.diagramNode;
    }

    public double getSizeEstimate() {
        double totalArea = 0.0;
        int nNodes = this.springNodes.length;
        double areaFactor = 5.0 + 2.0 * Math.sqrt(nNodes);
        int i = 0;
        while (i < this.springNodes.length) {
            totalArea += this.springNodes[i].getWidth() * this.springNodes[i].getHeight();
            ++i;
        }
        totalArea = areaFactor * totalArea;
        double length = Math.sqrt(totalArea);
        return length;
    }
}

