/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.layout;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.teiid.designer.diagram.ui.layout.DiagramLayout;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;

public class MmColumnLayout
extends DiagramLayout {
    public static final int ERROR_1 = -1;
    public static final int ERROR_2 = -2;
    public static final int ERROR_3 = -3;

    public MmColumnLayout() {
    }

    public MmColumnLayout(List newNodes, int startX, int startY) {
        super(newNodes);
        this.setStartX(startX);
        this.setStartY(startY);
    }

    @Override
    public int run() {
        this.layoutInColumns();
        return 0;
    }

    public void layoutInColumns() {
        block17: {
            int currentNodeID;
            int cid;
            int[] ypt;
            int[] xpt;
            int nColumns;
            int nNodes;
            DiagramModelNode[] nodeArray;
            DiagramModelNode nextNode;
            block18: {
                double totalArea = 0.0;
                double deltaArea = 0.0;
                int minNodeWidth = 9999;
                int minNodeHeight = 9999;
                int maxNodeWidth = 0;
                int maxNodeHeight = 0;
                int layoutWidth = 0;
                int layoutHeight = 0;
                int viewPortWidth = 0;
                int viewPortHeight = 0;
                nextNode = null;
                nodeArray = this.getNodeArray();
                nNodes = nodeArray.length;
                nColumns = 0;
                int i = 0;
                while (i < nodeArray.length) {
                    DiagramModelNode next = nodeArray[i];
                    maxNodeWidth = Math.max(next.getSize().width, maxNodeWidth);
                    maxNodeHeight = Math.max(next.getSize().height, maxNodeHeight);
                    minNodeWidth = Math.min(next.getSize().width, minNodeWidth);
                    minNodeHeight = Math.min(next.getSize().height, minNodeHeight);
                    deltaArea = next.getSize().height * next.getSize().width;
                    totalArea += deltaArea;
                    ++i;
                }
                layoutWidth = (int)Math.sqrt(totalArea * 2.5);
                layoutWidth = layoutHeight = (int)((double)layoutWidth / 1.0);
                viewPortWidth = 800;
                viewPortHeight = 800;
                layoutWidth = Math.max(layoutWidth, viewPortWidth);
                layoutHeight = Math.max(layoutHeight, viewPortHeight);
                nColumns = (int)((double)layoutWidth / ((double)maxNodeWidth + (double)this.getPadding()));
                if (nColumns < 1) {
                    return;
                }
                xpt = new int[nColumns];
                ypt = new int[nColumns];
                cid = 0;
                xpt[0] = this.getStartX();
                ypt[0] = this.getStartY();
                int j = 1;
                while (j < nColumns) {
                    xpt[j] = xpt[j - 1] + maxNodeWidth + this.getPadding();
                    ypt[j] = this.getStartY();
                    ++j;
                }
                currentNodeID = 0;
                if (nColumns < 1) break block17;
                if (nColumns != 1) break block18;
                int i2 = 0;
                while (i2 < nNodes) {
                    nextNode = nodeArray[i2];
                    nextNode.setPosition(new Point(xpt[cid], ypt[cid]));
                    ypt[cid] = ypt[cid] + nextNode.getSize().height + this.getPadding();
                    ++i2;
                }
                break block17;
            }
            currentNodeID = 0;
            int i = 0;
            while (i < nNodes) {
                nextNode = nodeArray[i];
                nextNode.setPosition(new Point(xpt[cid], ypt[cid]));
                ypt[cid] = ypt[cid] + nextNode.getSize().height + this.getPadding();
                currentNodeID = i++;
                if (cid == nColumns - 1) break;
                ++cid;
            }
            cid = 0;
            if (++currentNodeID >= nNodes) break block17;
            i = currentNodeID;
            while (i < nNodes) {
                nextNode = nodeArray[i];
                if (cid == 0) {
                    if (ypt[cid] <= ypt[cid + 1] + 1) {
                        nextNode.setPosition(new Point((double)xpt[cid], (double)ypt[cid]));
                        ypt[cid] = ypt[cid] + nextNode.getSize().height + this.getPadding();
                    } else {
                        nextNode.setPosition(new Point((double)xpt[++cid], (double)ypt[cid]));
                        ypt[cid] = ypt[cid] + nextNode.getSize().height + this.getPadding();
                    }
                } else if (cid == nColumns - 1) {
                    if (ypt[cid] < ypt[cid - 1] - 1) {
                        nextNode.setPosition(new Point((double)xpt[cid], (double)ypt[cid]));
                        ypt[cid] = ypt[cid] + nextNode.getSize().height + this.getPadding();
                    } else {
                        cid = 0;
                        nextNode.setPosition(new Point((double)xpt[cid], (double)ypt[cid]));
                        ypt[cid] = ypt[cid] + nextNode.getSize().height + this.getPadding();
                    }
                } else if (ypt[cid] <= ypt[cid + 1] + 1) {
                    nextNode.setPosition(new Point((double)xpt[cid], (double)ypt[cid]));
                    ypt[cid] = ypt[cid] + nextNode.getSize().height + this.getPadding();
                } else {
                    nextNode.setPosition(new Point((double)xpt[++cid], (double)ypt[cid]));
                    ypt[cid] = ypt[cid] + nextNode.getSize().height + this.getPadding();
                }
                if (cid == nColumns) {
                    cid = 0;
                }
                ++i;
            }
        }
    }
}

