/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.layout;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.teiid.designer.diagram.ui.layout.LayoutNode;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;

public class DefaultLayoutNode
implements LayoutNode {
    private DiagramModelNode modelNode;
    private double thisX;
    private double thisY;
    private double centerX;
    private double centerY;
    private Rectangle bounds;

    public DefaultLayoutNode(DiagramModelNode modelNode) {
        if (modelNode != null) {
            this.modelNode = modelNode;
            this.centerX = modelNode.getCenterX();
            this.centerY = modelNode.getCenterY();
            this.bounds = new Rectangle(0, 0, modelNode.getWidth(), modelNode.getHeight());
        }
    }

    @Override
    public DiagramModelNode getModelNode() {
        return this.modelNode;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setCenterXY(double x, double y) {
        this.centerX = x;
        this.centerY = y;
        this.thisX = this.centerX - this.getWidth() / 2.0;
        this.thisY = this.centerY - this.getHeight() / 2.0;
        this.bounds.setLocation((int)this.thisX, (int)this.thisY);
    }

    @Override
    public void setCenterX(double x) {
        this.centerX = x;
        this.thisX = this.centerX - this.getWidth() / 2.0;
        this.bounds.setLocation((int)this.thisX, (int)this.thisY);
    }

    @Override
    public void setCenterY(double y) {
        this.centerY = y;
        this.thisY = this.centerY - this.getHeight() / 2.0;
        this.bounds.setLocation((int)this.thisX, (int)this.thisY);
    }

    @Override
    public Point getPosition() {
        return new Point(this.thisX, this.thisY);
    }

    @Override
    public void setPosition(Point point) {
        this.thisX = point.x;
        this.thisY = point.y;
        this.setCenterX(this.thisX + this.getWidth() / 2.0);
        this.setCenterY(this.thisY + this.getHeight() / 2.0);
        this.bounds.setLocation(point);
    }

    @Override
    public void setPosition(double x, double y) {
        this.thisX = x;
        this.thisY = y;
        this.setCenterX(this.thisX + this.getWidth() / 2.0);
        this.setCenterY(this.thisY + this.getHeight() / 2.0);
        this.bounds.setLocation((int)this.thisX, (int)this.thisY);
    }

    @Override
    public void setX(double x) {
        this.thisX = x;
        this.setCenterX(this.thisX + this.getWidth() / 2.0);
        this.bounds.setLocation((int)this.thisX, (int)this.thisY);
    }

    @Override
    public void setY(double y) {
        this.thisY = y;
        this.setCenterY(this.thisY + this.getHeight() / 2.0);
        this.bounds.setLocation((int)this.thisX, (int)this.thisY);
    }

    @Override
    public double getX() {
        return this.thisX;
    }

    @Override
    public double getY() {
        return this.thisY;
    }

    @Override
    public double getWidth() {
        return this.bounds.width;
    }

    @Override
    public double getHeight() {
        return this.bounds.height;
    }

    @Override
    public double getCenterX() {
        return this.centerX;
    }

    @Override
    public double getCenterY() {
        return this.centerY;
    }

    @Override
    public void setFinalPosition() {
        this.getModelNode().setCenterXY((int)this.getCenterX(), (int)this.getCenterY());
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }
}

