/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.swt.events.KeyEvent;

public class DiagramKeyHandler
extends KeyHandler {
    private GraphicalViewer viewer;

    public DiagramKeyHandler(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    private boolean isViewerMirrored() {
        return (this.viewer.getControl().getStyle() & 0x8000000) != 0;
    }

    public boolean keyPressed(KeyEvent event) {
        if (!(this.viewer.getControl() instanceof FigureCanvas)) {
            return false;
        }
        FigureCanvas figCanvas = (FigureCanvas)this.viewer.getControl();
        Viewport viewport = figCanvas.getViewport();
        Point location = viewport.getViewLocation();
        Rectangle clientArea = viewport.getClientArea(Rectangle.SINGLETON);
        Rectangle area = clientArea.getCopy().scale(0.1);
        Rectangle pageArea = clientArea.getCopy().scale(0.3);
        switch (event.keyCode) {
            case 0x1000002: {
                figCanvas.scrollToY(location.y + area.height);
                return true;
            }
            case 0x1000006: {
                figCanvas.scrollToY(location.y + pageArea.height);
                return true;
            }
            case 0x1000001: {
                figCanvas.scrollToY(location.y - area.height);
                return true;
            }
            case 0x1000005: {
                figCanvas.scrollToY(location.y - pageArea.height);
                return true;
            }
            case 0x1000003: {
                if (this.isViewerMirrored()) {
                    figCanvas.scrollToX(location.x + area.width);
                } else {
                    figCanvas.scrollToX(location.x - area.width);
                }
                return true;
            }
            case 0x1000004: {
                if (this.isViewerMirrored()) {
                    figCanvas.scrollToX(location.x - area.width);
                } else {
                    figCanvas.scrollToX(location.x + area.width);
                }
                return true;
            }
        }
        return super.keyPressed(event);
    }
}

