/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramGlobalActionsMap;
import org.teiid.designer.diagram.ui.actions.IDiagramActionConstants;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ModelerActionService;
import org.teiid.designer.ui.actions.ModelerGlobalActionsMap;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.AbstractActionService;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public final class DiagramActionService
extends AbstractActionService
implements DiagramUiConstants,
IDiagramActionConstants {
    private static final char DELIMITER = '|';
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DiagramActionService.class);
    private DiagramGlobalActionsMap defaultActionsMap;
    private boolean bHasBeenInitialized;

    public static String constructKey(IAction theAction, ModelEditorPage theEditorPage) {
        return new StringBuffer().append("diagramEditorPage").append('|').append(((IFileEditorInput)theEditorPage.getEditorInput()).getFile().getFullPath()).append('|').append(theAction.getId()).toString();
    }

    public static String constructKey(String theActionId, ModelEditorPage theEditorPage) {
        return new StringBuffer().append("diagramEditorPage").append('|').append(((IFileEditorInput)theEditorPage.getEditorInput()).getFile().getFullPath()).append('|').append(theActionId).toString();
    }

    public DiagramActionService(IWorkbenchPage page) {
        super((AbstractUiPlugin)DiagramUiPlugin.getDefault(), page);
    }

    protected void addNotifyChangedListener(INotifyChangedListener theListener) {
        ModelUtilities.addNotifyChangedListener((INotifyChangedListener)theListener);
    }

    public void contributePermanentActionsToContextMenu(IMenuManager theMenuMgr, ISelection theSelection) {
        super.contributePermanentActionsToContextMenu(theMenuMgr, theSelection);
    }

    public void contributeToContextMenu(IMenuManager theMenuMgr, GlobalActionsMap theActionsMap, ISelection theSelection) {
        DiagramEditor deDiagramEditor = this.getDiagramEditor();
        ISelection selection = null;
        if (deDiagramEditor != null) {
            selection = theSelection == null ? deDiagramEditor.getModelObjectSelectionProvider().getSelection() : theSelection;
            if (!this.bHasBeenInitialized) {
                this.bHasBeenInitialized = true;
                this.initializeGlobalActions();
            }
            this.getModelerActionService().contributeToContextMenu(theMenuMgr, theActionsMap, selection);
            MenuManager smNotationSubmenu = deDiagramEditor.getNotationActionGroup();
            if (smNotationSubmenu != null && !smNotationSubmenu.isEmpty()) {
                theMenuMgr.add((IContributionItem)new GroupMarker("notationStart"));
                theMenuMgr.insertAfter("notationStart", (IContributionItem)smNotationSubmenu);
                theMenuMgr.add((IContributionItem)new GroupMarker("notationEnd"));
            }
        }
    }

    public IAction getAction(String theActionId) throws CoreException {
        IAction action;
        if (!this.bHasBeenInitialized) {
            this.bHasBeenInitialized = true;
            this.initializeGlobalActions();
        }
        if ((action = this.defaultActionsMap.getAction(theActionId)) != null) {
            return action;
        }
        return super.getAction(this.getActionId(theActionId));
    }

    private String getActionId(String theKey) {
        String result = theKey;
        if (this.getModelerActionService().getActionId(theKey) != null) {
            result = this.getModelerActionService().getActionId(theKey);
        }
        return result;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = this.getPlugin().getCurrentWorkbenchWindow().getActivePage();
        IEditorPart editor = activePage != null ? activePage.getActiveEditor() : this.getPage().getActiveEditor();
        if (editor instanceof ModelEditor) {
            return editor;
        }
        return null;
    }

    public IAction getDefaultAction(String theActionId) {
        try {
            return UiPlugin.getDefault().getActionService(this.getWorkbenchWindow().getActivePage()).getAction(theActionId);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private DiagramEditor getDiagramEditor() {
        IEditorPart editor = this.getActiveEditor();
        ModelEditor meEditor = (ModelEditor)editor;
        if (meEditor.getCurrentPage() instanceof DiagramEditor) {
            return (DiagramEditor)meEditor.getCurrentPage();
        }
        return null;
    }

    public ModelerActionService getModelerActionService() {
        return (ModelerActionService)UiPlugin.getDefault().getActionService(this.getPage());
    }

    private void initializeGlobalActions() {
        IAction action = null;
        this.defaultActionsMap = new DiagramGlobalActionsMap();
        String[] stringArray = DiagramGlobalActionsMap.ALL_DIAGRAM_GLOBAL_ACTIONS;
        int n = DiagramGlobalActionsMap.ALL_DIAGRAM_GLOBAL_ACTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String actionId = stringArray[n2];
            try {
                action = GlobalActionsMap.isEclipseGlobalAction((String)actionId) || ModelerGlobalActionsMap.isModelerGlobalAction((String)actionId) ? this.getModelerActionService().getAction(actionId) : this.getAction(actionId);
                this.defaultActionsMap.put(actionId, action);
            }
            catch (CoreException e) {
                String message = DiagramUiConstants.Util.getString(String.valueOf(PREFIX) + "actionErrorMessage", (Object)actionId);
                DiagramUiConstants.Util.log(4, (Throwable)e, message);
            }
            ++n2;
        }
    }

    public boolean isRegistered(String theActionId) {
        if (!this.bHasBeenInitialized) {
            this.bHasBeenInitialized = true;
            this.initializeGlobalActions();
        }
        return super.isRegistered(theActionId);
    }

    protected void registerEventHandler(IAction theAction) {
        super.registerEventHandler(theAction);
        if (theAction instanceof INotifyChangedListener) {
            this.addNotifyChangedListener((INotifyChangedListener)theAction);
        }
    }

    public void removeNotifyChangedListener(INotifyChangedListener theListener) {
        ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)theListener);
    }

    public void removePartListener(IPartListener theListener) {
        super.removePartListener(theListener);
    }

    protected void unregisterEventHandler(IAction theAction) {
        super.unregisterEventHandler(theAction);
        if (theAction instanceof INotifyChangedListener) {
            this.removeNotifyChangedListener((INotifyChangedListener)theAction);
        }
        if (theAction instanceof IPartListener) {
            this.removePartListener((IPartListener)theAction);
        }
    }
}

