/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.actions.ActionWrapper;
import org.teiid.designer.diagram.ui.actions.AutoLayout;
import org.teiid.designer.diagram.ui.actions.AutoLayoutAction;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.actions.IDiagramActionConstants;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.ui.editors.ModelEditor;

public class AutoLayoutWrapper
extends DiagramAction
implements DiagramUiConstants,
IDiagramActionConstants,
IPartListener,
ActionWrapper {
    public AutoLayoutWrapper() {
        this.initialize();
    }

    public AutoLayoutWrapper(int theStyle) {
        super(theStyle);
        this.initialize();
    }

    @Override
    public void initialize() {
        this.setEnableState();
        this.addAsPartListener();
    }

    @Override
    protected void doRun() {
        ModelEditor editor = this.getActiveEditor();
        if (editor != null) {
            AutoLayout autoLayoutMgr = this.getAutoLayoutManager();
            AutoLayoutAction action = new AutoLayoutAction(autoLayoutMgr);
            action.run();
            this.setEnabled(autoLayoutMgr.canAutoLayout());
        }
    }

    private void addAsPartListener() {
        this.getPlugin().getCurrentWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    public void dispose() {
        this.getPlugin().getCurrentWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
    }

    private AutoLayout getAutoLayoutManager() {
        ModelEditor editor = this.getActiveEditor();
        if (editor != null && editor.getCurrentPage() instanceof DiagramEditor) {
            DiagramEditor deEditorPage = (DiagramEditor)editor.getCurrentPage();
            if (deEditorPage != null) {
                AutoLayout autoLayoutMgr = (AutoLayout)deEditorPage.getAdapter(AutoLayout.class);
                return autoLayoutMgr;
            }
            return null;
        }
        return null;
    }

    public void setEnableState() {
        ModelEditor editor = this.getActiveEditor();
        if (editor != null && editor.getCurrentPage() instanceof DiagramEditor) {
            AutoLayout autoLayoutMgr = this.getAutoLayoutManager();
            if (autoLayoutMgr != null) {
                this.setEnabled(autoLayoutMgr.canAutoLayout());
            } else {
                this.setEnabled(false);
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.setEnableState();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.setEnableState();
    }

    public void partClosed(IWorkbenchPart part) {
        this.setEnabled(false);
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.setEnabled(false);
    }

    public void partOpened(IWorkbenchPart part) {
        this.setEnableState();
    }
}

