/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import org.apache.camel.LoggingLevel;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;
import org.fusesource.ide.commons.properties.EnumPropertyDescriptor;

public class Log
extends AbstractNode {
    public static final String PROPERTY_MESSAGE = "Log.Message";
    public static final String PROPERTY_LOGGINGLEVEL = "Log.LoggingLevel";
    public static final String PROPERTY_LOGNAME = "Log.LogName";
    public static final String PROPERTY_MARKER = "Log.Marker";
    public static final String PROPERTY_LOGGERREF = "Log.LoggerRef";
    private String message;
    private LoggingLevel loggingLevel;
    private String logName;
    private String marker;
    private String loggerRef;

    public Log() {
    }

    public Log(LogDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "log.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "logEIP";
    }

    @Override
    public String getCategoryName() {
        return "Components";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldValue = this.message;
        this.message = message;
        if (!this.isSame(oldValue, message)) {
            this.firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
        }
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        LoggingLevel oldValue = this.loggingLevel;
        this.loggingLevel = loggingLevel;
        if (!this.isSame(oldValue, loggingLevel)) {
            this.firePropertyChange(PROPERTY_LOGGINGLEVEL, oldValue, loggingLevel);
        }
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        String oldValue = this.logName;
        this.logName = logName;
        if (!this.isSame(oldValue, logName)) {
            this.firePropertyChange(PROPERTY_LOGNAME, oldValue, logName);
        }
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        String oldValue = this.marker;
        this.marker = marker;
        if (!this.isSame(oldValue, marker)) {
            this.firePropertyChange(PROPERTY_MARKER, oldValue, marker);
        }
    }

    public String getLoggerRef() {
        return this.loggerRef;
    }

    public void setLoggerRef(String loggerRef) {
        String oldValue = this.loggerRef;
        this.loggerRef = loggerRef;
        if (!this.isSame(oldValue, loggerRef)) {
            this.firePropertyChange(PROPERTY_LOGGERREF, oldValue, loggerRef);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descMessage = new TextPropertyDescriptor((Object)PROPERTY_MESSAGE, Messages.propertyLabelLogMessage);
        EnumPropertyDescriptor descLoggingLevel = new EnumPropertyDescriptor((Object)PROPERTY_LOGGINGLEVEL, Messages.propertyLabelLogLoggingLevel, LoggingLevel.class);
        TextPropertyDescriptor descLogName = new TextPropertyDescriptor((Object)PROPERTY_LOGNAME, Messages.propertyLabelLogLogName);
        TextPropertyDescriptor descMarker = new TextPropertyDescriptor((Object)PROPERTY_MARKER, Messages.propertyLabelLogMarker);
        TextPropertyDescriptor descLoggerRef = new TextPropertyDescriptor((Object)PROPERTY_LOGGERREF, Messages.propertyLabelLogLoggerRef);
        descriptors.put(PROPERTY_MESSAGE, (PropertyDescriptor)descMessage);
        descriptors.put(PROPERTY_LOGGINGLEVEL, (PropertyDescriptor)descLoggingLevel);
        descriptors.put(PROPERTY_LOGNAME, (PropertyDescriptor)descLogName);
        descriptors.put(PROPERTY_MARKER, (PropertyDescriptor)descMarker);
        descriptors.put(PROPERTY_LOGGERREF, (PropertyDescriptor)descLoggerRef);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_MESSAGE.equals(id)) {
            this.setMessage(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_LOGGINGLEVEL.equals(id)) {
            this.setLoggingLevel(Objects.convertTo(value, LoggingLevel.class));
            return;
        }
        if (PROPERTY_LOGNAME.equals(id)) {
            this.setLogName(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_MARKER.equals(id)) {
            this.setMarker(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_LOGGERREF.equals(id)) {
            this.setLoggerRef(Objects.convertTo(value, String.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_MESSAGE.equals(id)) {
            return this.getMessage();
        }
        if (PROPERTY_LOGGINGLEVEL.equals(id)) {
            return this.getLoggingLevel();
        }
        if (PROPERTY_LOGNAME.equals(id)) {
            return this.getLogName();
        }
        if (PROPERTY_MARKER.equals(id)) {
            return this.getMarker();
        }
        if (PROPERTY_LOGGERREF.equals(id)) {
            return this.getLoggerRef();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        LogDefinition answer = new LogDefinition();
        answer.setMessage(this.toXmlPropertyValue(PROPERTY_MESSAGE, this.getMessage()));
        answer.setLoggingLevel(this.toXmlPropertyValue(PROPERTY_LOGGINGLEVEL, this.getLoggingLevel()));
        answer.setLogName(this.toXmlPropertyValue(PROPERTY_LOGNAME, this.getLogName()));
        answer.setMarker(this.toXmlPropertyValue(PROPERTY_MARKER, this.getMarker()));
        answer.setLoggerRef(this.toXmlPropertyValue(PROPERTY_LOGGERREF, this.getLoggerRef()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return LogDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof LogDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof LogDefinition. Was " + processor.getClass().getName());
        }
        LogDefinition node = (LogDefinition)processor;
        this.setMessage(node.getMessage());
        this.setLoggingLevel(node.getLoggingLevel());
        this.setLogName(node.getLogName());
        this.setMarker(node.getMarker());
        this.setLoggerRef(node.getLoggerRef());
    }
}

