/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.ExpressionPropertyDescriptor;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;
import org.fusesource.ide.commons.properties.BooleanPropertyDescriptor;

public class IdempotentConsumer
extends AbstractNode {
    public static final String PROPERTY_EXPRESSION = "IdempotentConsumer.Expression";
    public static final String PROPERTY_MESSAGEIDREPOSITORYREF = "IdempotentConsumer.MessageIdRepositoryRef";
    public static final String PROPERTY_EAGER = "IdempotentConsumer.Eager";
    public static final String PROPERTY_SKIPDUPLICATE = "IdempotentConsumer.SkipDuplicate";
    public static final String PROPERTY_REMOVEONFAILURE = "IdempotentConsumer.RemoveOnFailure";
    private ExpressionDefinition expression;
    private String messageIdRepositoryRef;
    private Boolean eager;
    private Boolean skipDuplicate;
    private Boolean removeOnFailure;

    public IdempotentConsumer() {
    }

    public IdempotentConsumer(IdempotentConsumerDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "idempotentConsumer.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "idempotentConsumer";
    }

    @Override
    public String getCategoryName() {
        return "Routing";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        ExpressionDefinition oldValue = this.expression;
        this.expression = expression;
        if (!this.isSame(oldValue, expression)) {
            this.firePropertyChange(PROPERTY_EXPRESSION, oldValue, expression);
        }
    }

    public String getMessageIdRepositoryRef() {
        return this.messageIdRepositoryRef;
    }

    public void setMessageIdRepositoryRef(String messageIdRepositoryRef) {
        String oldValue = this.messageIdRepositoryRef;
        this.messageIdRepositoryRef = messageIdRepositoryRef;
        if (!this.isSame(oldValue, messageIdRepositoryRef)) {
            this.firePropertyChange(PROPERTY_MESSAGEIDREPOSITORYREF, oldValue, messageIdRepositoryRef);
        }
    }

    public Boolean getEager() {
        return this.eager;
    }

    public void setEager(Boolean eager) {
        Boolean oldValue = this.eager;
        this.eager = eager;
        if (!this.isSame(oldValue, eager)) {
            this.firePropertyChange(PROPERTY_EAGER, oldValue, eager);
        }
    }

    public Boolean getSkipDuplicate() {
        return this.skipDuplicate;
    }

    public void setSkipDuplicate(Boolean skipDuplicate) {
        Boolean oldValue = this.skipDuplicate;
        this.skipDuplicate = skipDuplicate;
        if (!this.isSame(oldValue, skipDuplicate)) {
            this.firePropertyChange(PROPERTY_SKIPDUPLICATE, oldValue, skipDuplicate);
        }
    }

    public Boolean getRemoveOnFailure() {
        return this.removeOnFailure;
    }

    public void setRemoveOnFailure(Boolean removeOnFailure) {
        Boolean oldValue = this.removeOnFailure;
        this.removeOnFailure = removeOnFailure;
        if (!this.isSame(oldValue, removeOnFailure)) {
            this.firePropertyChange(PROPERTY_REMOVEONFAILURE, oldValue, removeOnFailure);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        ExpressionPropertyDescriptor descExpression = new ExpressionPropertyDescriptor(PROPERTY_EXPRESSION, Messages.propertyLabelIdempotentConsumerExpression);
        TextPropertyDescriptor descMessageIdRepositoryRef = new TextPropertyDescriptor((Object)PROPERTY_MESSAGEIDREPOSITORYREF, Messages.propertyLabelIdempotentConsumerMessageIdRepositoryRef);
        BooleanPropertyDescriptor descEager = new BooleanPropertyDescriptor((Object)PROPERTY_EAGER, Messages.propertyLabelIdempotentConsumerEager);
        BooleanPropertyDescriptor descSkipDuplicate = new BooleanPropertyDescriptor((Object)PROPERTY_SKIPDUPLICATE, Messages.propertyLabelIdempotentConsumerSkipDuplicate);
        BooleanPropertyDescriptor descRemoveOnFailure = new BooleanPropertyDescriptor((Object)PROPERTY_REMOVEONFAILURE, Messages.propertyLabelIdempotentConsumerRemoveOnFailure);
        descriptors.put(PROPERTY_EXPRESSION, descExpression);
        descriptors.put(PROPERTY_MESSAGEIDREPOSITORYREF, (PropertyDescriptor)descMessageIdRepositoryRef);
        descriptors.put(PROPERTY_EAGER, (PropertyDescriptor)descEager);
        descriptors.put(PROPERTY_SKIPDUPLICATE, (PropertyDescriptor)descSkipDuplicate);
        descriptors.put(PROPERTY_REMOVEONFAILURE, (PropertyDescriptor)descRemoveOnFailure);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            this.setExpression(Objects.convertTo(value, ExpressionDefinition.class));
            return;
        }
        if (PROPERTY_MESSAGEIDREPOSITORYREF.equals(id)) {
            this.setMessageIdRepositoryRef(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_EAGER.equals(id)) {
            this.setEager(Objects.convertTo(value, Boolean.class));
            return;
        }
        if (PROPERTY_SKIPDUPLICATE.equals(id)) {
            this.setSkipDuplicate(Objects.convertTo(value, Boolean.class));
            return;
        }
        if (PROPERTY_REMOVEONFAILURE.equals(id)) {
            this.setRemoveOnFailure(Objects.convertTo(value, Boolean.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            return this.getExpression();
        }
        if (PROPERTY_MESSAGEIDREPOSITORYREF.equals(id)) {
            return this.getMessageIdRepositoryRef();
        }
        if (PROPERTY_EAGER.equals(id)) {
            return this.getEager();
        }
        if (PROPERTY_SKIPDUPLICATE.equals(id)) {
            return this.getSkipDuplicate();
        }
        if (PROPERTY_REMOVEONFAILURE.equals(id)) {
            return this.getRemoveOnFailure();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition();
        answer.setExpression(this.toXmlPropertyValue(PROPERTY_EXPRESSION, this.getExpression()));
        answer.setMessageIdRepositoryRef(this.toXmlPropertyValue(PROPERTY_MESSAGEIDREPOSITORYREF, this.getMessageIdRepositoryRef()));
        answer.setEager(this.toXmlPropertyValue(PROPERTY_EAGER, this.getEager()));
        answer.setSkipDuplicate(this.toXmlPropertyValue(PROPERTY_SKIPDUPLICATE, this.getSkipDuplicate()));
        answer.setRemoveOnFailure(this.toXmlPropertyValue(PROPERTY_REMOVEONFAILURE, this.getRemoveOnFailure()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return IdempotentConsumerDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof IdempotentConsumerDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof IdempotentConsumerDefinition. Was " + processor.getClass().getName());
        }
        IdempotentConsumerDefinition node = (IdempotentConsumerDefinition)processor;
        this.setExpression(node.getExpression());
        this.setMessageIdRepositoryRef(node.getMessageIdRepositoryRef());
        this.setEager(node.getEager());
        this.setSkipDuplicate(node.getSkipDuplicate());
        this.setRemoveOnFailure(node.getRemoveOnFailure());
    }
}

