/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.eclipse.draw2d.geometry.Rectangle;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.Activator;
import org.fusesource.ide.camel.model.CamelModelHelper;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.NodeFactory;
import org.fusesource.ide.commons.camel.tools.BeanDef;

public abstract class RouteSupport
extends RouteContainer {
    public static final int DEFAULT_ROUTE_HEIGHT = 250;
    public static final int DEFAULT_ROUTE_WIDTH = 400;
    private Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
    private static final String ICON = "route.png";

    public RouteSupport() {
        this.init();
    }

    public RouteSupport(RouteDefinition definition, RouteContainer parent) {
        super(parent);
        this.init();
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String[] getEndpointUris() {
        RouteContainer parent = this.getParent();
        if (parent != null) {
            return parent.getEndpointUris();
        }
        return super.getEndpointUris();
    }

    @Override
    public Map<String, BeanDef> getBeans() {
        RouteContainer parent = this.getParent();
        if (parent != null) {
            return parent.getBeans();
        }
        return super.getBeans();
    }

    private void init() {
        this.setLayout(new Rectangle(0, 0, 400, 250));
    }

    @Override
    public String getDocumentationFileName() {
        return "route";
    }

    @Override
    public String getIconName() {
        return ICON;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return RouteDefinition.class;
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        RouteDefinition answer = new RouteDefinition();
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    public RouteDefinition createRouteDefinition() {
        ArrayList<AbstractNode> processedNodes = new ArrayList<AbstractNode>();
        RouteDefinition answer = (RouteDefinition)this.createCamelDefinition();
        List<AbstractNode> list = this.getRootNodes();
        for (AbstractNode node : list) {
            if (node instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)node;
                FromDefinition from = new FromDefinition();
                CamelModelHelper.setUri(from, endpoint);
                CamelModelHelper.setId(from, endpoint);
                CamelModelHelper.setDescription(from, endpoint);
                this.resetCustomId((OptionalIdentifiedDefinition)from);
                answer.getInputs().add(from);
                endpoint.populateCamelDefinition(from);
                if (processedNodes.contains(node)) continue;
                endpoint.saveChildrenToCamelDefinitions((ProcessorDefinition)answer, processedNodes);
                processedNodes.add(node);
                continue;
            }
            Activator.getLogger().warning(node + " is not connected to anything!");
        }
        return answer;
    }

    public List<AbstractNode> getRootNodes() {
        ArrayList<AbstractNode> answer = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.getChildren();
        for (AbstractNode node : list) {
            if (!node.isNotTarget()) continue;
            answer.add(node);
        }
        return answer;
    }

    @Override
    protected void loadChildrenFromCamelDefinition(ProcessorDefinition processor) {
        RouteDefinition routeDef = (RouteDefinition)processor;
        List inputs = routeDef.getInputs();
        List outputs = processor.getOutputs();
        AbstractNode parent = null;
        AbstractNode lastNode = null;
        for (ProcessorDefinition childProcessor : outputs) {
            AbstractNode node = NodeFactory.createNode(childProcessor, this);
            if (parent == null) {
                if (lastNode == null) {
                    for (FromDefinition input : inputs) {
                        Endpoint endpoint = this.getOrCreateEndpoint(input);
                        endpoint.addTargetNode(node);
                    }
                } else {
                    lastNode.addTargetNodeAsLastStep(node);
                }
            } else {
                parent.addTargetNode(node);
            }
            if (!this.isMulticastNode(parent, node) && node.isNextSiblingStepAddedAsNodeChild()) {
                parent = node;
            }
            lastNode = node;
        }
    }

    private String generateEndpointKey(String uri, String id) {
        String part1 = uri == null || uri.trim().length() < 1 ? UUID.randomUUID().toString() : uri;
        String part2 = id == null || id.trim().length() < 1 ? UUID.randomUUID().toString() : id;
        return String.format("%s$%s", part1, part2);
    }

    protected Endpoint getOrCreateEndpoint(FromDefinition input) {
        String key = this.generateEndpointKey(CamelModelHelper.getUri(input), input.getId());
        Endpoint answer = this.findEndpoint(key);
        if (answer == null) {
            answer = new Endpoint(input, (RouteContainer)this);
            this.endpoints.put(key, answer);
        }
        return answer;
    }

    public Endpoint findEndpoint(String uri) {
        return this.endpoints.get(uri);
    }

    public Endpoint getOrCreateEndpoint(ToDefinition definition, RouteContainer parent) {
        String key = this.generateEndpointKey(definition.getUri(), definition.getId());
        Endpoint answer = this.findEndpoint(key);
        if (answer != null && answer.getOutputs().size() > 0) {
            answer = null;
        }
        if (answer == null) {
            answer = new Endpoint(definition, parent);
            this.endpoints.put(key, answer);
        }
        return answer;
    }

    @Override
    public void clearResources() {
        super.clearResources();
        List<AbstractNode> children = this.getRootNodes();
        for (AbstractNode node : children) {
            node.clearResources();
        }
    }
}

