/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model;

import org.apache.camel.ExchangePattern;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ToDefinition;
import org.fusesource.ide.camel.model.Activator;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.commons.util.Strings;

public class CamelModelHelper {
    public static String getDefaultLanguageName() {
        String answer = Activator.getDefault().getPreferenceStore().getString("defaultLanguagePreference");
        if (Strings.isBlank((String)answer)) {
            return "simple";
        }
        return answer;
    }

    public static boolean isPropertyListOFSetHeaders(Object id) {
        return Objects.equal((Object)"WireTap.Headers", (Object)id);
    }

    public static String getUri(FromDefinition input) {
        String ref;
        String key = input.getUri();
        if (Strings.isBlank((String)key) && !Strings.isBlank((String)(ref = input.getRef()))) {
            return "ref:" + ref;
        }
        return key;
    }

    public static String getUri(ToDefinition input) {
        String ref;
        String key = input.getUri();
        if (Strings.isBlank((String)key) && !Strings.isBlank((String)(ref = input.getRef()))) {
            return "ref:" + ref;
        }
        return key;
    }

    public static void setUri(FromDefinition node, Endpoint endpoint) {
        String value = endpoint.getUri();
        if (value != null && value.startsWith("ref:")) {
            node.setRef(value.substring(4));
        } else {
            node.setUri(value);
        }
    }

    public static void setUri(ToDefinition node, Endpoint endpoint) {
        String value = endpoint.getUri();
        if (value != null && value.startsWith("ref:")) {
            node.setRef(value.substring(4));
        } else {
            node.setUri(value);
        }
    }

    public static String getExchangePattern(ToDefinition input) {
        String pattern;
        String string = pattern = input.getPattern() != null ? input.getPattern().name() : null;
        if (Strings.isBlank((String)pattern)) {
            return null;
        }
        return pattern;
    }

    public static void setExchangePattern(ToDefinition node, Endpoint endpoint) {
        String value = endpoint.getPattern();
        if (value != null && value.trim().length() > 0) {
            node.setPattern(ExchangePattern.asEnum((String)value));
        } else {
            node.setPattern(null);
        }
    }

    public static void setId(FromDefinition node, Endpoint endpoint) {
        String value = endpoint.getId();
        if (value != null && value.trim().length() > 0) {
            node.setId(value);
        }
    }

    public static void setDescription(FromDefinition node, Endpoint endpoint) {
        String value = endpoint.getId();
        if (value != null && value.trim().length() > 0) {
            DescriptionDefinition dd = new DescriptionDefinition();
            dd.setText(endpoint.getDescription());
            node.setDescription(dd);
        }
    }

    public static boolean isMockEndpointURI(String value) {
        return value.startsWith("mock:");
    }

    public static boolean isTimerEndpointURI(String value) {
        return value.startsWith("timer:") || value.startsWith("quartz:");
    }
}

