/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.soa.sca.sca1_1.model.sca.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.soa.sca.core.model.addressing.AddressingFactory;
import org.eclipse.soa.sca.core.model.addressing.AddressingPackage;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.soa.sca.sca1_1.model.sca.Composite} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class CompositeItemProvider
	extends CommonExtensionBaseItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
     * This constructs an instance from a factory and a notifier.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public CompositeItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

	/**
     * This returns the property descriptors for the adapted class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);

            addAutowirePropertyDescriptor(object);
            addConstrainingTypePropertyDescriptor(object);
            addLocalPropertyDescriptor(object);
            addNamePropertyDescriptor(object);
            addPolicySetsPropertyDescriptor(object);
            addRequiresPropertyDescriptor(object);
            addTargetNamespacePropertyDescriptor(object);
        }
        return itemPropertyDescriptors;
    }

	/**
     * This adds a property descriptor for the Autowire feature.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected void addAutowirePropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (createItemPropertyDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_Composite_autowire_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_Composite_autowire_feature", "_UI_Composite_type"),
                 ScaPackage.eINSTANCE.getComposite_Autowire(),
                 true,
                 false,
                 false,
                 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
     * This adds a property descriptor for the Constraining Type feature.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected void addConstrainingTypePropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (createItemPropertyDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_Composite_constrainingType_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_Composite_constrainingType_feature", "_UI_Composite_type"),
                 ScaPackage.eINSTANCE.getComposite_ConstrainingType(),
                 true,
                 false,
                 false,
                 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
     * This adds a property descriptor for the Local feature.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected void addLocalPropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (createItemPropertyDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_Composite_local_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_Composite_local_feature", "_UI_Composite_type"),
                 ScaPackage.eINSTANCE.getComposite_Local(),
                 true,
                 false,
                 false,
                 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
     * This adds a property descriptor for the Name feature.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected void addNamePropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (createItemPropertyDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_Composite_name_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_Composite_name_feature", "_UI_Composite_type"),
                 ScaPackage.eINSTANCE.getComposite_Name(),
                 true,
                 false,
                 false,
                 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
     * This adds a property descriptor for the Policy Sets feature.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected void addPolicySetsPropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (createItemPropertyDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_Composite_policySets_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_Composite_policySets_feature", "_UI_Composite_type"),
                 ScaPackage.eINSTANCE.getComposite_PolicySets(),
                 true,
                 false,
                 false,
                 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
     * This adds a property descriptor for the Requires feature.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected void addRequiresPropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (createItemPropertyDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_Composite_requires_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_Composite_requires_feature", "_UI_Composite_type"),
                 ScaPackage.eINSTANCE.getComposite_Requires(),
                 true,
                 false,
                 false,
                 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
     * This adds a property descriptor for the Target Namespace feature.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected void addTargetNamespacePropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (createItemPropertyDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_Composite_targetNamespace_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_Composite_targetNamespace_feature", "_UI_Composite_type"),
                 ScaPackage.eINSTANCE.getComposite_TargetNamespace(),
                 true,
                 false,
                 false,
                 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
     * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
     * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
     * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (childrenFeatures == null) {
            super.getChildrenFeatures(object);
            childrenFeatures.add(ScaPackage.eINSTANCE.getComposite_Include());
            childrenFeatures.add(ScaPackage.eINSTANCE.getComposite_Group());
            childrenFeatures.add(ScaPackage.eINSTANCE.getComposite_Any());
        }
        return childrenFeatures;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
        // Check the type of the specified child object and return the proper feature to use for
        // adding (see {@link AddCommand}) it as a child.

        return super.getChildFeature(object, child);
    }

	/**
     * This returns Composite.gif.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object getImage(Object object) {
        return overlayImage(object, getResourceLocator().getImage("full/obj16/Composite"));
    }

	/**
     * This returns the label text for the adapted class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String getText(Object object) {
        String label = ((Composite)object).getName();
        return label == null || label.length() == 0 ?
            getString("_UI_Composite_type") :
            getString("_UI_Composite_type") + " " + label;
    }

	/**
     * This handles model notifications by calling {@link #updateChildren} to update any cached
     * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void notifyChanged(Notification notification) {
        updateChildren(notification);

        switch (notification.getFeatureID(Composite.class)) {
            case ScaPackage.COMPOSITE__AUTOWIRE:
            case ScaPackage.COMPOSITE__CONSTRAINING_TYPE:
            case ScaPackage.COMPOSITE__LOCAL:
            case ScaPackage.COMPOSITE__NAME:
            case ScaPackage.COMPOSITE__POLICY_SETS:
            case ScaPackage.COMPOSITE__REQUIRES:
            case ScaPackage.COMPOSITE__TARGET_NAMESPACE:
                fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            case ScaPackage.COMPOSITE__INCLUDE:
            case ScaPackage.COMPOSITE__GROUP:
            case ScaPackage.COMPOSITE__ANY:
                fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
        }
        super.notifyChanged(notification);
    }

	/**
     * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
     * that can be created under this object.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);

        newChildDescriptors.add
            (createChildParameter
                (ScaPackage.eINSTANCE.getComposite_Include(),
                 ScaFactory.eINSTANCE.createInclude()));

        newChildDescriptors.add
            (createChildParameter
                (ScaPackage.eINSTANCE.getComposite_Group(),
                 FeatureMapUtil.createEntry
                    (ScaPackage.eINSTANCE.getComposite_Service(),
                     ScaFactory.eINSTANCE.createService())));

        newChildDescriptors.add
            (createChildParameter
                (ScaPackage.eINSTANCE.getComposite_Group(),
                 FeatureMapUtil.createEntry
                    (ScaPackage.eINSTANCE.getComposite_Property(),
                     ScaFactory.eINSTANCE.createProperty())));

        newChildDescriptors.add
            (createChildParameter
                (ScaPackage.eINSTANCE.getComposite_Group(),
                 FeatureMapUtil.createEntry
                    (ScaPackage.eINSTANCE.getComposite_Property(),
                     ScaFactory.eINSTANCE.createConstrainingProperty())));

        newChildDescriptors.add
            (createChildParameter
                (ScaPackage.eINSTANCE.getComposite_Group(),
                 FeatureMapUtil.createEntry
                    (ScaPackage.eINSTANCE.getComposite_Component(),
                     ScaFactory.eINSTANCE.createComponent())));

        newChildDescriptors.add
            (createChildParameter
                (ScaPackage.eINSTANCE.getComposite_Group(),
                 FeatureMapUtil.createEntry
                    (ScaPackage.eINSTANCE.getComposite_Reference(),
                     ScaFactory.eINSTANCE.createReference())));

        newChildDescriptors.add
            (createChildParameter
                (ScaPackage.eINSTANCE.getComposite_Group(),
                 FeatureMapUtil.createEntry
                    (ScaPackage.eINSTANCE.getComposite_Wire(),
                     ScaFactory.eINSTANCE.createWire())));
    }

}
