/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.transform;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SmooksTransformType implements Enumerator
{
    SMOOKS(0, "SMOOKS", "SMOOKS"),
    XML2JAVA(1, "XML2JAVA", "XML2JAVA"),
    JAVA2XML(2, "JAVA2XML", "JAVA2XML");

    public static final int SMOOKS_VALUE = 0;
    public static final int XML2JAVA_VALUE = 1;
    public static final int JAVA2XML_VALUE = 2;
    private static final SmooksTransformType[] VALUES_ARRAY;
    public static final List<SmooksTransformType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SmooksTransformType[]{SMOOKS, XML2JAVA, JAVA2XML};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SmooksTransformType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SmooksTransformType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SmooksTransformType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SmooksTransformType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SmooksTransformType get(int value) {
        switch (value) {
            case 0: {
                return SMOOKS;
            }
            case 1: {
                return XML2JAVA;
            }
            case 2: {
                return JAVA2XML;
            }
        }
        return null;
    }

    private SmooksTransformType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

