/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common.impl;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewInterfaceWizardAction;
import org.eclipse.jdt.ui.wizards.NewInterfaceWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.common.IInterfaceControlAdapter;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.wizards.WSDL2JavaWizard;

public class JavaInterfaceControlAdapter
implements IInterfaceControlAdapter {
    private JavaInterface _interface = ScaFactory.eINSTANCE.createJavaInterface();
    private Interface _related;

    @Override
    public Interface getInterface() {
        return this._interface;
    }

    @Override
    public void setRelatedInterface(Interface related) {
        this._related = related;
    }

    @Override
    public void init(Interface intf) {
        String typeString = intf == null ? null : ((JavaInterface)intf).getInterface();
        this._interface = ScaFactory.eINSTANCE.createJavaInterface();
        this._interface.setInterface(typeString);
    }

    @Override
    public boolean browse(Shell shell, IJavaElement element) {
        IJavaSearchScope scope = element == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element});
        try {
            Object[] result;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)scope, (int)4, (boolean)false, (String)(this._interface.getInterface() == null ? "*Service" : this._interface.getInterface()));
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IType) {
                IType type = (IType)result[0];
                this._interface.setInterface(type.getFullyQualifiedName());
                return true;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean open(Shell shell, IJavaProject project, boolean useRelated) {
        if (useRelated && this._related instanceof WSDLPortType) {
            return this.openWSDL2JavaWizard(shell, project);
        }
        return this.openNewJavaInterfaceWizard(shell, project);
    }

    private boolean openNewJavaInterfaceWizard(Shell shell, IJavaProject project) {
        IJavaElement initialJavaElement = JavaUtil.getInitialPackageForProject(project);
        StructuredSelection selectionToPass = initialJavaElement == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)initialJavaElement);
        OpenNewInterfaceWizardAction action = new OpenNewInterfaceWizardAction();
        action.setSelection((IStructuredSelection)selectionToPass);
        action.setOpenEditorOnFinish(false);
        NewInterfaceWizardPage page = new NewInterfaceWizardPage();
        page.init((IStructuredSelection)selectionToPass);
        action.setConfiguredWizardPage(page);
        action.run();
        IJavaElement createdElement = action.getCreatedElement();
        if (createdElement != null && createdElement instanceof IType) {
            IType type = (IType)createdElement;
            this._interface.setInterface(type.getFullyQualifiedName());
            return true;
        }
        return false;
    }

    private boolean openWSDL2JavaWizard(Shell shell, IJavaProject project) {
        WSDL2JavaWizard newWizard = new WSDL2JavaWizard();
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)newWizard);
        newWizard.init(PlatformUI.getWorkbench(), this.getResourceForInterface((WSDLPortType)this._related));
        if (dialog.open() == 0) {
            return this.browse(shell, (IJavaElement)newWizard.getOutputPackage());
        }
        return false;
    }

    private IStructuredSelection getResourceForInterface(WSDLPortType wsdlIntf) {
        IResource file = (IResource)Platform.getAdapterManager().loadAdapter((Object)wsdlIntf, IResource.class.getCanonicalName());
        if (file == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)file);
    }

    @Override
    public String getText() {
        if (this._interface.getInterface() == null) {
            return "";
        }
        return this._interface.getInterface();
    }

    @Override
    public IStatus validate(IJavaProject project) {
        if (this._interface.getInterface() == null) {
            return new Status(4, "org.switchyard.tools.ui", Messages.JavaInterfaceControlAdapter_statusMessage_selectJavaInterface);
        }
        if (SwitchYardModelUtils.getJavaType(project == null ? null : project.getProject(), this._interface.getInterface()) == null) {
            return new Status(2, "org.switchyard.tools.ui", Messages.JavaInterfaceControlAdapter_statusMessage_SelectedTypeNotOnClasspath);
        }
        return Status.OK_STATUS;
    }
}

