/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.switchyard.tools.models.switchyard1_0.switchyard.EsbInterface;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardPackage;
import org.switchyard.tools.ui.common.IInterfaceControlAdapter;
import org.switchyard.tools.ui.common.impl.ESBInterfaceControlAdapter;
import org.switchyard.tools.ui.common.impl.JavaInterfaceControlAdapter;
import org.switchyard.tools.ui.common.impl.WSDLInterfaceControlAdapter;
import org.switchyard.tools.ui.i18n.Messages;

public class InterfaceControl
implements ISelectionProvider {
    private boolean _enabled = true;
    private Button _javaRadio;
    private Button _wsdlRadio;
    private Button _esbRadio;
    private Link _newLink;
    private Text _text;
    private Button _browseButton;
    private IInterfaceControlAdapter _adapter;
    private Set<InterfaceType> _supportedTypes;
    private Interface _interface;
    private Interface _related;
    private IJavaProject _project;
    private Set<ISelectionChangedListener> _listeners = new LinkedHashSet<ISelectionChangedListener>();
    private Map<EClass, IInterfaceControlAdapter> _adapters = new HashMap<EClass, IInterfaceControlAdapter>();

    public static String getSimpleServiceInterfaceName(Interface intf) {
        if (intf == null) {
            return "";
        }
        if (intf instanceof JavaInterface) {
            String serviceInterfaceName = ((JavaInterface)intf).getInterface();
            if (serviceInterfaceName == null) {
                return "";
            }
            int lastDotIndex = serviceInterfaceName.lastIndexOf(46);
            if (lastDotIndex > 0) {
                return serviceInterfaceName.substring(lastDotIndex + 1);
            }
            return serviceInterfaceName;
        }
        if (intf instanceof WSDLPortType) {
            String serviceInterfaceName = ((WSDLPortType)intf).getInterface();
            if (serviceInterfaceName == null) {
                return "";
            }
            Pattern pattern = Pattern.compile(".*#wsdl\\.porttype\\(([^\\)]*)\\)");
            Matcher matcher = pattern.matcher(serviceInterfaceName);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return "";
        }
        if (intf instanceof EsbInterface) {
            return Messages.InterfaceControl_DefaultESBInterface_ServiceName;
        }
        return "";
    }

    public InterfaceControl(IJavaProject project) {
        this(project, EnumSet.allOf(InterfaceType.class));
    }

    public InterfaceControl(IJavaProject project, Set<InterfaceType> supportedTypes) {
        this._project = project;
        this._supportedTypes = supportedTypes;
        this._adapters.put(InterfaceType.Java.eClass(), new JavaInterfaceControlAdapter());
        this._adapters.put(InterfaceType.WSDL.eClass(), new WSDLInterfaceControlAdapter());
        this._adapters.put(InterfaceType.ESB.eClass(), new ESBInterfaceControlAdapter());
    }

    public void createControl(Composite parent, int numColumns) {
        Label label = new Label(parent, 0);
        label.setText(Messages.InterfaceControl_Label);
        Composite group = new Composite(parent, 32);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, numColumns - 2, 1));
        this._javaRadio = new Button(group, 16);
        this._javaRadio.setText(Messages.InterfaceControl_JavaRadioLabel);
        this._javaRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InterfaceControl.this.updateAdapter((IInterfaceControlAdapter)InterfaceControl.this._adapters.get(InterfaceType.Java.eClass()));
            }
        });
        this._wsdlRadio = new Button(group, 16);
        this._wsdlRadio.setText(Messages.InterfaceControl_WSDLRadioLabel);
        this._wsdlRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InterfaceControl.this.updateAdapter((IInterfaceControlAdapter)InterfaceControl.this._adapters.get(InterfaceType.WSDL.eClass()));
            }
        });
        this._esbRadio = new Button(group, 16);
        this._esbRadio.setText(Messages.InterfaceControl_ESBRadioLabel);
        this._esbRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InterfaceControl.this.updateAdapter((IInterfaceControlAdapter)InterfaceControl.this._adapters.get(InterfaceType.ESB.eClass()));
            }
        });
        label = new Label(parent, 0);
        this._newLink = new Link(parent, 0);
        this._newLink.setText(Messages.InterfaceControl_InterfaceLinkLabel);
        this._newLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InterfaceControl.this.openInterface();
            }
        });
        this._text = new Text(parent, 2056);
        this._text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, numColumns - 2, 1));
        this._text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                InterfaceControl.this.fireSelectionChanged();
            }
        });
        this._browseButton = new Button(parent, 8);
        this._browseButton.setText(Messages.InterfaceControl_BrowseButtonLabel);
        this._browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this._browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InterfaceControl.this.handleBrowse();
            }
        });
        this.init(this._interface, this._related);
        this.setEnabled(this._enabled);
    }

    public void setSupportedTypes(Set<InterfaceType> supportedTypes) {
        this._supportedTypes = supportedTypes;
        this.setEnabled(this.getEnabled());
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
        if (this._newLink == null) {
            return;
        }
        this._newLink.setEnabled(this._enabled);
        this._text.setEnabled(this._enabled);
        this._browseButton.setEnabled(this._enabled);
        this._javaRadio.setEnabled(this._enabled && this._supportedTypes.contains((Object)InterfaceType.Java));
        this._wsdlRadio.setEnabled(this._enabled && this._supportedTypes.contains((Object)InterfaceType.WSDL));
        this._esbRadio.setEnabled(this._enabled && this._supportedTypes.contains((Object)InterfaceType.ESB));
    }

    public IStatus getStatus() {
        if (this._adapter == null) {
            return new Status(4, "org.switchyard.tools.ui", Messages.InterfaceControl_InterfaceTypeRequiredMessage);
        }
        return this._adapter.validate(this._project);
    }

    public void setProject(IJavaProject project) {
        this._project = project;
    }

    public Interface getInterface() {
        if (this._adapter == null) {
            return null;
        }
        return this._adapter.getInterface();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.add(listener);
    }

    public ISelection getSelection() {
        if (this._adapter == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this._adapter.getInterface());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof Interface) {
            this.init((Interface)obj, this._related);
        }
    }

    public void init(Interface intf, Interface related) {
        this._interface = intf;
        this._related = related;
        IInterfaceControlAdapter adapter = this.getAdapter(intf);
        if (adapter != null) {
            adapter.init(this._interface);
            adapter.setRelatedInterface(this._related);
        }
        if (this._javaRadio == null) {
            this._adapter = adapter;
            this.fireSelectionChanged();
            return;
        }
        Object radio = adapter instanceof JavaInterfaceControlAdapter ? this._javaRadio : (adapter instanceof WSDLInterfaceControlAdapter ? this._wsdlRadio : (adapter instanceof ESBInterfaceControlAdapter ? this._esbRadio : null));
        if (radio == null) {
            this._text.setText("");
            return;
        }
        this._javaRadio.setSelection(radio.equals(this._javaRadio));
        this._wsdlRadio.setSelection(radio.equals(this._wsdlRadio));
        this._esbRadio.setSelection(radio.equals(this._esbRadio));
        this.updateAdapter(adapter);
    }

    private void fireSelectionChanged() {
        LinkedHashSet<ISelectionChangedListener> listeners = new LinkedHashSet<ISelectionChangedListener>(this._listeners);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : listeners) {
            try {
                listener.selectionChanged(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private IInterfaceControlAdapter getAdapter(Interface intf) {
        if (intf == null) {
            if (this._supportedTypes.contains((Object)InterfaceType.Java)) {
                return this._adapters.get(InterfaceType.Java.eClass());
            }
            if (this._supportedTypes.contains((Object)InterfaceType.WSDL)) {
                return this._adapters.get(InterfaceType.WSDL.eClass());
            }
            if (this._supportedTypes.contains((Object)InterfaceType.ESB)) {
                return this._adapters.get(InterfaceType.ESB.eClass());
            }
        }
        return this._adapters.get(intf.eClass());
    }

    private void updateAdapter(IInterfaceControlAdapter adapter) {
        this._adapter = adapter;
        if (adapter != null) {
            if (adapter.getText() != null) {
                this._text.setText(adapter.getText());
            }
            adapter.setRelatedInterface(this._related);
        }
    }

    private void handleBrowse() {
        if (this._adapter.browse(this._browseButton.getShell(), (IJavaElement)this._project)) {
            this._text.setText(this._adapter.getText());
        }
    }

    private void openInterface() {
        if (this._adapter.open(this._browseButton.getShell(), this._project, true)) {
            this._text.setText(this._adapter.getText());
        }
    }

    public static enum InterfaceType {
        Java(ScaPackage.eINSTANCE.getJavaInterface()),
        WSDL(ScaPackage.eINSTANCE.getWSDLPortType()),
        ESB(SwitchyardPackage.eINSTANCE.getEsbInterface());

        private EClass _eClass;

        public static boolean interfacesAreCompatible(Component component, Set<InterfaceType> types) {
            Interface intf;
            if (component == null) {
                return true;
            }
            if (types == null || types.size() == 0) {
                return false;
            }
            boolean retVal = true;
            Iterator serviceIt = component.getService().iterator();
            while (serviceIt.hasNext() && retVal) {
                ComponentService service = (ComponentService)serviceIt.next();
                intf = service == null ? null : service.getInterface();
                boolean bl = retVal = retVal && InterfaceType.isInstance(intf, types);
            }
            Iterator referenceIt = component.getReference().iterator();
            while (referenceIt.hasNext() && retVal) {
                ComponentReference reference = (ComponentReference)referenceIt.next();
                intf = reference == null ? null : reference.getInterface();
                boolean bl = retVal = retVal && InterfaceType.isInstance(intf, types);
            }
            return retVal;
        }

        public static boolean isInstance(Interface intf, Set<InterfaceType> types) {
            boolean interfaceIsCompatible = false;
            Iterator<InterfaceType> typeIt = types.iterator();
            while (typeIt.hasNext() && !interfaceIsCompatible) {
                interfaceIsCompatible = typeIt.next().isInstance(intf);
            }
            return interfaceIsCompatible;
        }

        public EClass eClass() {
            return this._eClass;
        }

        public boolean isInstance(Interface intf) {
            return this._eClass.isInstance((Object)intf);
        }

        private InterfaceType(EClass eClass) {
            this._eClass = eClass;
        }

        public static InterfaceType valueOf(String string) {
            return Enum.valueOf(InterfaceType.class, string);
        }
    }
}

